/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.java.AnnotationLoadingUtil;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMapBuilder;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public class JavaToKotlinClassMap
extends JavaToKotlinClassMapBuilder
implements PlatformToKotlinClassMap {
    public static final FqName JAVA_LANG_DEPRECATED = new FqName("java.lang.Deprecated");
    private static JavaToKotlinClassMap instance = null;
    private final Map<FqName, ClassDescriptor> classDescriptorMap = new HashMap<FqName, ClassDescriptor>();
    private final Map<FqName, ClassDescriptor> classDescriptorMapForCovariantPositions = new HashMap<FqName, ClassDescriptor>();
    private final Map<String, JetType> primitiveTypesMap = new HashMap<String, JetType>();
    private final Map<FqName, Collection<ClassDescriptor>> packagesWithMappedClasses = new HashMap<FqName, Collection<ClassDescriptor>>();

    @NotNull
    public static JavaToKotlinClassMap getInstance() {
        if (instance == null) {
            instance = new JavaToKotlinClassMap();
        }
        JavaToKotlinClassMap javaToKotlinClassMap = instance;
        if (javaToKotlinClassMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "getInstance"));
        }
        return javaToKotlinClassMap;
    }

    private JavaToKotlinClassMap() {
        this.init();
        this.initPrimitives();
    }

    private void initPrimitives() {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            String name = jvmPrimitiveType.getName();
            FqName wrapperFqName = jvmPrimitiveType.getWrapperFqName();
            this.register(wrapperFqName, builtIns.getPrimitiveClassDescriptor(primitiveType));
            this.primitiveTypesMap.put(name, builtIns.getPrimitiveJetType(primitiveType));
            this.primitiveTypesMap.put("[" + name, builtIns.getPrimitiveArrayJetType(primitiveType));
            this.primitiveTypesMap.put(wrapperFqName.asString(), builtIns.getNullablePrimitiveJetType(primitiveType));
        }
        this.primitiveTypesMap.put("void", KotlinBuiltIns.getInstance().getUnitType());
    }

    @Nullable
    public JetType mapPrimitiveKotlinClass(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPrimitiveKotlinClass"));
        }
        return this.primitiveTypesMap.get(name);
    }

    @Nullable
    public ClassDescriptor mapKotlinClass(@NotNull FqName fqName, @NotNull TypeUsage typeUsage2) {
        ClassDescriptor descriptor;
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapKotlinClass"));
        }
        if (typeUsage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeUsage", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapKotlinClass"));
        }
        if ((typeUsage2 == TypeUsage.MEMBER_SIGNATURE_COVARIANT || typeUsage2 == TypeUsage.SUPERTYPE) && (descriptor = this.classDescriptorMapForCovariantPositions.get(fqName)) != null) {
            return descriptor;
        }
        return this.classDescriptorMap.get(fqName);
    }

    @Nullable
    public AnnotationDescriptor mapToAnnotationClass(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapToAnnotationClass"));
        }
        ClassDescriptor classDescriptor = this.classDescriptorMap.get(fqName);
        if (classDescriptor != null && fqName.equals(JAVA_LANG_DEPRECATED)) {
            return JavaToKotlinClassMap.getAnnotationDescriptorForJavaLangDeprecated(classDescriptor);
        }
        return null;
    }

    @NotNull
    private static AnnotationDescriptor getAnnotationDescriptorForJavaLangDeprecated(@NotNull ClassDescriptor annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "getAnnotationDescriptorForJavaLangDeprecated"));
        }
        AnnotationDescriptorImpl annotation = new AnnotationDescriptorImpl();
        annotation.setAnnotationType(annotationClass.getDefaultType());
        ValueParameterDescriptor value = DescriptorResolverUtils.getAnnotationParameterByName(AnnotationLoadingUtil.DEFAULT_ANNOTATION_MEMBER_NAME, annotationClass);
        assert (value != null) : "jet.deprecated must have one parameter called value";
        annotation.setValueArgument(value, new StringValue("Deprecated in Java", true));
        AnnotationDescriptorImpl annotationDescriptorImpl = annotation;
        if (annotationDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "getAnnotationDescriptorForJavaLangDeprecated"));
        }
        return annotationDescriptorImpl;
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.JAVA_TO_KOTLIN) {
            this.register(DescriptorResolverUtils.fqNameByClass(javaClass), kotlinDescriptor);
        }
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinMutableDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.JAVA_TO_KOTLIN) {
            FqName javaClassName = DescriptorResolverUtils.fqNameByClass(javaClass);
            this.register(javaClassName, kotlinDescriptor);
            this.registerCovariant(javaClassName, kotlinMutableDescriptor);
        }
    }

    private void register(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassName", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        this.classDescriptorMap.put(javaClassName, kotlinDescriptor);
        this.registerClassInPackage(javaClassName.parent(), kotlinDescriptor);
    }

    private void registerCovariant(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassName", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "registerCovariant"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "registerCovariant"));
        }
        this.classDescriptorMapForCovariantPositions.put(javaClassName, kotlinDescriptor);
        this.registerClassInPackage(javaClassName.parent(), kotlinDescriptor);
    }

    private void registerClassInPackage(@NotNull FqName packageFqName, @NotNull ClassDescriptor kotlinDescriptor) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "registerClassInPackage"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "registerClassInPackage"));
        }
        Collection<ClassDescriptor> classesInPackage = this.packagesWithMappedClasses.get(packageFqName);
        if (classesInPackage == null) {
            classesInPackage = new HashSet<ClassDescriptor>();
            this.packagesWithMappedClasses.put(packageFqName, classesInPackage);
        }
        classesInPackage.add(kotlinDescriptor);
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        ClassDescriptor kotlinAnalog = this.classDescriptorMap.get(fqName);
        ClassDescriptor kotlinCovariantAnalog = this.classDescriptorMapForCovariantPositions.get(fqName);
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>(2);
        if (kotlinAnalog != null) {
            descriptors.add(kotlinAnalog);
        }
        if (kotlinCovariantAnalog != null) {
            descriptors.add(kotlinCovariantAnalog);
        }
        ArrayList<ClassDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        FqNameUnsafe className = DescriptorUtils.getFqName(classDescriptor);
        if (!className.isSafe()) {
            List<ClassDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
            }
            return list2;
        }
        Collection<ClassDescriptor> collection = this.mapPlatformClass(className.toSafe());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClassesInside(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClassesInside"));
        }
        FqNameUnsafe fqName = DescriptorUtils.getFqName(containingDeclaration);
        if (!fqName.isSafe()) {
            List<ClassDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClassesInside"));
            }
            return list2;
        }
        Collection<ClassDescriptor> result = this.packagesWithMappedClasses.get(fqName.toSafe());
        Collection<Object> collection = result == null ? Collections.emptySet() : Collections.unmodifiableCollection(result);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClassesInside"));
        }
        return collection;
    }
}

