/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFunctionType;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetSelfType;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.mapping.KotlinToJavaTypesMap;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class TypeTransformingVisitor
extends JetVisitor<JetType, Void> {
    private static boolean strictMode = false;
    private final JetType originalType;
    private final Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters;
    private final TypeUsage typeUsage;

    private TypeTransformingVisitor(JetType originalType, Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters, TypeUsage typeUsage2) {
        this.originalType = originalType;
        this.typeUsage = typeUsage2;
        this.originalToAltTypeParameters = Collections.unmodifiableMap(originalToAltTypeParameters);
    }

    @NotNull
    public static JetType computeType(@NotNull JetTypeElement alternativeTypeElement, @NotNull JetType originalType, @NotNull Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters, @NotNull TypeUsage typeUsage2) {
        if (alternativeTypeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alternativeTypeElement", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        if (originalToAltTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToAltTypeParameters", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        if (typeUsage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeUsage", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        JetType computedType = alternativeTypeElement.accept(new TypeTransformingVisitor(originalType, originalToAltTypeParameters, typeUsage2), null);
        assert (computedType != null);
        JetType jetType = computedType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        return jetType;
    }

    @Override
    public JetType visitNullableType(@NotNull JetNullableType nullableType, Void aVoid) {
        if (nullableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullableType", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitNullableType"));
        }
        if (!this.originalType.isNullable() && this.typeUsage != TypeUsage.TYPE_ARGUMENT) {
            throw new AlternativeSignatureMismatchException("Auto type '%s' is not-null, while type in alternative signature is nullable: '%s'", DescriptorRenderer.TEXT.renderType(this.originalType), nullableType.getText());
        }
        return TypeUtils.makeNullable(TypeTransformingVisitor.computeType(nullableType.getInnerType(), this.originalType, this.originalToAltTypeParameters, this.typeUsage));
    }

    @Override
    public JetType visitFunctionType(@NotNull JetFunctionType type, Void data2) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitFunctionType"));
        }
        return this.visitCommonType(type.getReceiverTypeRef() == null ? KotlinBuiltIns.getInstance().getFunction(type.getParameters().size()) : KotlinBuiltIns.getInstance().getExtensionFunction(type.getParameters().size()), (JetTypeElement)type);
    }

    @Override
    public JetType visitUserType(@NotNull JetUserType type, Void data2) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitUserType"));
        }
        JetUserType qualifier = type.getQualifier();
        String shortName = type.getReferenceExpression().getReferencedName();
        String longName = (qualifier == null ? "" : qualifier.getText() + ".") + shortName;
        return this.visitCommonType(longName, (JetTypeElement)type);
    }

    private JetType visitCommonType(@NotNull ClassDescriptor classDescriptor, @NotNull JetTypeElement type) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        return this.visitCommonType(DescriptorUtils.getFqNameSafe(classDescriptor).asString(), type);
    }

    @NotNull
    private JetType visitCommonType(@NotNull String qualifiedName, @NotNull JetTypeElement type) {
        JetScope memberScope;
        List<TypeProjection> arguments2;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        if (this.originalType.isError()) {
            JetType jetType = this.originalType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
            }
            return jetType;
        }
        TypeConstructor originalTypeConstructor = this.originalType.getConstructor();
        ClassifierDescriptor declarationDescriptor = originalTypeConstructor.getDeclarationDescriptor();
        assert (declarationDescriptor != null);
        FqName originalClassFqName = DescriptorUtils.getFqNameSafe(declarationDescriptor);
        ClassDescriptor classFromLibrary = TypeTransformingVisitor.getAutoTypeAnalogWithinBuiltins(originalClassFqName, qualifiedName);
        if (!TypeTransformingVisitor.isSameName(qualifiedName, originalClassFqName.asString()) && classFromLibrary == null) {
            throw new AlternativeSignatureMismatchException("Alternative signature type mismatch, expected: %s, actual: %s", qualifiedName, originalClassFqName);
        }
        TypeConstructor typeConstructor = classFromLibrary != null ? classFromLibrary.getTypeConstructor() : originalTypeConstructor;
        ClassifierDescriptor typeConstructorClassifier = typeConstructor.getDeclarationDescriptor();
        if (typeConstructorClassifier instanceof TypeParameterDescriptor && this.originalToAltTypeParameters.containsKey(typeConstructorClassifier)) {
            typeConstructor = this.originalToAltTypeParameters.get(typeConstructorClassifier).getTypeConstructor();
        }
        if ((arguments2 = this.originalType.getArguments()).size() != type.getTypeArgumentsAsTypes().size()) {
            throw new AlternativeSignatureMismatchException("'%s' type in method signature has %d type arguments, while '%s' in alternative signature has %d of them", DescriptorRenderer.TEXT.renderType(this.originalType), arguments2.size(), type.getText(), type.getTypeArgumentsAsTypes().size());
        }
        ArrayList<TypeProjection> altArguments = new ArrayList<TypeProjection>();
        int size = arguments2.size();
        for (int i = 0; i < size; ++i) {
            altArguments.add(this.getAltArgument(type, typeConstructor, i, arguments2.get(i)));
        }
        if (typeConstructorClassifier instanceof TypeParameterDescriptor) {
            memberScope = ((TypeParameterDescriptor)typeConstructorClassifier).getUpperBoundsAsType().getMemberScope();
        } else if (typeConstructorClassifier instanceof ClassDescriptor) {
            memberScope = ((ClassDescriptor)typeConstructorClassifier).getMemberScope(altArguments);
        } else {
            throw new AssertionError((Object)("Unexpected class of type constructor classifier " + (typeConstructorClassifier == null ? "null" : typeConstructorClassifier.getClass().getName())));
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(this.originalType.getAnnotations(), typeConstructor, false, altArguments, memberScope);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        return jetTypeImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private TypeProjection getAltArgument(@NotNull JetTypeElement type, @NotNull TypeConstructor typeConstructor, int i, @NotNull TypeProjection originalArgument) {
        Variance altProjectionKind;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        if (originalArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalArgument", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        JetTypeReference typeReference = type.getTypeArgumentsAsTypes().get(i);
        if (typeReference == null) {
            assert (type instanceof JetUserType && ((JetUserType)type).getTypeArguments().get(i).getProjectionKind() == JetProjectionKind.STAR);
            TypeProjection typeProjection = originalArgument;
            if (typeProjection != null) return typeProjection;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        JetTypeElement argumentAlternativeTypeElement = typeReference.getTypeElement();
        assert (argumentAlternativeTypeElement != null);
        TypeParameterDescriptor parameter = typeConstructor.getParameters().get(i);
        JetType alternativeArgumentType = TypeTransformingVisitor.computeType(argumentAlternativeTypeElement, originalArgument.getType(), this.originalToAltTypeParameters, TypeUsage.TYPE_ARGUMENT);
        Variance projectionKind = originalArgument.getProjectionKind();
        if (type instanceof JetUserType) {
            JetTypeProjection typeProjection = ((JetUserType)type).getTypeArguments().get(i);
            altProjectionKind = TypeResolver.resolveProjectionKind(typeProjection.getProjectionKind());
            if (altProjectionKind != projectionKind && projectionKind != Variance.INVARIANT) {
                throw new AlternativeSignatureMismatchException("Projection kind mismatch, actual: %s, in alternative signature: %s", new Object[]{projectionKind, altProjectionKind});
            }
            if (altProjectionKind != Variance.INVARIANT && parameter.getVariance() != Variance.INVARIANT) {
                if (altProjectionKind != parameter.getVariance()) throw new AlternativeSignatureMismatchException("Projection kind '%s' is conflicting with variance of %s", new Object[]{altProjectionKind, DescriptorUtils.getFqName(typeConstructor.getDeclarationDescriptor())});
                if (strictMode) {
                    throw new AlternativeSignatureMismatchException("Projection kind '%s' is redundant", new Object[]{altProjectionKind, DescriptorUtils.getFqName(typeConstructor.getDeclarationDescriptor())});
                }
                altProjectionKind = projectionKind;
            }
        } else {
            altProjectionKind = projectionKind;
        }
        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(altProjectionKind, alternativeArgumentType);
        if (typeProjectionImpl != null) return typeProjectionImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
    }

    @Nullable
    private static ClassDescriptor getAutoTypeAnalogWithinBuiltins(@NotNull FqName originalClassFqName, @NotNull String qualifiedName) {
        if (originalClassFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalClassFqName", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "getAutoTypeAnalogWithinBuiltins"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "getAutoTypeAnalogWithinBuiltins"));
        }
        FqName javaFqName = KotlinToJavaTypesMap.getInstance().getKotlinToJavaFqName(originalClassFqName);
        if (javaFqName == null) {
            return null;
        }
        Collection<ClassDescriptor> descriptors = JavaToKotlinClassMap.getInstance().mapPlatformClass(javaFqName);
        for (ClassDescriptor descriptor : descriptors) {
            String fqName = DescriptorUtils.getFqName(descriptor).asString();
            if (!TypeTransformingVisitor.isSameName(qualifiedName, fqName)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public JetType visitSelfType(@NotNull JetSelfType type, Void data2) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/TypeTransformingVisitor", "visitSelfType"));
        }
        throw new UnsupportedOperationException("Self-types are not supported yet");
    }

    private static boolean isSameName(String qualifiedName, String fullyQualifiedName) {
        return fullyQualifiedName.equals(qualifiedName) || fullyQualifiedName.endsWith("." + qualifiedName);
    }

    public static void setStrictMode(boolean strictMode) {
        TypeTransformingVisitor.strictMode = strictMode;
    }
}

