/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.intellij.openapi.util.text.StringUtil;
import jet.runtime.typeinfo.KotlinSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationOwner;
import org.jetbrains.jet.lang.resolve.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMember;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class SignaturesUtil {
    public static final FqName KOTLIN_SIGNATURE = DescriptorResolverUtils.fqNameByClass(KotlinSignature.class);
    public static final Name KOTLIN_SIGNATURE_VALUE_FIELD_NAME = Name.identifier("value");

    private SignaturesUtil() {
    }

    @Nullable
    public static String getKotlinSignature(@NotNull ExternalAnnotationResolver externalAnnotationResolver, @NotNull JavaMember member) {
        Object value;
        JavaAnnotationArgument argument;
        if (externalAnnotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalAnnotationResolver", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "getKotlinSignature"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "getKotlinSignature"));
        }
        JavaAnnotation annotation = SignaturesUtil.findAnnotationWithExternal(externalAnnotationResolver, member, KOTLIN_SIGNATURE);
        if (annotation != null && (argument = annotation.findArgument(KOTLIN_SIGNATURE_VALUE_FIELD_NAME)) instanceof JavaLiteralAnnotationArgument && (value = ((JavaLiteralAnnotationArgument)argument).getValue()) instanceof String) {
            return StringUtil.unescapeStringCharacters((String)value);
        }
        return null;
    }

    @Nullable
    public static JavaAnnotation findAnnotationWithExternal(@NotNull ExternalAnnotationResolver externalAnnotationResolver, @NotNull JavaAnnotationOwner owner, @NotNull FqName name) {
        if (externalAnnotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalAnnotationResolver", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "findAnnotationWithExternal"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "findAnnotationWithExternal"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/SignaturesUtil", "findAnnotationWithExternal"));
        }
        JavaAnnotation annotation = owner.findAnnotation(name);
        if (annotation != null) {
            return annotation;
        }
        return externalAnnotationResolver.findExternalAnnotation(owner, name);
    }
}

