/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class AnnotationLoadingUtil {
    public static final Name DEFAULT_ANNOTATION_MEMBER_NAME = Name.identifier("value");
    public static final FqName JETBRAINS_NOT_NULL_ANNOTATION = DescriptorResolverUtils.fqNameByClass(NotNull.class);
    public static final FqName JETBRAINS_NULLABLE_ANNOTATION = DescriptorResolverUtils.fqNameByClass(Nullable.class);
    public static final FqName JETBRAINS_MUTABLE_ANNOTATION = new FqName("org.jetbrains.annotations.Mutable");
    public static final FqName JETBRAINS_READONLY_ANNOTATION = new FqName("org.jetbrains.annotations.ReadOnly");
    public static final FqName JL_CLASS_FQ_NAME = new FqName("java.lang.Class");

    public static boolean isSpecialAnnotation(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/AnnotationLoadingUtil", "isSpecialAnnotation"));
        }
        return fqName.asString().startsWith("jet.runtime.typeinfo.") || fqName.equals(JETBRAINS_NOT_NULL_ANNOTATION) || fqName.equals(JvmAnnotationNames.KOTLIN_CLASS) || fqName.equals(JvmAnnotationNames.KOTLIN_PACKAGE);
    }

    private AnnotationLoadingUtil() {
    }
}

