/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class IntegerValueTypeConstructor
implements TypeConstructor {
    private final long value;
    private final Collection<JetType> supertypes = Lists.newArrayList();

    public IntegerValueTypeConstructor(long value) {
        this.value = value;
        this.checkBoundsAndAddSuperType(value, Integer.MIN_VALUE, Integer.MAX_VALUE, KotlinBuiltIns.getInstance().getIntType());
        this.checkBoundsAndAddSuperType(value, -128L, 127L, KotlinBuiltIns.getInstance().getByteType());
        this.checkBoundsAndAddSuperType(value, -32768L, 32767L, KotlinBuiltIns.getInstance().getShortType());
        this.supertypes.add(KotlinBuiltIns.getInstance().getLongType());
    }

    private void checkBoundsAndAddSuperType(long value, long minValue, long maxValue, JetType kotlinType) {
        if (value >= minValue && value <= maxValue) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        Collection<JetType> collection = this.supertypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstructor", "getSupertypes"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        List<TypeParameterDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstructor", "getParameters"));
        }
        return list2;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations = Annotations.EMPTY;
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstructor", "getAnnotations"));
        }
        return annotations;
    }

    public Long getValue() {
        return this.value;
    }

    public String toString() {
        return "IntegerValueType(" + this.value + ")";
    }
}

