/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeBounds;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class ConstraintsUtil {
    @Nullable
    public static TypeParameterDescriptor getFirstConflictingParameter(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getFirstConflictingParameter"));
        }
        for (TypeParameterDescriptor typeParameter : constraintSystem.getTypeVariables()) {
            TypeBounds constraints = constraintSystem.getTypeBounds(typeParameter);
            if (constraints.getValues().size() <= 1) continue;
            return typeParameter;
        }
        return null;
    }

    @NotNull
    public static Collection<TypeSubstitutor> getSubstitutorsForConflictingParameters(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSubstitutorsForConflictingParameters"));
        }
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(constraintSystem);
        if (firstConflictingParameter == null) {
            List<TypeSubstitutor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSubstitutorsForConflictingParameters"));
            }
            return list2;
        }
        Collection<JetType> conflictingTypes = constraintSystem.getTypeBounds(firstConflictingParameter).getValues();
        ArrayList substitutionContexts = Lists.newArrayList();
        for (JetType type : conflictingTypes) {
            LinkedHashMap<TypeConstructor, TypeProjectionImpl> linkedHashMap = Maps.newLinkedHashMap();
            linkedHashMap.put(firstConflictingParameter.getTypeConstructor(), new TypeProjectionImpl(type));
            substitutionContexts.add(linkedHashMap);
        }
        for (TypeParameterDescriptor typeParameter : constraintSystem.getTypeVariables()) {
            if (typeParameter == firstConflictingParameter) continue;
            JetType jetType = ConstraintsUtil.getSafeValue(constraintSystem, typeParameter);
            for (Map map : substitutionContexts) {
                TypeProjectionImpl typeProjection = new TypeProjectionImpl(jetType);
                map.put(typeParameter.getTypeConstructor(), typeProjection);
            }
        }
        ArrayList<TypeSubstitutor> typeSubstitutors = Lists.newArrayList();
        for (Map map : substitutionContexts) {
            typeSubstitutors.add(TypeSubstitutor.create(map));
        }
        ArrayList<TypeSubstitutor> arrayList = typeSubstitutors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSubstitutorsForConflictingParameters"));
        }
        return arrayList;
    }

    @NotNull
    public static JetType getSafeValue(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
        }
        JetType type = constraintSystem.getTypeBounds(typeParameter).getValue();
        if (type != null) {
            JetType jetType = type;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
            }
            return jetType;
        }
        JetType jetType = typeParameter.getUpperBoundsAsType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getSafeValue"));
        }
        return jetType;
    }

    public static boolean checkUpperBoundIsSatisfied(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter, boolean substituteOtherTypeParametersInBound) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "checkUpperBoundIsSatisfied"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "checkUpperBoundIsSatisfied"));
        }
        JetType type = constraintSystem.getTypeBounds(typeParameter).getValue();
        if (type == null) {
            return true;
        }
        for (JetType upperBound : typeParameter.getUpperBounds()) {
            if (!substituteOtherTypeParametersInBound && TypeUtils.dependsOnTypeParameters(upperBound, constraintSystem.getTypeVariables())) continue;
            JetType substitutedUpperBound = constraintSystem.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            assert (substitutedUpperBound != null) : "We wanted to substitute projections as a result for " + typeParameter;
            if (JetTypeChecker.INSTANCE.isSubtypeOf(type, substitutedUpperBound)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkBoundsAreSatisfied(@NotNull ConstraintSystem constraintSystem, boolean substituteOtherTypeParametersInBounds) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "checkBoundsAreSatisfied"));
        }
        for (TypeParameterDescriptor typeVariable : constraintSystem.getTypeVariables()) {
            if (ConstraintsUtil.checkUpperBoundIsSatisfied(constraintSystem, typeVariable, substituteOtherTypeParametersInBounds)) continue;
            return false;
        }
        return true;
    }

    public static String getDebugMessageForStatus(@NotNull ConstraintSystemStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil", "getDebugMessageForStatus"));
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Method> interestingMethods = Lists.newArrayList();
        for (Method method2 : status.getClass().getMethods()) {
            boolean isInteresting;
            String name = method2.getName();
            boolean bl = isInteresting = name.startsWith("is") || name.startsWith("has") && !name.equals("hashCode");
            if (method2.getParameterTypes().length != 0 || !isInteresting) continue;
            interestingMethods.add(method2);
        }
        Collections.sort(interestingMethods, new Comparator<Method>(){

            @Override
            public int compare(@NotNull Method method1, @NotNull Method method2) {
                if (method1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil$1", "compare"));
                }
                if (method2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintsUtil$1", "compare"));
                }
                return method1.getName().compareTo(method2.getName());
            }
        });
        Iterator iterator2 = interestingMethods.iterator();
        while (iterator2.hasNext()) {
            Method method3 = (Method)iterator2.next();
            try {
                sb.append("-").append(method3.getName()).append(": ").append(method3.invoke((Object)status, new Object[0]));
                if (!iterator2.hasNext()) continue;
                sb.append("\n");
            }
            catch (IllegalAccessException e) {
                sb.append(e.getMessage());
            }
            catch (InvocationTargetException e) {
                sb.append(e.getMessage());
            }
        }
        return sb.toString();
    }
}

