/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;

public class ScriptBodyResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private BindingTrace trace;

    public void setContext(@NotNull TopDownAnalysisContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "setContext"));
        }
    }

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void resolveScriptBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/ScriptBodyResolver", "resolveScriptBodies"));
        }
        for (Map.Entry<JetScript, ScriptDescriptor> e : c.getScripts().entrySet()) {
            JetScript declaration = e.getKey();
            ScriptDescriptor descriptor = e.getValue();
            WritableScope scope = c.getScriptScopes().get(declaration);
            scope.changeLockLevel(WritableScope.LockLevel.READING);
            ExpressionTypingContext context = ExpressionTypingContext.newContext(this.expressionTypingServices, this.trace, scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE);
            JetType returnType2 = this.expressionTypingServices.getBlockReturnedType(declaration.getBlockExpression(), CoercionStrategy.NO_COERCION, context).getType();
            if (returnType2 == null) {
                returnType2 = ErrorUtils.createErrorType("getBlockReturnedType returned null");
            }
            ArrayList<PropertyDescriptorImpl> properties = new ArrayList<PropertyDescriptorImpl>();
            ArrayList<SimpleFunctionDescriptor> functions2 = new ArrayList<SimpleFunctionDescriptor>();
            BindingContext bindingContext = this.trace.getBindingContext();
            for (JetDeclaration jetDeclaration : declaration.getDeclarations()) {
                if (jetDeclaration instanceof JetProperty) {
                    properties.add((PropertyDescriptorImpl)bindingContext.get(BindingContext.VARIABLE, jetDeclaration));
                    continue;
                }
                if (!(jetDeclaration instanceof JetNamedFunction)) continue;
                SimpleFunctionDescriptor function = bindingContext.get(BindingContext.FUNCTION, jetDeclaration);
                assert (function != null);
                functions2.add(function.copy(descriptor.getClassDescriptor(), function.getModality(), function.getVisibility(), CallableMemberDescriptor.Kind.DECLARATION, false));
            }
            descriptor.initialize(returnType2, properties, functions2);
        }
    }
}

