/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Collection;
import java.util.List;
import jet.runtime.Intrinsic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CompileTimeConstantUtils {
    public static void checkConstructorParametersType(@NotNull List<JetParameter> parameters, @NotNull BindingTrace trace) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/lang/resolve/CompileTimeConstantUtils", "checkConstructorParametersType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/CompileTimeConstantUtils", "checkConstructorParametersType"));
        }
        for (JetParameter parameter : parameters) {
            VariableDescriptor parameterDescriptor = trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
            if (parameterDescriptor == null) continue;
            JetType parameterType = parameterDescriptor.getType();
            JetTypeReference typeReference = parameter.getTypeReference();
            if (typeReference == null) continue;
            if (parameterType.isNullable()) {
                trace.report(Errors.NULLABLE_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
                continue;
            }
            if (CompileTimeConstantUtils.isAcceptableTypeForAnnotationParameter(parameterType)) continue;
            trace.report(Errors.INVALID_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
        }
    }

    private static boolean isAcceptableTypeForAnnotationParameter(@NotNull JetType parameterType) {
        List<TypeProjection> arguments2;
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/jet/lang/resolve/CompileTimeConstantUtils", "isAcceptableTypeForAnnotationParameter"));
        }
        ClassDescriptor typeDescriptor = TypeUtils.getClassDescriptor(parameterType);
        if (typeDescriptor == null) {
            return false;
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        if (DescriptorUtils.isEnumClass(typeDescriptor) || DescriptorUtils.isAnnotationClass(typeDescriptor) || CompileTimeConstantUtils.isJavaLangClass(typeDescriptor) || builtIns.isPrimitiveArray(parameterType) || builtIns.isPrimitiveType(parameterType) || ((Object)builtIns.getStringType()).equals(parameterType)) {
            return true;
        }
        if (builtIns.isArray(parameterType) && (arguments2 = parameterType.getArguments()).size() == 1) {
            JetType arrayType = arguments2.get(0).getType();
            if (arrayType.isNullable()) {
                return false;
            }
            ClassDescriptor arrayTypeDescriptor = TypeUtils.getClassDescriptor(arrayType);
            if (arrayTypeDescriptor != null) {
                return DescriptorUtils.isEnumClass(arrayTypeDescriptor) || DescriptorUtils.isAnnotationClass(arrayTypeDescriptor) || CompileTimeConstantUtils.isJavaLangClass(arrayTypeDescriptor) || ((Object)builtIns.getStringType()).equals(arrayType);
            }
        }
        return false;
    }

    @Nullable
    public static String getIntrinsicAnnotationArgument(@NotNull Annotated annotatedDescriptor) {
        if (annotatedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotatedDescriptor", "org/jetbrains/jet/lang/resolve/CompileTimeConstantUtils", "getIntrinsicAnnotationArgument"));
        }
        AnnotationDescriptor intrinsicAnnotation = annotatedDescriptor.getAnnotations().findAnnotation(new FqName(Intrinsic.class.getName()));
        if (intrinsicAnnotation == null) {
            return null;
        }
        Collection<CompileTimeConstant<?>> values2 = intrinsicAnnotation.getAllValueArguments().values();
        if (values2.isEmpty()) {
            return null;
        }
        Object value = values2.iterator().next().getValue();
        return value instanceof String ? (String)value : null;
    }

    public static boolean isArrayMethodCall(@NotNull ResolvedCall resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/CompileTimeConstantUtils", "isArrayMethodCall"));
        }
        return "kotlin.arrays.array".equals(CompileTimeConstantUtils.getIntrinsicAnnotationArgument(resolvedCall.getResultingDescriptor().getOriginal()));
    }

    public static boolean isJavaClassMethodCall(@NotNull ResolvedCall resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/CompileTimeConstantUtils", "isJavaClassMethodCall"));
        }
        return "kotlin.javaClass.function".equals(CompileTimeConstantUtils.getIntrinsicAnnotationArgument(resolvedCall.getResultingDescriptor().getOriginal()));
    }

    public static boolean isPropertyCompileTimeConstant(@NotNull VariableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/CompileTimeConstantUtils", "isPropertyCompileTimeConstant"));
        }
        if (descriptor.isVar()) {
            return false;
        }
        if (DescriptorUtils.isClassObject(descriptor.getContainingDeclaration()) || DescriptorUtils.isTopLevelDeclaration(descriptor)) {
            JetType type = descriptor.getType();
            return KotlinBuiltIns.getInstance().isPrimitiveType(type) || ((Object)KotlinBuiltIns.getInstance().getStringType()).equals(type);
        }
        return false;
    }

    public static boolean isJavaLangClass(ClassDescriptor descriptor) {
        return "java.lang.Class".equals(DescriptorUtils.getFqName(descriptor).asString());
    }

    private CompileTimeConstantUtils() {
    }
}

