/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.BlockInfo;
import org.jetbrains.jet.lang.cfg.BreakableBlockInfo;
import org.jetbrains.jet.lang.cfg.GenerationTrigger;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilder;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilderAdapter;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.pseudocode.CallInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.CompilationErrorInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ConditionalJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LoadUnitValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalFunctionDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.MarkInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.NondeterministicJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnNoValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ReturnValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineEnterInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineExitInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ThrowExceptionInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.UnconditionalJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.UnsupportedElementInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.VariableDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.WriteValueInstruction;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;

public class JetControlFlowInstructionsGenerator
extends JetControlFlowBuilderAdapter {
    private JetControlFlowBuilder builder = null;
    private final Stack<BreakableBlockInfo> loopInfo = new Stack();
    private final Map<JetElement, BreakableBlockInfo> elementToBlockInfo = new HashMap<JetElement, BreakableBlockInfo>();
    private int labelCount = 0;
    private int allowDeadLabelCount = 0;
    private final Stack<JetControlFlowInstructionsGeneratorWorker> builders = new Stack();
    private final Stack<BlockInfo> allBlocks = new Stack();

    @Override
    @NotNull
    protected JetControlFlowBuilder getDelegateBuilder() {
        JetControlFlowBuilder jetControlFlowBuilder = this.builder;
        if (jetControlFlowBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator", "getDelegateBuilder"));
        }
        return jetControlFlowBuilder;
    }

    private void pushBuilder(JetElement scopingElement, JetElement subroutine) {
        JetControlFlowInstructionsGeneratorWorker worker = new JetControlFlowInstructionsGeneratorWorker(scopingElement, subroutine);
        this.builders.push(worker);
        this.builder = worker;
    }

    private JetControlFlowInstructionsGeneratorWorker popBuilder(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator", "popBuilder"));
        }
        JetControlFlowInstructionsGeneratorWorker worker = this.builders.pop();
        this.builder = !this.builders.isEmpty() ? (JetControlFlowBuilder)this.builders.peek() : null;
        return worker;
    }

    @Override
    public void enterSubroutine(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator", "enterSubroutine"));
        }
        if (this.builder != null && subroutine instanceof JetFunctionLiteral) {
            this.pushBuilder(subroutine, this.builder.getReturnSubroutine());
        } else {
            this.pushBuilder(subroutine, subroutine);
        }
        assert (this.builder != null);
        this.builder.enterSubroutine(subroutine);
    }

    @Override
    @NotNull
    public Pseudocode exitSubroutine(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator", "exitSubroutine"));
        }
        super.exitSubroutine(subroutine);
        JetControlFlowInstructionsGeneratorWorker worker = this.popBuilder(subroutine);
        if (!this.builders.empty()) {
            JetControlFlowInstructionsGeneratorWorker builder = this.builders.peek();
            builder.declareFunction(subroutine, worker.getPseudocode());
        }
        PseudocodeImpl pseudocodeImpl = worker.getPseudocode();
        if (pseudocodeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator", "exitSubroutine"));
        }
        return pseudocodeImpl;
    }

    public static class TryFinallyBlockInfo
    extends BlockInfo {
        private final GenerationTrigger finallyBlock;

        private TryFinallyBlockInfo(GenerationTrigger finallyBlock) {
            this.finallyBlock = finallyBlock;
        }

        public void generateFinallyBlock() {
            this.finallyBlock.generate();
        }
    }

    private class JetControlFlowInstructionsGeneratorWorker
    implements JetControlFlowBuilder {
        private final PseudocodeImpl pseudocode;
        private final Label error;
        private final Label sink;
        private final JetElement returnSubroutine;

        private JetControlFlowInstructionsGeneratorWorker(@NotNull JetElement scopingElement, @NotNull JetElement returnSubroutine) {
            if (scopingElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopingElement", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "<init>"));
            }
            if (returnSubroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnSubroutine", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "<init>"));
            }
            this.pseudocode = new PseudocodeImpl(scopingElement);
            this.error = this.pseudocode.createLabel("error");
            this.sink = this.pseudocode.createLabel("sink");
            this.returnSubroutine = returnSubroutine;
        }

        public PseudocodeImpl getPseudocode() {
            return this.pseudocode;
        }

        private void add(@NotNull Instruction instruction) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "add"));
            }
            this.pseudocode.addInstruction(instruction);
        }

        @Override
        @NotNull
        public final Label createUnboundLabel() {
            PseudocodeImpl.PseudocodeLabel pseudocodeLabel = this.pseudocode.createLabel("L" + JetControlFlowInstructionsGenerator.this.labelCount++);
            if (pseudocodeLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createUnboundLabel"));
            }
            return pseudocodeLabel;
        }

        @Override
        @NotNull
        public Label createUnboundLabel(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createUnboundLabel"));
            }
            PseudocodeImpl.PseudocodeLabel pseudocodeLabel = this.pseudocode.createLabel("L" + JetControlFlowInstructionsGenerator.this.labelCount++ + " [" + name + "]");
            if (pseudocodeLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createUnboundLabel"));
            }
            return pseudocodeLabel;
        }

        @Override
        public final LoopInfo enterLoop(@NotNull JetExpression expression, @Nullable Label loopExitPoint, Label conditionEntryPoint) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterLoop"));
            }
            Label loopEntryLabel = this.createUnboundLabel("loop entry point");
            this.bindLabel(loopEntryLabel);
            LoopInfo blockInfo = new LoopInfo(expression, loopEntryLabel, loopExitPoint != null ? loopExitPoint : this.createUnboundLabel("loop exit point"), this.createUnboundLabel("body entry point"), conditionEntryPoint != null ? conditionEntryPoint : this.createUnboundLabel("condition entry point"));
            JetControlFlowInstructionsGenerator.this.loopInfo.push(blockInfo);
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.put(expression, blockInfo);
            JetControlFlowInstructionsGenerator.this.allBlocks.push(blockInfo);
            this.pseudocode.recordLoopInfo(expression, blockInfo);
            return blockInfo;
        }

        @Override
        public final void exitLoop(@NotNull JetExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitLoop"));
            }
            BreakableBlockInfo info = (BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.loopInfo.pop();
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(expression);
            JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            this.bindLabel(info.getExitPoint());
        }

        @Override
        public JetElement getCurrentLoop() {
            return JetControlFlowInstructionsGenerator.this.loopInfo.empty() ? null : ((BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.loopInfo.peek()).getElement();
        }

        @Override
        public void enterSubroutine(@NotNull JetElement subroutine) {
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterSubroutine"));
            }
            Label entryPoint = this.createUnboundLabel();
            BreakableBlockInfo blockInfo = new BreakableBlockInfo(subroutine, entryPoint, this.createUnboundLabel());
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.put(subroutine, blockInfo);
            JetControlFlowInstructionsGenerator.this.allBlocks.push(blockInfo);
            this.bindLabel(entryPoint);
            this.add(new SubroutineEnterInstruction(subroutine));
        }

        @Override
        @NotNull
        public JetElement getCurrentSubroutine() {
            JetElement jetElement = this.pseudocode.getCorrespondingElement();
            if (jetElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getCurrentSubroutine"));
            }
            return jetElement;
        }

        @Override
        public JetElement getReturnSubroutine() {
            return this.returnSubroutine;
        }

        @Override
        @NotNull
        public Label getEntryPoint(@NotNull JetElement labelElement) {
            if (labelElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getEntryPoint"));
            }
            Label label = ((BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement)).getEntryPoint();
            if (label == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getEntryPoint"));
            }
            return label;
        }

        @Override
        @NotNull
        public Label getExitPoint(@NotNull JetElement labelElement) {
            if (labelElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getExitPoint"));
            }
            BreakableBlockInfo blockInfo = (BreakableBlockInfo)JetControlFlowInstructionsGenerator.this.elementToBlockInfo.get(labelElement);
            assert (blockInfo != null) : labelElement.getText();
            Label label = blockInfo.getExitPoint();
            if (label == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "getExitPoint"));
            }
            return label;
        }

        private void handleJumpInsideTryFinally(Label jumpTarget) {
            ArrayList<TryFinallyBlockInfo> finallyBlocks = new ArrayList<TryFinallyBlockInfo>();
            for (int i = JetControlFlowInstructionsGenerator.this.allBlocks.size() - 1; i >= 0; --i) {
                BlockInfo blockInfo = (BlockInfo)JetControlFlowInstructionsGenerator.this.allBlocks.get(i);
                if (blockInfo instanceof BreakableBlockInfo) {
                    BreakableBlockInfo breakableBlockInfo = (BreakableBlockInfo)blockInfo;
                    if (jumpTarget != breakableBlockInfo.getExitPoint() && jumpTarget != breakableBlockInfo.getEntryPoint() && jumpTarget != this.error) continue;
                    for (int j = finallyBlocks.size() - 1; j >= 0; --j) {
                        ((TryFinallyBlockInfo)finallyBlocks.get(j)).generateFinallyBlock();
                    }
                    break;
                }
                if (!(blockInfo instanceof TryFinallyBlockInfo)) continue;
                TryFinallyBlockInfo tryFinallyBlockInfo = (TryFinallyBlockInfo)blockInfo;
                finallyBlocks.add(tryFinallyBlockInfo);
            }
        }

        @Override
        @NotNull
        public Pseudocode exitSubroutine(@NotNull JetElement subroutine) {
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitSubroutine"));
            }
            this.bindLabel(this.getExitPoint(subroutine));
            this.pseudocode.addExitInstruction(new SubroutineExitInstruction(subroutine, false));
            this.bindLabel(this.error);
            this.pseudocode.addErrorInstruction(new SubroutineExitInstruction(subroutine, true));
            this.bindLabel(this.sink);
            this.pseudocode.addSinkInstruction(new SubroutineSinkInstruction(subroutine, "<SINK>"));
            JetControlFlowInstructionsGenerator.this.elementToBlockInfo.remove(subroutine);
            JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            PseudocodeImpl pseudocodeImpl = this.pseudocode;
            if (pseudocodeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "exitSubroutine"));
            }
            return pseudocodeImpl;
        }

        @Override
        public void mark(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "mark"));
            }
            this.add(new MarkInstruction(element));
        }

        @Override
        public void returnValue(@NotNull JetExpression returnExpression, @NotNull JetElement subroutine) {
            if (returnExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnValue"));
            }
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnValue"));
            }
            Label exitPoint = this.getExitPoint(subroutine);
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnValueInstruction(returnExpression, exitPoint));
        }

        @Override
        public void returnNoValue(@NotNull JetElement returnExpression, @NotNull JetElement subroutine) {
            if (returnExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnNoValue"));
            }
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "returnNoValue"));
            }
            Label exitPoint = this.getExitPoint(subroutine);
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnNoValueInstruction(returnExpression, exitPoint));
        }

        @Override
        public void write(@NotNull JetElement assignment, @NotNull JetElement lValue) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            if (lValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lValue", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "write"));
            }
            this.add(new WriteValueInstruction(assignment, lValue));
        }

        @Override
        public void declareParameter(@NotNull JetParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareParameter"));
            }
            this.add(new VariableDeclarationInstruction(parameter));
        }

        @Override
        public void declareVariable(@NotNull JetVariableDeclaration property2) {
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareVariable"));
            }
            this.add(new VariableDeclarationInstruction(property2));
        }

        @Override
        public void declareFunction(@NotNull JetElement subroutine, @NotNull Pseudocode pseudocode) {
            if (subroutine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareFunction"));
            }
            if (pseudocode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "declareFunction"));
            }
            this.add(new LocalFunctionDeclarationInstruction(subroutine, pseudocode));
        }

        @Override
        public void loadUnit(@NotNull JetExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadUnit"));
            }
            this.add(new LoadUnitValueInstruction(expression));
        }

        @Override
        public void jump(@NotNull Label label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jump"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new UnconditionalJumpInstruction(label));
        }

        @Override
        public void jumpOnFalse(@NotNull Label label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnFalse"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(false, label));
        }

        @Override
        public void jumpOnTrue(@NotNull Label label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "jumpOnTrue"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(true, label));
        }

        @Override
        public void bindLabel(@NotNull Label label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "bindLabel"));
            }
            this.pseudocode.bindLabel(label);
        }

        @Override
        public void nondeterministicJump(@NotNull Label label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            this.handleJumpInsideTryFinally(label);
            this.add(new NondeterministicJumpInstruction(label));
        }

        @Override
        public void nondeterministicJump(@NotNull List<Label> labels) {
            if (labels == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labels", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "nondeterministicJump"));
            }
            this.add(new NondeterministicJumpInstruction(labels));
        }

        @Override
        public void jumpToError() {
            this.handleJumpInsideTryFinally(this.error);
            this.add(new UnconditionalJumpInstruction(this.error));
        }

        @Override
        public void enterTryFinally(@NotNull GenerationTrigger generationTrigger) {
            if (generationTrigger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generationTrigger", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "enterTryFinally"));
            }
            JetControlFlowInstructionsGenerator.this.allBlocks.push(new TryFinallyBlockInfo(generationTrigger));
        }

        @Override
        public void throwException(@NotNull JetThrowExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "throwException"));
            }
            this.handleJumpInsideTryFinally(this.error);
            this.add(new ThrowExceptionInstruction(expression, this.error));
        }

        @Override
        public void exitTryFinally() {
            BlockInfo pop = (BlockInfo)JetControlFlowInstructionsGenerator.this.allBlocks.pop();
            assert (pop instanceof TryFinallyBlockInfo);
        }

        @Override
        public void unsupported(JetElement element) {
            this.add(new UnsupportedElementInstruction(element));
        }

        @Override
        public void repeatPseudocode(@NotNull Label startLabel, @NotNull Label finishLabel) {
            if (startLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startLabel", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "repeatPseudocode"));
            }
            if (finishLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishLabel", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "repeatPseudocode"));
            }
            this.pseudocode.repeatPart(startLabel, finishLabel);
        }

        @Override
        public void loadConstant(@NotNull JetExpression expression, @Nullable CompileTimeConstant<?> constant) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadConstant"));
            }
            this.read(expression);
        }

        @Override
        public void createAnonymousObject(@NotNull JetObjectLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createAnonymousObject"));
            }
            this.read(expression);
        }

        @Override
        public void createFunctionLiteral(@NotNull JetFunctionLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "createFunctionLiteral"));
            }
            this.read(expression);
        }

        @Override
        public void loadStringTemplate(@NotNull JetStringTemplateExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "loadStringTemplate"));
            }
            this.read(expression);
        }

        @Override
        public void readThis(@NotNull JetExpression expression, @Nullable ReceiverParameterDescriptor parameterDescriptor) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readThis"));
            }
            this.read(expression);
        }

        @Override
        public void readVariable(@NotNull JetExpression expression, @Nullable VariableDescriptor variableDescriptor) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "readVariable"));
            }
            this.read(expression);
        }

        @Override
        public void call(@NotNull JetExpression expression, @NotNull ResolvedCall<?> resolvedCall) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "call"));
            }
            this.add(new CallInstruction(expression, resolvedCall));
        }

        @Override
        public void predefinedOperation(@NotNull JetExpression expression, @Nullable JetControlFlowBuilder.PredefinedOperation operation) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "predefinedOperation"));
            }
            this.read(expression);
        }

        @Override
        public void compilationError(@NotNull JetElement element, @NotNull String message) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "compilationError"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "compilationError"));
            }
            this.add(new CompilationErrorInstruction(element, message));
        }

        private void read(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/JetControlFlowInstructionsGenerator$JetControlFlowInstructionsGeneratorWorker", "read"));
            }
            this.add(new ReadValueInstruction(element));
        }
    }
}

