/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.FieldVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.context.PackageFacadeContext;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.GenerationStateAware;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class PropertyCodegen
extends GenerationStateAware {
    @NotNull
    private final FunctionCodegen functionCodegen;
    @NotNull
    private final ClassBuilder v;
    @NotNull
    private final FieldOwnerContext context;
    @Nullable
    private final MemberCodegen classBodyCodegen;
    @NotNull
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context, @NotNull ClassBuilder v, @NotNull FunctionCodegen functionCodegen, @Nullable MemberCodegen classBodyCodegen) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/PropertyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/PropertyCodegen", "<init>"));
        }
        if (functionCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCodegen", "org/jetbrains/jet/codegen/PropertyCodegen", "<init>"));
        }
        super(functionCodegen.getState());
        this.v = v;
        this.functionCodegen = functionCodegen;
        this.context = context;
        this.classBodyCodegen = classBodyCodegen;
        this.kind = context.getContextKind();
    }

    public void gen(JetProperty p) {
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, p);
        assert (variableDescriptor instanceof PropertyDescriptor) : "Property should have a property descriptor: " + variableDescriptor;
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.TRAIT_IMPL) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + propertyDescriptor;
        if (this.context instanceof PackageFacadeContext) {
            Type ownerType = ((PackageFacadeContext)this.context).getDelegateToClassType();
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, propertyDescriptor, AsmUtil.shortNameByAsmType(ownerType));
        } else if (!this.generateBackingField(p, propertyDescriptor)) {
            this.generateSyntheticMethodIfNeeded(propertyDescriptor);
        }
        this.generateGetter(p, propertyDescriptor, p.getGetter());
        this.generateSetter(p, propertyDescriptor, p.getSetter());
        this.context.recordSyntheticAccessorIfNeeded(propertyDescriptor, this.bindingContext);
    }

    public void generatePrimaryConstructorProperty(JetParameter p, PropertyDescriptor descriptor) {
        this.generateBackingField(p, descriptor);
        this.generateGetter(p, descriptor, null);
        if (descriptor.isVar()) {
            this.generateSetter(p, descriptor, null);
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(JetParameter p, PropertyDescriptor descriptor) {
        Type type = this.state.getTypeMapper().mapType(descriptor);
        String name = p.getName();
        assert (name != null) : "Annotation parameter has no name: " + p.getText();
        MethodVisitor visitor = this.v.newMethod(p, 1025, name, "()" + type.getDescriptor(), null, null);
        JetExpression defaultValue = p.getDefaultValue();
        if (defaultValue != null) {
            CompileTimeConstant constant = ExpressionCodegen.getCompileTimeConstant(defaultValue, this.state.getBindingContext());
            assert (constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
            AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(visitor, this.typeMapper);
            annotationCodegen.generateAnnotationDefaultValue(constant, descriptor.getType());
        }
    }

    private boolean generateBackingField(@NotNull JetNamedDeclaration p, @NotNull PropertyDescriptor descriptor) {
        FieldVisitor fv;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (CodegenUtil.isInterface(descriptor.getContainingDeclaration()) || this.kind == OwnerKind.TRAIT_IMPL) {
            return false;
        }
        if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor))) {
            fv = this.generateBackingFieldAccess(p, descriptor);
        } else if (p instanceof JetProperty && ((JetProperty)p).getDelegateExpression() != null) {
            fv = this.generatePropertyDelegateAccess((JetProperty)p, descriptor);
        } else {
            return false;
        }
        AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(descriptor);
        return true;
    }

    private void generateSyntheticMethodIfNeeded(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen", "generateSyntheticMethodIfNeeded"));
        }
        if (descriptor.getAnnotations().isEmpty()) {
            return;
        }
        ReceiverParameterDescriptor receiver = descriptor.getReceiverParameter();
        Type receiverAsmType = receiver == null ? null : this.typeMapper.mapType(receiver.getType());
        Method method2 = JvmAbi.getSyntheticMethodSignatureForAnnotatedProperty(descriptor.getName(), receiverAsmType);
        if (!DescriptorUtils.isTrait(this.context.getContextDescriptor()) || this.kind == OwnerKind.TRAIT_IMPL) {
            MethodVisitor mv = this.v.newMethod(null, 135194, method2.getName(), method2.getDescriptor(), null, null);
            AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(descriptor);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitEnd();
        } else {
            Type tImplType = this.typeMapper.mapTraitImpl((ClassDescriptor)this.context.getContextDescriptor());
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, descriptor, AsmUtil.shortNameByAsmType(tImplType));
        }
        if (this.kind != OwnerKind.TRAIT_IMPL) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor, method2);
        }
    }

    private FieldVisitor generateBackingField(JetNamedDeclaration element, PropertyDescriptor propertyDescriptor, boolean isDelegate, JetType jetType, Object defaultValue) {
        int modifiers = AsmUtil.getDeprecatedAccessFlag(propertyDescriptor);
        if (KotlinBuiltIns.getInstance().isVolatile(propertyDescriptor)) {
            modifiers |= 0x40;
        }
        if (this.kind == OwnerKind.PACKAGE) {
            modifiers |= 8;
        }
        if (!propertyDescriptor.isVar() || isDelegate) {
            modifiers |= 0x10;
        }
        Type type = this.typeMapper.mapType(jetType);
        ClassBuilder builder = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        if (AsmUtil.isPropertyWithBackingFieldInOuterClass(propertyDescriptor)) {
            modifiers |= 8 | AsmUtil.getVisibilityForSpecialPropertyBackingField(propertyDescriptor, isDelegate);
            ImplementationBodyCodegen codegen = CodegenUtil.getParentBodyCodegen(this.classBodyCodegen);
            builder = codegen.v;
            backingFieldContext = codegen.context;
            this.v.getSerializationBindings().put(JvmSerializationBindings.STATIC_FIELD_IN_OUTER_CLASS, propertyDescriptor);
        } else if (this.kind != OwnerKind.PACKAGE || isDelegate) {
            modifiers |= 2;
        }
        if (AsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = CodegenUtil.getParentBodyCodegen(this.classBodyCodegen);
            parentBodyCodegen.addClassObjectPropertyToCopy(propertyDescriptor, defaultValue);
        }
        String name = backingFieldContext.getFieldName(propertyDescriptor, isDelegate);
        this.v.getSerializationBindings().put(JvmSerializationBindings.FIELD_FOR_PROPERTY, propertyDescriptor, Pair.create(type, name));
        return builder.newField(element, modifiers, name, type.getDescriptor(), this.typeMapper.mapFieldSignature(jetType), defaultValue);
    }

    private FieldVisitor generatePropertyDelegateAccess(JetProperty p, PropertyDescriptor propertyDescriptor) {
        JetType delegateType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, p.getDelegateExpression());
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType("Delegate type");
        }
        return this.generateBackingField(p, propertyDescriptor, true, delegateType, null);
    }

    private FieldVisitor generateBackingFieldAccess(JetNamedDeclaration p, PropertyDescriptor propertyDescriptor) {
        Object value = null;
        if (ImplementationBodyCodegen.shouldWriteFieldInitializer(propertyDescriptor, this.typeMapper)) {
            JetExpression initializer;
            JetExpression jetExpression = initializer = p instanceof JetProperty ? ((JetProperty)p).getInitializer() : null;
            if (initializer != null) {
                CompileTimeConstant compileTimeValue = ExpressionCodegen.getCompileTimeConstant(initializer, this.bindingContext);
                value = compileTimeValue != null ? compileTimeValue.getValue() : null;
            }
        }
        return this.generateBackingField(p, propertyDescriptor, false, propertyDescriptor.getType(), value);
    }

    private void generateGetter(JetNamedDeclaration p, PropertyDescriptor propertyDescriptor, JetPropertyAccessor getter) {
        boolean defaultGetter = getter == null || getter.getBodyExpression() == null;
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        getterDescriptor = getterDescriptor != null ? getterDescriptor : DescriptorFactory.createDefaultGetter(propertyDescriptor);
        JvmMethodSignature signature = this.typeMapper.mapSignature(getterDescriptor, this.kind);
        if (this.kind != OwnerKind.TRAIT_IMPL || !defaultGetter) {
            FunctionGenerationStrategy.CodegenBased strategy = defaultGetter ? (p instanceof JetProperty && ((JetProperty)p).getDelegateExpression() != null ? new DefaultPropertyWithDelegateAccessorStrategy(this.state, getterDescriptor) : new DefaultPropertyAccessorStrategy(this.state, getterDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, getterDescriptor, getter);
            this.functionCodegen.generateMethod(getter != null ? getter : p, signature, getterDescriptor, strategy);
        }
    }

    private void generateSetter(JetNamedDeclaration p, PropertyDescriptor propertyDescriptor, JetPropertyAccessor setter) {
        boolean defaultSetter;
        boolean bl = defaultSetter = setter == null || setter.getBodyExpression() == null;
        if (propertyDescriptor.isVar()) {
            PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
            setterDescriptor = setterDescriptor != null ? setterDescriptor : DescriptorFactory.createDefaultSetter(propertyDescriptor);
            JvmMethodSignature signature = this.typeMapper.mapSignature(setterDescriptor, this.kind);
            if (this.kind != OwnerKind.TRAIT_IMPL || !defaultSetter) {
                FunctionGenerationStrategy.CodegenBased strategy = defaultSetter ? (p instanceof JetProperty && ((JetProperty)p).getDelegateExpression() != null ? new DefaultPropertyWithDelegateAccessorStrategy(this.state, setterDescriptor) : new DefaultPropertyAccessorStrategy(this.state, setterDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, setterDescriptor, setter);
                this.functionCodegen.generateMethod(setter != null ? setter : p, signature, setterDescriptor, strategy);
            }
        }
    }

    public static String getterName(Name propertyName) {
        return "get" + StringUtil.capitalizeWithJavaBeanConvention(propertyName.asString());
    }

    public static String setterName(Name propertyName) {
        return "set" + StringUtil.capitalizeWithJavaBeanConvention(propertyName.asString());
    }

    public void genDelegate(@NotNull PropertyDescriptor delegate, @NotNull PropertyDescriptor overridden, @NotNull StackValue field) {
        PropertySetterDescriptor setter;
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/codegen/PropertyCodegen", "genDelegate"));
        }
        if (overridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/codegen/PropertyCodegen", "genDelegate"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/codegen/PropertyCodegen", "genDelegate"));
        }
        ClassDescriptor toClass = (ClassDescriptor)overridden.getContainingDeclaration();
        PropertyGetterDescriptor getter = delegate.getGetter();
        if (getter != null) {
            this.functionCodegen.genDelegate(getter, toClass, field, this.typeMapper.mapSignature(getter), this.typeMapper.mapSignature(overridden.getGetter().getOriginal()));
        }
        if ((setter = delegate.getSetter()) != null) {
            this.functionCodegen.genDelegate(setter, toClass, field, this.typeMapper.mapSignature(setter), this.typeMapper.mapSignature(overridden.getSetter().getOriginal()));
        }
    }

    private static class DefaultPropertyWithDelegateAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        public DefaultPropertyWithDelegateAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyWithDelegateAccessorStrategy", "<init>"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyWithDelegateAccessorStrategy", "<init>"));
            }
            super(state, descriptor);
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyWithDelegateAccessorStrategy", "doGenerateBody"));
            }
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyWithDelegateAccessorStrategy", "doGenerateBody"));
            }
            InstructionAdapter v = codegen.v;
            BindingContext bindingContext = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.callableDescriptor);
            Call call = bindingContext.get(BindingContext.DELEGATED_PROPERTY_CALL, this.callableDescriptor);
            assert (call != null) : "Call should be recorded for delegate call " + signature.toString();
            if (codegen.context.getContextKind() != OwnerKind.PACKAGE) {
                v.load(0, AsmTypeConstants.OBJECT_TYPE);
            }
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)this.callableDescriptor).getCorrespondingProperty();
            StackValue.Property delegatedProperty = codegen.intermediateValueForProperty(propertyDescriptor, true, null);
            StackValue lastValue = codegen.invokeFunction(call, delegatedProperty, resolvedCall);
            Type asmType = signature.getReturnType();
            lastValue.put(asmType, v);
            v.areturn(asmType);
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            super(state, descriptor);
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "doGenerateBody"));
            }
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "doGenerateBody"));
            }
            InstructionAdapter v = codegen.v;
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)this.callableDescriptor).getCorrespondingProperty();
            int paramCode = 0;
            if (codegen.context.getContextKind() != OwnerKind.PACKAGE) {
                v.load(0, AsmTypeConstants.OBJECT_TYPE);
                paramCode = 1;
            }
            StackValue.Property property2 = codegen.intermediateValueForProperty(propertyDescriptor, true, null);
            if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                Type type = signature.getReturnType();
                ((StackValue)property2).put(type, v);
                v.areturn(type);
            } else if (this.callableDescriptor instanceof PropertySetterDescriptor) {
                ReceiverParameterDescriptor receiverParameter = propertyDescriptor.getReceiverParameter();
                if (receiverParameter != null) {
                    paramCode += codegen.typeMapper.mapType(receiverParameter.getType()).getSize();
                }
                Type type = codegen.typeMapper.mapType(propertyDescriptor);
                v.load(paramCode, type);
                ((StackValue)property2).store(type, v);
                v.visitInsn(177);
            } else {
                throw new IllegalStateException("Unknown property accessor: " + this.callableDescriptor);
            }
        }
    }
}

