/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializerExtension;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaSerializerExtension
extends SerializerExtension {
    private final JvmSerializationBindings bindings;

    public JavaSerializerExtension(@NotNull JvmSerializationBindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/jet/codegen/JavaSerializerExtension", "<init>"));
        }
        this.bindings = bindings;
    }

    @Override
    public void serializeCallable(@NotNull CallableMemberDescriptor callable2, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeCallable"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeCallable"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeCallable"));
        }
        this.saveSignature(callable2, proto, nameTable);
        this.saveImplClassName(callable2, proto, nameTable);
    }

    @Override
    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor, @NotNull ProtoBuf.Callable.ValueParameter.Builder proto, @NotNull NameTable nameTable) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeValueParameter"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeValueParameter"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeValueParameter"));
        }
        Integer index = this.bindings.get(JvmSerializationBindings.INDEX_FOR_VALUE_PARAMETER, descriptor);
        if (index != null) {
            proto.setExtension(JavaProtoBuf.index, index);
        }
    }

    private void saveSignature(@NotNull CallableMemberDescriptor callable2, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSignature"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSignature"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSignature"));
        }
        if (callable2 instanceof FunctionDescriptor) {
            Method method2 = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, (FunctionDescriptor)callable2);
            if (method2 != null) {
                proto.setExtension(JavaProtoBuf.methodSignature, new SignatureSerializer(nameTable).methodSignature(method2));
            }
        } else if (callable2 instanceof PropertyDescriptor) {
            Method syntheticMethod;
            boolean isStaticInOuter;
            String fieldName;
            Type fieldType;
            PropertyDescriptor property2 = (PropertyDescriptor)callable2;
            PropertyGetterDescriptor getter = property2.getGetter();
            PropertySetterDescriptor setter = property2.getSetter();
            Method getterMethod = getter == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter);
            Method setterMethod = setter == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, setter);
            Pair<Type, String> field = this.bindings.get(JvmSerializationBindings.FIELD_FOR_PROPERTY, property2);
            if (field != null) {
                fieldType = (Type)field.first;
                fieldName = (String)field.second;
                isStaticInOuter = this.bindings.get(JvmSerializationBindings.STATIC_FIELD_IN_OUTER_CLASS, property2);
                syntheticMethod = null;
            } else {
                fieldType = null;
                fieldName = null;
                isStaticInOuter = false;
                syntheticMethod = this.bindings.get(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, property2);
            }
            JavaProtoBuf.JavaPropertySignature signature = new SignatureSerializer(nameTable).propertySignature(fieldType, fieldName, isStaticInOuter, syntheticMethod, getterMethod, setterMethod);
            proto.setExtension(JavaProtoBuf.propertySignature, signature);
        }
    }

    private void saveImplClassName(@NotNull CallableMemberDescriptor callable2, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveImplClassName"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveImplClassName"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveImplClassName"));
        }
        String name = this.bindings.get(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, callable2);
        if (name != null) {
            proto.setExtension(JavaProtoBuf.implClassName, nameTable.getSimpleNameIndex(Name.identifier(name)));
        }
    }

    private static class SignatureSerializer {
        private final NameTable nameTable;

        public SignatureSerializer(@NotNull NameTable nameTable) {
            if (nameTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "<init>"));
            }
            this.nameTable = nameTable;
        }

        @NotNull
        public JavaProtoBuf.JavaMethodSignature methodSignature(@NotNull Method method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            JavaProtoBuf.JavaMethodSignature.Builder signature = JavaProtoBuf.JavaMethodSignature.newBuilder();
            signature.setName(this.nameTable.getSimpleNameIndex(Name.guess(method2.getName())));
            signature.setReturnType(this.type(method2.getReturnType()));
            for (Type type : method2.getArgumentTypes()) {
                signature.addParameterType(this.type(type));
            }
            JavaProtoBuf.JavaMethodSignature javaMethodSignature = signature.build();
            if (javaMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            return javaMethodSignature;
        }

        @NotNull
        public JavaProtoBuf.JavaPropertySignature propertySignature(@Nullable Type fieldType, @Nullable String fieldName, boolean isStaticInOuter, @Nullable Method syntheticMethod, @Nullable Method getter, @Nullable Method setter) {
            JavaProtoBuf.JavaPropertySignature.Builder signature = JavaProtoBuf.JavaPropertySignature.newBuilder();
            if (fieldType != null) {
                assert (fieldName != null) : "Field name shouldn't be null when there's a field type: " + fieldType;
                signature.setField(this.fieldSignature(fieldType, fieldName, isStaticInOuter));
            }
            if (syntheticMethod != null) {
                signature.setSyntheticMethod(this.methodSignature(syntheticMethod));
            }
            if (getter != null) {
                signature.setGetter(this.methodSignature(getter));
            }
            if (setter != null) {
                signature.setSetter(this.methodSignature(setter));
            }
            JavaProtoBuf.JavaPropertySignature javaPropertySignature = signature.build();
            if (javaPropertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "propertySignature"));
            }
            return javaPropertySignature;
        }

        @NotNull
        public JavaProtoBuf.JavaFieldSignature fieldSignature(@NotNull Type type, @NotNull String name, boolean isStaticInOuter) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            JavaProtoBuf.JavaFieldSignature.Builder signature = JavaProtoBuf.JavaFieldSignature.newBuilder();
            signature.setName(this.nameTable.getSimpleNameIndex(Name.guess(name)));
            signature.setType(this.type(type));
            if (isStaticInOuter) {
                signature.setIsStaticInOuter(true);
            }
            JavaProtoBuf.JavaFieldSignature javaFieldSignature = signature.build();
            if (javaFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            return javaFieldSignature;
        }

        @NotNull
        public JavaProtoBuf.JavaType type(@NotNull Type givenType) {
            if (givenType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "givenType", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "type"));
            }
            JavaProtoBuf.JavaType.Builder builder = JavaProtoBuf.JavaType.newBuilder();
            int arrayDimension = 0;
            Type type = givenType;
            while (type.getSort() == 9) {
                ++arrayDimension;
                type = type.getElementType();
            }
            if (arrayDimension != 0) {
                builder.setArrayDimension(arrayDimension);
            }
            if (type.getSort() == 10) {
                FqName fqName = SignatureSerializer.internalNameToFqName(type.getInternalName());
                builder.setClassFqName(this.nameTable.getFqNameIndex(fqName));
            } else {
                builder.setPrimitiveType(JavaProtoBuf.JavaType.PrimitiveType.valueOf(type.getSort()));
            }
            JavaProtoBuf.JavaType javaType = builder.build();
            if (javaType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "type"));
            }
            return javaType;
        }

        @NotNull
        private static FqName internalNameToFqName(@NotNull String internalName) {
            if (internalName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "internalNameToFqName"));
            }
            FqName fqName = FqName.fromSegments(Arrays.asList(internalName.split("/")));
            if (fqName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "internalNameToFqName"));
            }
            return fqName;
        }
    }
}

