/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.google.common.collect.Sets;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.light.LightEmptyImplementsList;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.KotlinJavaFileStubProvider;
import org.jetbrains.jet.asJava.KotlinPackageLightClassData;
import org.jetbrains.jet.asJava.KotlinWrappingLightClass;
import org.jetbrains.jet.asJava.LightClassUtil;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.jetAsJava.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetLanguage;

public class KotlinLightClassForPackage
extends KotlinWrappingLightClass
implements JetJavaMirrorMarker {
    private final FqName packageFqName;
    private final FqName packageClassFqName;
    private final GlobalSearchScope searchScope;
    private final Collection<JetFile> files;
    private final int hashCode;
    private final CachedValue<KotlinPackageLightClassData> lightClassDataCache;
    private final PsiModifierList modifierList;
    private final LightEmptyImplementsList implementsList;

    private KotlinLightClassForPackage(@NotNull PsiManager manager, @NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope, @NotNull Collection<JetFile> files) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "<init>"));
        }
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "<init>"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "<init>"));
        }
        super(manager, JetLanguage.INSTANCE);
        this.modifierList = new LightModifierList(manager, JetLanguage.INSTANCE, "public", "final");
        this.implementsList = new LightEmptyImplementsList(manager);
        this.packageFqName = packageFqName;
        this.packageClassFqName = PackageClassUtils.getPackageClassFqName(packageFqName);
        this.searchScope = searchScope;
        assert (!files.isEmpty()) : "No files for package " + packageFqName;
        this.files = Sets.newHashSet(files);
        this.hashCode = this.computeHashCode();
        KotlinJavaFileStubProvider<KotlinPackageLightClassData> stubProvider = KotlinJavaFileStubProvider.createForPackageClass(this.getProject(), packageFqName, searchScope);
        this.lightClassDataCache = CachedValuesManager.getManager(this.getProject()).createCachedValue(stubProvider, false);
    }

    @Nullable
    public static KotlinLightClassForPackage create(@NotNull PsiManager manager, @NotNull FqName qualifiedName, @NotNull GlobalSearchScope searchScope, @NotNull Collection<JetFile> files) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "create"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "create"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "create"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "create"));
        }
        for (JetFile file : files) {
            if (!LightClassUtil.belongsToKotlinBuiltIns(file)) continue;
            return null;
        }
        return new KotlinLightClassForPackage(manager, qualifiedName, searchScope, files);
    }

    private static boolean allValid(Collection<JetFile> files) {
        for (JetFile file : files) {
            if (file.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public JetClassOrObject getOrigin() {
        return null;
    }

    @Override
    @Nullable
    public PsiModifierList getModifierList() {
        return this.modifierList;
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "hasModifierProperty"));
        }
        return this.modifierList.hasModifierProperty(name);
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    public boolean hasTypeParameters() {
        return false;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getTypeParameters"));
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    @Nullable
    public PsiReferenceList getImplementsList() {
        return this.implementsList;
    }

    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getImplementsListTypes"));
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiReferenceList getExtendsList() {
        return super.getExtendsList();
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = super.getExtendsListTypes();
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    @Override
    @Nullable
    public PsiClass getSuperClass() {
        return super.getSuperClass();
    }

    @Override
    @NotNull
    public PsiClass[] getSupers() {
        PsiClass[] psiClassArray = super.getSupers();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getSupers"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = super.getSuperTypes();
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getSuperTypes"));
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiClass[] getInterfaces() {
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getInnerClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiClass> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getOwnInnerClasses"));
        }
        return list2;
    }

    @Override
    @NotNull
    public PsiClass[] getAllInnerClasses() {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getAllInnerClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getInitializers"));
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiClass findInnerClassByName(@NonNls String name, boolean checkBases) {
        return null;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName = this.packageClassFqName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getFqName"));
        }
        return fqName;
    }

    @Override
    @Nullable
    public String getName() {
        return this.packageClassFqName.shortName().asString();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return this.packageClassFqName.asString();
    }

    @Override
    public boolean isValid() {
        return KotlinLightClassForPackage.allValid(this.files);
    }

    @Override
    @NotNull
    public PsiElement copy() {
        KotlinLightClassForPackage kotlinLightClassForPackage = new KotlinLightClassForPackage(this.getManager(), this.packageFqName, this.searchScope, this.files);
        if (kotlinLightClassForPackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "copy"));
        }
        return kotlinLightClassForPackage;
    }

    @Override
    @NotNull
    public PsiClass getDelegate() {
        PsiClass psiClass = LightClassUtil.findClass(this.packageClassFqName, this.lightClassDataCache.getValue().getJavaFileStub());
        if (psiClass == null) {
            throw new IllegalStateException("Package class was not found " + this.packageFqName);
        }
        PsiClass psiClass2 = psiClass;
        if (psiClass2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getDelegate"));
        }
        return psiClass2;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.files.iterator().next();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightClassForPackage", "getNavigationElement"));
        }
        return psiElement;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof PsiClass && Comparing.equal(((PsiClass)another).getQualifiedName(), this.getQualifiedName());
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        throw new UnsupportedOperationException("This should be done byt JetIconProvider");
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.getManager().hashCode();
        result = 31 * result + ((Object)this.files).hashCode();
        result = 31 * result + this.packageFqName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KotlinLightClassForPackage lightClass = (KotlinLightClassForPackage)obj;
        if (this.hashCode != lightClass.hashCode) {
            return false;
        }
        if (this.getManager() != lightClass.getManager()) {
            return false;
        }
        if (!((Object)this.files).equals(lightClass.files)) {
            return false;
        }
        return this.packageFqName.equals(lightClass.packageFqName);
    }

    @Override
    public String toString() {
        try {
            return KotlinLightClassForPackage.class.getSimpleName() + ":" + this.getQualifiedName();
        }
        catch (Throwable e) {
            return KotlinLightClassForPackage.class.getSimpleName() + ":" + e.toString();
        }
    }
}

