/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import jet.ByteIterator;
import jet.Function1;
import jet.JetObject;
import jet.KotlinPackageFragment;
import jet.Unit;
import jet.inline;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage-ArraysJVM-e0875270;
import kotlin.io.IoPackage$forEachLine$1;
import kotlin.io.IoPackage$readBytes$2;
import kotlin.io.IoPackage$stdin$1;
import kotlin.io.IoPackage$useLines$1;
import kotlin.io.LineIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinPackageFragment(abiVersion=13)
public final class IoPackage-JIO-d8629b90 {
    static final int defaultBufferSize = 65536;
    @NotNull
    static final Charset defaultCharset;
    @NotNull
    static final BufferedReader stdin;

    public static final int getDefaultBufferSize() {
        return defaultBufferSize;
    }

    @NotNull
    public static final Charset getDefaultCharset() {
        return defaultCharset;
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message", type="?") @Nullable Object message) {
        System.out.print(message);
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message") int message) {
        System.out.print(message);
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message") long message) {
        System.out.print(message);
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message") byte message) {
        System.out.print((Object)message);
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message") short message) {
        System.out.print((Object)message);
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message") char message) {
        System.out.print(message);
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message") boolean message) {
        System.out.print(message);
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message") float message) {
        System.out.print(message);
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message") double message) {
        System.out.print(message);
    }

    @NotNull
    public static final void print(@JetValueParameter(name="message") @NotNull char[] message) {
        System.out.print(message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message", type="?") @Nullable Object message) {
        System.out.println(message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message") int message) {
        System.out.println(message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message") long message) {
        System.out.println(message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message") byte message) {
        System.out.println((Object)message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message") short message) {
        System.out.println((Object)message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message") char message) {
        System.out.println(message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message") boolean message) {
        System.out.println(message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message") float message) {
        System.out.println(message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message") double message) {
        System.out.println(message);
    }

    @NotNull
    public static final void println(@JetValueParameter(name="message") @NotNull char[] message) {
        System.out.println(message);
    }

    @NotNull
    public static final void println() {
        System.out.println();
    }

    @NotNull
    public static final BufferedReader getStdin() {
        return stdin;
    }

    @Nullable
    public static final String readLine() {
        return stdin.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @inline
    public static final <T extends Closeable, R> R use(@JetValueParameter(name="$receiver") T $receiver, @JetValueParameter(name="block") @NotNull Function1<? super T, ? extends R> block) {
        R r;
        int closed;
        block8: {
            closed = 0;
            r = block.invoke($receiver);
            if (!(closed == 0)) break block8;
            $receiver.close();
        }
        try {
            return r;
        }
        catch (Exception exception) {
            try {
                closed = 1;
                try {
                    $receiver.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (closed == 0) {
                    $receiver.close();
                }
                throw throwable;
            }
        }
    }

    @NotNull
    public static final ByteIterator iterator(@JetValueParameter(name="$receiver") InputStream $receiver) {
        return (ByteIterator)new JetObject($receiver){
            final /* synthetic */ InputStream receiver$0;

            public boolean hasNext() {
                return this.receiver$0.available() > 0;
            }

            public byte nextByte() {
                return (byte)this.receiver$0.read();
            }
            {
                this.receiver$0 = $receiver;
            }

            public void remove() {
                throw new UnsupportedOperationException("Mutating immutable collection");
            }
        };
    }

    @NotNull
    public static final InputStream buffered(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="bufferSize") int bufferSize) {
        return $receiver instanceof BufferedInputStream ? (BufferedInputStream)$receiver : new BufferedInputStream($receiver, bufferSize);
    }

    public static InputStream buffered$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage-JIO-d8629b90.buffered(inputStream, n);
    }

    @NotNull
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="encoding") @NotNull Charset encoding) {
        return new InputStreamReader($receiver, encoding);
    }

    public static InputStreamReader reader$default(InputStream inputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = defaultCharset;
        }
        return IoPackage-JIO-d8629b90.reader(inputStream, charset);
    }

    @NotNull
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="encoding") @NotNull String encoding) {
        return new InputStreamReader($receiver, encoding);
    }

    @NotNull
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="encoding") @NotNull CharsetDecoder encoding) {
        return new InputStreamReader($receiver, encoding);
    }

    @NotNull
    public static final BufferedOutputStream buffered(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="bufferSize") int bufferSize) {
        return $receiver instanceof BufferedOutputStream ? (BufferedOutputStream)$receiver : new BufferedOutputStream($receiver, bufferSize);
    }

    public static BufferedOutputStream buffered$default(OutputStream outputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage-JIO-d8629b90.buffered(outputStream, n);
    }

    @NotNull
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="encoding") @NotNull Charset encoding) {
        return new OutputStreamWriter($receiver, encoding);
    }

    public static OutputStreamWriter writer$default(OutputStream outputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = defaultCharset;
        }
        return IoPackage-JIO-d8629b90.writer(outputStream, charset);
    }

    @NotNull
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="encoding") @NotNull String encoding) {
        return new OutputStreamWriter($receiver, encoding);
    }

    @NotNull
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="encoding") @NotNull CharsetEncoder encoding) {
        return new OutputStreamWriter($receiver, encoding);
    }

    @NotNull
    public static final BufferedReader buffered(@JetValueParameter(name="$receiver") Reader $receiver, @JetValueParameter(name="bufferSize") int bufferSize) {
        return $receiver instanceof BufferedReader ? (BufferedReader)$receiver : new BufferedReader($receiver, bufferSize);
    }

    public static BufferedReader buffered$default(Reader reader, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage-JIO-d8629b90.buffered(reader, n);
    }

    @NotNull
    public static final BufferedWriter buffered(@JetValueParameter(name="$receiver") Writer $receiver, @JetValueParameter(name="bufferSize") int bufferSize) {
        return $receiver instanceof BufferedWriter ? (BufferedWriter)$receiver : new BufferedWriter($receiver, bufferSize);
    }

    public static BufferedWriter buffered$default(Writer writer, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage-JIO-d8629b90.buffered(writer, n);
    }

    @inline
    @NotNull
    public static final void forEachLine(@JetValueParameter(name="$receiver") Reader $receiver, @JetValueParameter(name="block") @NotNull Function1<? super String, ? extends Unit> block) {
        IoPackage-JIO-d8629b90.useLines($receiver, new IoPackage$forEachLine$1(block));
    }

    @inline
    public static final <T> T useLines(@JetValueParameter(name="$receiver") Reader $receiver, @JetValueParameter(name="block") @NotNull Function1<? super Iterator<? extends String>, ? extends T> block) {
        return (T)IoPackage-JIO-d8629b90.use((Closeable)IoPackage-JIO-d8629b90.buffered$default($receiver, 0, 1), new IoPackage$useLines$1(block));
    }

    @NotNull
    public static final Iterator<String> lineIterator(@JetValueParameter(name="$receiver") BufferedReader $receiver) {
        return new LineIterator($receiver);
    }

    @NotNull
    public static final byte[] readBytes(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="estimatedSize") int estimatedSize) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(estimatedSize);
        IoPackage-JIO-d8629b90.copyTo$default($receiver, buffer, 0, 2);
        return buffer.toByteArray();
    }

    public static byte[] readBytes$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage-JIO-d8629b90.readBytes(inputStream, n);
    }

    @NotNull
    public static final String readText(@JetValueParameter(name="$receiver") Reader $receiver) {
        StringWriter buffer = new StringWriter();
        IoPackage-JIO-d8629b90.copyTo$default($receiver, buffer, 0, 2);
        return buffer.toString();
    }

    public static final long copyTo(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="out") @NotNull OutputStream out, @JetValueParameter(name="bufferSize") int bufferSize) {
        long bytesCopied = 0L;
        byte[] buffer = new byte[bufferSize];
        int bytes = $receiver.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = $receiver.read(buffer);
        }
        return bytesCopied;
    }

    public static long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage-JIO-d8629b90.copyTo(inputStream, outputStream, n);
    }

    public static final long copyTo(@JetValueParameter(name="$receiver") Reader $receiver, @JetValueParameter(name="out") @NotNull Writer out, @JetValueParameter(name="bufferSize") int bufferSize) {
        long charsCopied = 0L;
        char[] buffer = new char[bufferSize];
        int chars = $receiver.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = $receiver.read(buffer);
        }
        return charsCopied;
    }

    public static long copyTo$default(Reader reader, Writer writer, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = defaultBufferSize;
        }
        return IoPackage-JIO-d8629b90.copyTo(reader, writer, n);
    }

    @NotNull
    public static final String readText(@JetValueParameter(name="$receiver") URL $receiver, @JetValueParameter(name="encoding") @NotNull String encoding) {
        return KotlinPackage-ArraysJVM-e0875270.toString(IoPackage-JIO-d8629b90.readBytes($receiver), encoding);
    }

    public static String readText$default(URL uRL, String string, int n) {
        if ((n & 1) != 0) {
            string = Charset.defaultCharset().name();
        }
        return IoPackage-JIO-d8629b90.readText(uRL, string);
    }

    @NotNull
    public static final String readText(@JetValueParameter(name="$receiver") URL $receiver, @JetValueParameter(name="encoding") @NotNull Charset encoding) {
        return KotlinPackage-ArraysJVM-e0875270.toString(IoPackage-JIO-d8629b90.readBytes($receiver), encoding);
    }

    @NotNull
    public static final byte[] readBytes(@JetValueParameter(name="$receiver") URL $receiver) {
        InputStream inputStream = $receiver.openStream();
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        return (byte[])IoPackage-JIO-d8629b90.use((Closeable)inputStream, IoPackage$readBytes$2.instance$);
    }

    static {
        defaultBufferSize = 64 * 1024;
        Charset charset = Charset.forName("UTF-8");
        if (charset == null) {
            Intrinsics.throwNpe();
        }
        defaultCharset = charset;
        stdin = new BufferedReader(new InputStreamReader(new IoPackage$stdin$1()));
    }
}

