/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleObjectProcedure;
import gnu.trove.THash;
import gnu.trove.TObjectHash;

public class TDoubleObjectHashMap<V>
extends THash
implements TDoubleHashingStrategy {
    protected transient V[] _values;
    protected transient double[] _set;
    protected final TDoubleHashingStrategy _hashingStrategy = this;

    @Override
    public TDoubleObjectHashMap<V> clone() {
        TDoubleObjectHashMap m = (TDoubleObjectHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        this._set = new double[capacity];
        return capacity;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public V put(double key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = TDoubleObjectHashMap.unwrapNull(this._values[index]);
            isNewMapping = false;
        } else {
            wasFree = TDoubleObjectHashMap.isFree(this._values, index);
        }
        this._set[index] = key;
        this._values[index] = TDoubleObjectHashMap.wrapNull(value);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        double[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new double[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TDoubleObjectHashMap.isFull(oldVals, i)) continue;
            double o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public V get(double key) {
        int index = this.index(key);
        return index < 0 ? null : (V)TDoubleObjectHashMap.unwrapNull(this._values[index]);
    }

    private static <V> V unwrapNull(V value) {
        return value == TObjectHash.NULL ? null : (V)value;
    }

    private static <V> V wrapNull(V value) {
        return (V)(value == null ? TObjectHash.NULL : value);
    }

    @Override
    public void clear() {
        super.clear();
        double[] keys = this._set;
        V[] values2 = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0.0;
            values2[i] = null;
        }
    }

    protected int index(double val) {
        double[] set = this._set;
        Object[] values2 = this._values;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (!TDoubleObjectHashMap.isFree(values2, index) && (TDoubleObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!TDoubleObjectHashMap.isFree(values2, index) && (TDoubleObjectHashMap.isRemoved(values2, index) || set[index] != val));
        }
        return TDoubleObjectHashMap.isFree(values2, index) ? -1 : index;
    }

    protected int insertionIndex(double val) {
        int firstRemoved;
        Object[] values2 = this._values;
        double[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (TDoubleObjectHashMap.isFree(values2, index)) {
            return index;
        }
        if (TDoubleObjectHashMap.isFull(values2, index) && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TDoubleObjectHashMap.isRemoved(values2, index) ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if (firstRemoved != -1 || !TDoubleObjectHashMap.isRemoved(values2, index)) continue;
            firstRemoved = index;
        } while (TDoubleObjectHashMap.isFull(values2, index) && set[index] != val);
        if (TDoubleObjectHashMap.isRemoved(values2, index)) {
            while (!TDoubleObjectHashMap.isFree(values2, index) && (TDoubleObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
        }
        if (TDoubleObjectHashMap.isFull(values2, index)) {
            return -index - 1;
        }
        return firstRemoved == -1 ? index : firstRemoved;
    }

    static boolean isFull(Object[] values2, int index) {
        Object value = values2[index];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values2, int index) {
        return values2[index] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values2, int index) {
        return values2[index] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TDoubleObjectHashMap)) {
            return false;
        }
        TDoubleObjectHashMap that = (TDoubleObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = TObjectHash.REMOVED;
        super.removeAt(index);
    }

    public boolean forEachEntry(TDoubleObjectProcedure<V> procedure) {
        double[] keys = this._set;
        Object[] values2 = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (!TDoubleObjectHashMap.isFull(values2, i) || procedure.execute(keys[i], TDoubleObjectHashMap.unwrapNull(values2[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int computeHashCode(double val) {
        return HashFunctions.hash(val);
    }

    private static final class EqProcedure<V>
    implements TDoubleObjectProcedure<V> {
        private final TDoubleObjectHashMap<V> _otherMap;

        EqProcedure(TDoubleObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(double key, V value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    private final class HashProcedure
    implements TDoubleObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(double key, V value) {
            this.h += TDoubleObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

