/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.cli;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ComparatorUtil;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArgumentUtils {
    @NotNull
    public static <T> List<String> convertArgumentsToStringList(@NotNull T arguments2, @NotNull T defaultArguments) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/sampullara/cli/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (defaultArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultArguments", "com/sampullara/cli/ArgumentUtils", "convertArgumentsToStringList"));
        }
        ArrayList<String> result = new ArrayList<String>();
        ArgumentUtils.convertArgumentsToStringList(arguments2, defaultArguments, result);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sampullara/cli/ArgumentUtils", "convertArgumentsToStringList"));
        }
        return arrayList;
    }

    public static <T> void convertArgumentsToStringList(@NotNull T arguments2, @NotNull T defaultArguments, @NotNull List<String> result) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/sampullara/cli/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (defaultArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultArguments", "com/sampullara/cli/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/sampullara/cli/ArgumentUtils", "convertArgumentsToStringList"));
        }
        ArgumentUtils.convertArgumentsToStringList(arguments2, defaultArguments, arguments2.getClass(), result);
    }

    private static <T> void convertArgumentsToStringList(T arguments2, T defaultArguments, Class clazz, List<String> result) {
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            ArgumentUtils.convertArgumentsToStringList(arguments2, defaultArguments, superClazz, result);
        }
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> fieldType;
            Object defaultValue;
            Object value;
            Argument argument = field.getAnnotation(Argument.class);
            if (argument == null) continue;
            try {
                value = field.get(arguments2);
                defaultValue = field.get(defaultArguments);
            }
            catch (IllegalAccessException ignored) {
                continue;
            }
            if (ComparatorUtil.equalsNullable(value, defaultValue)) continue;
            String name = Args.getAlias(argument);
            if (name == null) {
                name = Args.getName(argument, field);
            }
            if ((fieldType = field.getType()).isArray()) {
                Object[] values2 = (Object[])value;
                if (values2.length == 0) continue;
                value = StringUtil.join(values2, Function.TO_STRING, argument.delimiter());
            }
            result.add(argument.prefix() + name);
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) continue;
            result.add(value.toString());
        }
    }
}

