/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.util.messages.Topic;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public final class Message {
    private final Topic myTopic;
    private final Method myListenerMethod;
    private final Object[] myArgs;

    public Message(@NotNull Topic topic, @NotNull Method listenerMethod, Object[] args) {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/messages/impl/Message", "<init>"));
        }
        if (listenerMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/messages/impl/Message", "<init>"));
        }
        this.myTopic = topic;
        listenerMethod.setAccessible(true);
        this.myListenerMethod = listenerMethod;
        this.myArgs = args;
    }

    @NotNull
    public Topic getTopic() {
        Topic topic = this.myTopic;
        if (topic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/Message", "getTopic"));
        }
        return topic;
    }

    @NotNull
    public Method getListenerMethod() {
        Method method2 = this.myListenerMethod;
        if (method2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/Message", "getListenerMethod"));
        }
        return method2;
    }

    public Object[] getArgs() {
        return this.myArgs;
    }

    public String toString() {
        return this.myTopic.toString() + ":" + this.myListenerMethod.getName();
    }
}

