/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodCandidatesProcessor
extends MethodsProcessor {
    protected boolean myHasAccessibleStaticCorrectCandidate;

    public MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile, @NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/processor/MethodCandidatesProcessor", "<init>"));
        }
        if (resolvers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/scope/processor/MethodCandidatesProcessor", "<init>"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/scope/processor/MethodCandidatesProcessor", "<init>"));
        }
        super(resolvers, container, place, placeFile);
        this.myHasAccessibleStaticCorrectCandidate = false;
    }

    public MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/processor/MethodCandidatesProcessor", "<init>"));
        }
        super(new PsiConflictResolver[]{DuplicateConflictResolver.INSTANCE}, new SmartList<CandidateInfo>(), place, placeFile);
        this.myHasAccessibleStaticCorrectCandidate = false;
    }

    @Override
    public void add(PsiElement element, PsiSubstitutor substitutor) {
        if (element instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)element;
            this.addMethod(method2, substitutor, this.isInStaticScope() && !method2.hasModifierProperty("static"));
        }
    }

    public void addMethod(PsiMethod method2, PsiSubstitutor substitutor, boolean staticProblem) {
        boolean isAccessible;
        boolean bl = isAccessible = JavaResolveUtil.isAccessible(method2, method2.getContainingClass(), method2.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileContext, this.myPlaceFile) && !this.isShadowed(method2);
        if (this.isAccepted(method2)) {
            this.add(this.createCandidateInfo(method2, substitutor, staticProblem, isAccessible));
            this.myHasAccessibleStaticCorrectCandidate |= isAccessible && !staticProblem;
        }
    }

    protected MethodCandidateInfo createCandidateInfo(PsiMethod method2, PsiSubstitutor substitutor, boolean staticProblem, boolean accessible) {
        PsiExpressionList argumentList = this.getArgumentList();
        return new MethodCandidateInfo(method2, substitutor, !accessible, staticProblem, argumentList, this.myCurrentFileContext, this.getExpressionTypes(argumentList), this.getTypeArguments(), this.getLanguageLevel());
    }

    protected PsiType[] getExpressionTypes(PsiExpressionList argumentList) {
        return argumentList != null ? argumentList.getExpressionTypes() : null;
    }

    protected boolean isAccepted(PsiMethod candidate) {
        if (!this.isConstructor()) {
            return !candidate.isConstructor() && candidate.getName().equals(this.getName(ResolveState.initial()));
        }
        if (!candidate.isConstructor()) {
            return false;
        }
        if (this.myAccessClass == null) {
            return true;
        }
        if (this.myAccessClass instanceof PsiAnonymousClass) {
            PsiClass containingClass = candidate.getContainingClass();
            return containingClass != null && containingClass.equals(this.myAccessClass.getSuperClass());
        }
        return this.myAccessClass.isEquivalentTo(candidate.getContainingClass());
    }

    protected boolean isShadowed(PsiMethod candidate) {
        if (this.myCurrentFileContext instanceof PsiImportStaticStatement) {
            for (CandidateInfo result : this.getResults()) {
                if (result.getElement() == candidate || !result.isAccessible() || result.getCurrentFileResolveScope() instanceof PsiImportStaticStatement) continue;
                return true;
            }
        }
        return false;
    }

    public CandidateInfo[] getCandidates() {
        JavaResolveResult[] resolveResult = this.getResult();
        if (resolveResult.length == 0) {
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] infos = new CandidateInfo[resolveResult.length];
        System.arraycopy(resolveResult, 0, infos, 0, resolveResult.length);
        return infos;
    }
}

