/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public class FunctionalInterfaceParameterizationUtil {
    private static final Logger LOG = Logger.getInstance("#" + FunctionalInterfaceParameterizationUtil.class.getName());

    public static boolean isWildcardParameterized(@Nullable PsiType classType) {
        if (classType == null) {
            return false;
        }
        if (classType instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)classType).getConjuncts()) {
                if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(type)) continue;
                return false;
            }
        }
        if (classType instanceof PsiClassType) {
            for (PsiType type : ((PsiClassType)classType).getParameters()) {
                if (!(type instanceof PsiWildcardType) && !(type instanceof PsiCapturedWildcardType)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(psiClassType, null);
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType, @Nullable PsiLambdaExpression expr) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(psiClassType)) {
            return psiClassType;
        }
        if (expr != null && expr.hasFormalParameterTypes()) {
            return FunctionalInterfaceParameterizationUtil.getFunctionalTypeExplicit(psiClassType, expr);
        }
        return psiClassType instanceof PsiClassType ? FunctionalInterfaceParameterizationUtil.getNonWildcardParameterization((PsiClassType)psiClassType) : null;
    }

    private static PsiType getFunctionalTypeExplicit(PsiType psiClassType, PsiLambdaExpression expr) {
        PsiParameter[] lambdaParams = expr.getParameterList().getParameters();
        if (psiClassType instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)psiClassType).getConjuncts()) {
                PsiType functionalType = FunctionalInterfaceParameterizationUtil.getFunctionalTypeExplicit(psiType, expr);
                if (functionalType == null) continue;
                return functionalType;
            }
            return null;
        }
        LOG.assertTrue(psiClassType instanceof PsiClassType, "Unexpected type: " + psiClassType);
        PsiType[] parameters = ((PsiClassType)psiClassType).getParameters();
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)psiClassType).resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                return null;
            }
            PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
            if (typeParameters.length != parameters.length) {
                return null;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(psiClass.getProject());
            PsiParameter[] targetMethodParams = interfaceMethod.getParameterList().getParameters();
            if (targetMethodParams.length != lambdaParams.length) {
                return null;
            }
            InferenceSession session = new InferenceSession(typeParameters, PsiSubstitutor.EMPTY, expr.getManager(), expr);
            for (int i = 0; i < targetMethodParams.length; ++i) {
                session.addConstraint(new TypeEqualityConstraint(lambdaParams[i].getType(), targetMethodParams[i].getType()));
            }
            if (!session.repeatInferencePhases(false)) {
                return null;
            }
            session.resolveBounds(false);
            PsiType[] newTypeParameters = new PsiType[parameters.length];
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiTypeParameter typeParameter = typeParameters[i];
                InferenceVariable variable = session.getInferenceVariable(typeParameter);
                PsiType instantiation = variable.getInstantiation();
                newTypeParameters[i] = instantiation != PsiType.NULL ? instantiation : parameters[i];
            }
            PsiClassType parameterization = elementFactory.createType(psiClass, newTypeParameters);
            if (!FunctionalInterfaceParameterizationUtil.isWellFormed(psiClass, typeParameters, newTypeParameters)) {
                return null;
            }
            if (!TypeConversionUtil.containsWildcards(parameterization)) {
                return parameterization;
            }
            return FunctionalInterfaceParameterizationUtil.getNonWildcardParameterization(parameterization);
        }
        return null;
    }

    private static boolean isWellFormed(PsiClass psiClass, PsiTypeParameter[] typeParameters, PsiType[] newTypeParameters) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.putAll(psiClass, newTypeParameters);
        for (int i = 0; i < typeParameters.length; ++i) {
            for (PsiClassType bound : typeParameters[i].getExtendsListTypes()) {
                if (!GenericsUtil.checkNotInBounds(newTypeParameters[i], substitutor.substitute(bound), false)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static PsiType getNonWildcardParameterization(PsiClassType psiClassType) {
        PsiClass psiClass = psiClassType.resolve();
        if (psiClass != null) {
            PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
            PsiType[] parameters = psiClassType.getParameters();
            if (parameters.length != typeParameters.length) {
                return null;
            }
            HashSet<PsiTypeParameter> typeParametersSet = ContainerUtil.newHashSet(typeParameters);
            for (int i = 0; i < parameters.length; ++i) {
                PsiClassType Bi;
                PsiType paramType = parameters[i];
                if (!(paramType instanceof PsiWildcardType)) continue;
                PsiClassType[] extendsListTypes = typeParameters[i].getExtendsListTypes();
                PsiClassType psiClassType2 = Bi = extendsListTypes.length > 0 ? extendsListTypes[0] : PsiType.getJavaLangObject(psiClass.getManager(), GlobalSearchScope.allScope(psiClass.getProject()));
                if (PsiPolyExpressionUtil.mentionsTypeParameters(Bi, typeParametersSet).booleanValue()) {
                    return null;
                }
                PsiType bound = ((PsiWildcardType)paramType).getBound();
                parameters[i] = bound == null ? Bi : (((PsiWildcardType)paramType).isExtends() ? GenericsUtil.getGreatestLowerBound(Bi, GenericsUtil.eliminateWildcards(bound, false)) : GenericsUtil.eliminateWildcards(bound, false));
            }
            return JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass, parameters);
        }
        return null;
    }
}

