/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AbstractMultimap<K, V>
implements Multimap<K, V> {
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Set<K> keySet;
    private transient Multiset<K> keys;
    private transient Collection<V> values;
    private transient Map<K, Collection<V>> asMap;

    AbstractMultimap() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Collection<V> collection : this.asMap().values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        Collection<V> collection = this.asMap().get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Collection<V> collection = this.asMap().get(key);
        return collection != null && collection.remove(value);
    }

    @Override
    public boolean put(K key, V value) {
        return this.get(key).add(value);
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values2) {
        Preconditions.checkNotNull(values2);
        return values2.iterator().hasNext() && Iterables.addAll(this.get(key), values2);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> result = this.entries;
        return result == null ? (this.entries = this.createEntries()) : result;
    }

    Collection<Map.Entry<K, V>> createEntries() {
        if (this instanceof SetMultimap) {
            return new Multimaps.EntrySet<K, V>(){

                @Override
                Multimap<K, V> multimap() {
                    return AbstractMultimap.this;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return AbstractMultimap.this.entryIterator();
                }
            };
        }
        return new Multimaps.Entries<K, V>(){

            @Override
            Multimap<K, V> multimap() {
                return AbstractMultimap.this;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return AbstractMultimap.this.entryIterator();
            }
        };
    }

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    @Override
    public Set<K> keySet() {
        Set<K> result = this.keySet;
        return result == null ? (this.keySet = this.createKeySet()) : result;
    }

    Set<K> createKeySet() {
        return new Maps.KeySet<K, Collection<V>>(){

            @Override
            Map<K, Collection<V>> map() {
                return AbstractMultimap.this.asMap();
            }
        };
    }

    @Override
    public Multiset<K> keys() {
        Multiset<K> result = this.keys;
        return result == null ? (this.keys = this.createKeys()) : result;
    }

    Multiset<K> createKeys() {
        return new Multimaps.Keys(this);
    }

    @Override
    public Collection<V> values() {
        Collection<V> result = this.values;
        return result == null ? (this.values = this.createValues()) : result;
    }

    Collection<V> createValues() {
        return new Multimaps.Values(this);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<Collection<V>>> result = this.asMap;
        return result == null ? (this.asMap = this.createAsMap()) : result;
    }

    abstract Map<K, Collection<V>> createAsMap();

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof Multimap) {
            Multimap that = (Multimap)object2;
            return this.asMap().equals(that.asMap());
        }
        return false;
    }

    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }
}

