/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.dangerous;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.InlinedCallExpressionTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousData;

public final class FindDangerousVisitor
extends JetTreeVisitor<DangerousData> {
    @NotNull
    private final TranslationContext context;

    public FindDangerousVisitor(@NotNull TranslationContext context) {
        this.context = context;
    }

    @Override
    public Void visitDeclaration(JetDeclaration dcl, DangerousData data) {
        return null;
    }

    @Override
    public Void visitJetElement(JetElement element, DangerousData data) {
        if (data.exists()) {
            return null;
        }
        return super.visitJetElement(element, data);
    }

    @Override
    public Void visitWhenExpression(JetWhenExpression expression, DangerousData data) {
        if (this.expressionFound(expression, data)) {
            return null;
        }
        return (Void)super.visitWhenExpression(expression, data);
    }

    @Override
    public Void visitIfExpression(JetIfExpression expression, DangerousData data) {
        if (this.expressionFound(expression, data)) {
            return null;
        }
        return (Void)super.visitIfExpression(expression, data);
    }

    @Override
    public Void visitBlockExpression(JetBlockExpression expression, DangerousData data) {
        if (BindingUtils.isStatement(this.context.bindingContext(), expression)) {
            return null;
        }
        return (Void)super.visitBlockExpression(expression, data);
    }

    @Override
    public Void visitCallExpression(JetCallExpression expression, DangerousData data) {
        if (InlinedCallExpressionTranslator.shouldBeInlined(expression, this.context) && this.expressionFound(expression, data)) {
            return null;
        }
        return (Void)super.visitCallExpression(expression, data);
    }

    private boolean expressionFound(@NotNull JetExpression expression, @NotNull DangerousData data) {
        if (data.exists()) {
            return true;
        }
        if (!BindingUtils.isStatement(this.context.bindingContext(), expression)) {
            data.setDangerousNode(expression);
            return true;
        }
        return false;
    }
}

