/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class InitializerUtils {
    private InitializerUtils() {
    }

    @NotNull
    public static JsStatement generateInitializerForProperty(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor, @NotNull JsExpression value) {
        if (context.isEcma5()) {
            return JsAstUtils.definePropertyDataDescriptor(descriptor, value, context).makeStmt();
        }
        return TranslationUtils.assignmentToBackingField(context, descriptor, value).makeStmt();
    }

    public static void generate(@NotNull JetObjectDeclaration declaration, @NotNull List<JsStatement> initializers, @Nullable List<JsPropertyInitializer> definitions, @NotNull TranslationContext context) {
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(context.bindingContext(), declaration);
        JsExpression value = ClassTranslator.generateClassCreation(declaration, descriptor, context);
        if (definitions != null && value instanceof JsLiteral) {
            definitions.add(InitializerUtils.createPropertyInitializer(descriptor, value, context));
        } else {
            initializers.add(InitializerUtils.create(descriptor, value, context));
        }
    }

    public static JsStatement create(Named named, JsExpression value, TranslationContext context) {
        JsExpression expression = context.isEcma5() ? JsAstUtils.defineProperty(named.getName().asString(), JsAstUtils.createDataDescriptor(value), context) : JsAstUtils.assignment(new JsNameRef(named.getName().asString(), (JsExpression)JsLiteral.THIS), value);
        return expression.makeStmt();
    }

    public static JsExpression toDataDescriptor(JsExpression value, TranslationContext context) {
        return context.isEcma5() ? JsAstUtils.createDataDescriptor(value) : value;
    }

    public static JsPropertyInitializer createPropertyInitializer(Named named, JsExpression value, TranslationContext context) {
        return new JsPropertyInitializer(context.nameToLiteral(named), InitializerUtils.toDataDescriptor(value, context));
    }
}

