/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.utils.KotlinPaths;

public class KotlinPathsFromHomeDir
implements KotlinPaths {
    private final File homePath;

    public KotlinPathsFromHomeDir(@NotNull File homePath) {
        this.homePath = homePath;
    }

    @Override
    @NotNull
    public File getHomePath() {
        return this.homePath;
    }

    @Override
    @NotNull
    public File getLibPath() {
        return new File(this.homePath, "lib");
    }

    @Override
    @NotNull
    public File getRuntimePath() {
        return this.getLibraryFile("kotlin-runtime.jar");
    }

    @Override
    @NotNull
    public File getJdkAnnotationsPath() {
        return this.getLibraryFile("kotlin-jdk-annotations.jar");
    }

    @Override
    @NotNull
    public File getAndroidSdkAnnotationsPath() {
        return this.getLibraryFile("kotlin-android-sdk-annotations.jar");
    }

    @Override
    @NotNull
    public File getJsLibJsPath() {
        return this.getLibraryFile("kotlinEcma3.js");
    }

    @Override
    @NotNull
    public File getJsLibJarPath() {
        return this.getLibraryFile("kotlin-jslib.jar");
    }

    @NotNull
    private File getLibraryFile(@NotNull String fileName) {
        return new File(this.getLibPath(), fileName);
    }
}

