/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.di.InjectorForLazyResolve;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorVisitorEmptyBodies;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.lazy.ResolveElementCache;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class ResolveSession
implements KotlinCodeAnalyzer {
    public static final Function<FqName, Name> NO_ALIASES = new Function<FqName, Name>(){

        @Override
        public Name fun(FqName name) {
            return null;
        }
    };
    private final StorageManager storageManager;
    private final ModuleDescriptor module;
    private final LazyPackageDescriptor rootPackage;
    private final BindingTrace trace;
    private final DeclarationProviderFactory declarationProviderFactory;
    private final Predicate<FqNameUnsafe> specialClasses;
    private final InjectorForLazyResolve injector;
    private final Function<FqName, Name> classifierAliases;
    private final ResolveElementCache resolveElementCache;

    public ResolveSession(@NotNull Project project, @NotNull StorageManager storageManager, @NotNull ModuleDescriptorImpl rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory) {
        this(project, storageManager, rootDescriptor, declarationProviderFactory, NO_ALIASES, Predicates.alwaysFalse(), new BindingTraceContext());
    }

    public ResolveSession(@NotNull Project project, @NotNull StorageManager storageManager, @NotNull ModuleDescriptorImpl rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory, @NotNull BindingTrace delegationTrace) {
        this(project, storageManager, rootDescriptor, declarationProviderFactory, NO_ALIASES, Predicates.alwaysFalse(), delegationTrace);
    }

    @Deprecated
    public ResolveSession(@NotNull Project project, @NotNull StorageManager storageManager, @NotNull ModuleDescriptorImpl rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory, @NotNull Function<FqName, Name> classifierAliases, @NotNull Predicate<FqNameUnsafe> specialClasses, @NotNull BindingTrace delegationTrace) {
        this.storageManager = storageManager;
        this.classifierAliases = classifierAliases;
        this.specialClasses = specialClasses;
        this.trace = storageManager.createSafeTrace(delegationTrace);
        this.injector = new InjectorForLazyResolve(project, this, rootDescriptor);
        this.module = rootDescriptor;
        PackageMemberDeclarationProvider provider = declarationProviderFactory.getPackageMemberDeclarationProvider(FqName.ROOT);
        assert (provider != null) : "No declaration provider for root package in " + rootDescriptor;
        this.rootPackage = new LazyPackageDescriptor(rootDescriptor, FqNameUnsafe.ROOT_NAME, this, provider);
        rootDescriptor.setRootNamespace(this.rootPackage);
        this.declarationProviderFactory = declarationProviderFactory;
        this.resolveElementCache = new ResolveElementCache(this);
    }

    @NotNull
    public InjectorForLazyResolve getInjector() {
        return this.injector;
    }

    public boolean isClassSpecial(@NotNull FqNameUnsafe fqName) {
        return this.specialClasses.apply(fqName);
    }

    @Override
    public ModuleDescriptor getRootModuleDescriptor() {
        return this.module;
    }

    @NotNull
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    @Nullable
    public NamespaceDescriptor getPackageDescriptor(@NotNull Name shortName) {
        return this.rootPackage.getMemberScope().getNamespace(shortName);
    }

    @Override
    @Nullable
    public NamespaceDescriptor getPackageDescriptorByFqName(FqName fqName) {
        if (fqName.isRoot()) {
            return this.rootPackage;
        }
        List<Name> names = fqName.pathSegments();
        NamespaceDescriptor current = this.getPackageDescriptor(names.get(0));
        if (current == null) {
            return null;
        }
        for (Name name : names.subList(1, names.size())) {
            if ((current = current.getMemberScope().getNamespace(name)) != null) continue;
            return null;
        }
        return current;
    }

    @Override
    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject.getParent() instanceof JetClassObject) {
            return this.getClassObjectDescriptor((JetClassObject)classOrObject.getParent());
        }
        JetScope resolutionScope = this.getInjector().getScopeProvider().getResolutionScopeForDeclaration(classOrObject);
        Name name = ResolveSessionUtils.safeNameForLazyResolve(classOrObject.getNameAsName());
        resolutionScope.getClassifier(name);
        DeclarationDescriptor declaration = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        if (declaration == null) {
            resolutionScope.getObjectDescriptor(name);
            declaration = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        }
        if (declaration == null) {
            throw new IllegalArgumentException("Could not find a classifier for " + classOrObject + " " + classOrObject.getText());
        }
        return (ClassDescriptor)declaration;
    }

    LazyClassDescriptor getClassObjectDescriptor(JetClassObject classObject) {
        JetClassLikeInfo classObjectInfo;
        LazyClassDescriptor parentClassDescriptor;
        JetClass aClass = PsiTreeUtil.getParentOfType((PsiElement)classObject, JetClass.class);
        if (aClass != null) {
            parentClassDescriptor = (LazyClassDescriptor)this.getClassDescriptor(aClass);
        } else {
            JetObjectDeclaration objectDeclaration = PsiTreeUtil.getParentOfType((PsiElement)classObject, JetObjectDeclaration.class);
            assert (objectDeclaration != null) : String.format("Class object %s can be in class or object in file %s", classObject, classObject.getContainingFile().getText());
            parentClassDescriptor = (LazyClassDescriptor)this.getClassDescriptor(objectDeclaration);
        }
        parentClassDescriptor.getClassObjectDescriptor();
        DeclarationDescriptor declaration = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classObject.getObjectDeclaration());
        if (declaration == null && (classObjectInfo = parentClassDescriptor.getClassObjectInfo(classObject)) != null) {
            final Name name = DescriptorUtils.getClassObjectName(parentClassDescriptor.getName().asString());
            return this.storageManager.compute(new Computable<LazyClassDescriptor>(){

                @Override
                public LazyClassDescriptor compute() {
                    return new LazyClassDescriptor(ResolveSession.this, parentClassDescriptor, name, classObjectInfo);
                }
            });
        }
        return (LazyClassDescriptor)declaration;
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        return this.trace.getBindingContext();
    }

    @NotNull
    public BindingTrace getTrace() {
        return this.trace;
    }

    @NotNull
    public DeclarationProviderFactory getDeclarationProviderFactory() {
        return this.declarationProviderFactory;
    }

    @Override
    @NotNull
    public DeclarationDescriptor resolveToDescriptor(JetDeclaration declaration) {
        DeclarationDescriptor result = declaration.accept(new JetVisitor<DeclarationDescriptor, Void>(){

            @Override
            public DeclarationDescriptor visitClass(JetClass klass, Void data) {
                return ResolveSession.this.getClassDescriptor(klass);
            }

            @Override
            public DeclarationDescriptor visitObjectDeclaration(JetObjectDeclaration declaration, Void data) {
                PsiElement parent = declaration.getParent();
                if (parent instanceof JetClassObject) {
                    JetClassObject jetClassObject = (JetClassObject)parent;
                    return ResolveSession.this.resolveToDescriptor(jetClassObject);
                }
                return ResolveSession.this.getClassDescriptor(declaration);
            }

            @Override
            public DeclarationDescriptor visitClassObject(JetClassObject classObject, Void data) {
                return ResolveSession.this.getClassObjectDescriptor(classObject);
            }

            @Override
            public DeclarationDescriptor visitTypeParameter(JetTypeParameter parameter, Void data) {
                List<TypeParameterDescriptor> typeParameters;
                JetTypeParameterListOwner ownerElement = PsiTreeUtil.getParentOfType((PsiElement)parameter, JetTypeParameterListOwner.class);
                DeclarationDescriptor ownerDescriptor = ResolveSession.this.resolveToDescriptor(ownerElement);
                if (ownerDescriptor instanceof CallableDescriptor) {
                    CallableDescriptor callableDescriptor = (CallableDescriptor)ownerDescriptor;
                    typeParameters = callableDescriptor.getTypeParameters();
                } else if (ownerDescriptor instanceof ClassDescriptor) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)ownerDescriptor;
                    typeParameters = classDescriptor.getTypeConstructor().getParameters();
                } else {
                    throw new IllegalStateException("Unknown owner kind for a type parameter: " + ownerDescriptor);
                }
                Name name = ResolveSessionUtils.safeNameForLazyResolve(parameter.getNameAsName());
                for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
                    if (!typeParameterDescriptor.getName().equals(name)) continue;
                    return typeParameterDescriptor;
                }
                throw new IllegalStateException("Type parameter " + name + " not found for " + ownerDescriptor);
            }

            @Override
            public DeclarationDescriptor visitNamedFunction(JetNamedFunction function, Void data) {
                JetScope scopeForDeclaration = ResolveSession.this.getInjector().getScopeProvider().getResolutionScopeForDeclaration(function);
                scopeForDeclaration.getFunctions(ResolveSessionUtils.safeNameForLazyResolve(function));
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
            }

            @Override
            public DeclarationDescriptor visitParameter(JetParameter parameter, Void data) {
                PsiElement grandFather = parameter.getParent().getParent();
                if (grandFather instanceof JetClass) {
                    JetClass jetClass = (JetClass)grandFather;
                    ClassDescriptor classDescriptor = ResolveSession.this.getClassDescriptor(jetClass);
                    if (parameter.getValOrVarNode() != null) {
                        classDescriptor.getDefaultType().getMemberScope().getProperties(ResolveSessionUtils.safeNameForLazyResolve(parameter));
                        return ResolveSession.this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                    }
                    ConstructorDescriptor constructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
                    assert (constructor != null) : "There are constructor parameters found, so a constructor should also exist";
                    constructor.getValueParameters();
                    return ResolveSession.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                return (DeclarationDescriptor)super.visitParameter(parameter, data);
            }

            @Override
            public DeclarationDescriptor visitProperty(JetProperty property, Void data) {
                JetScope scopeForDeclaration = ResolveSession.this.getInjector().getScopeProvider().getResolutionScopeForDeclaration(property);
                scopeForDeclaration.getProperties(ResolveSessionUtils.safeNameForLazyResolve(property));
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, property);
            }

            @Override
            public DeclarationDescriptor visitObjectDeclarationName(JetObjectDeclarationName declarationName, Void data) {
                JetScope scopeForDeclaration = ResolveSession.this.getInjector().getScopeProvider().getResolutionScopeForDeclaration(declarationName.getParent());
                scopeForDeclaration.getProperties(ResolveSessionUtils.safeNameForLazyResolve(declarationName));
                return ResolveSession.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, declarationName);
            }

            @Override
            public DeclarationDescriptor visitJetElement(JetElement element, Void data) {
                throw new IllegalArgumentException("Unsupported declaration type: " + element + " " + element.getText());
            }
        }, null);
        if (result == null) {
            throw new IllegalStateException("No descriptor resolved for " + declaration + " " + declaration.getText());
        }
        return result;
    }

    @NotNull
    public BindingContext resolveElement(@NotNull JetElement jetElement) {
        return this.resolveElementCache.resolveElement(jetElement);
    }

    @NotNull
    public Name resolveClassifierAlias(@NotNull FqName packageName, @NotNull Name alias) {
        Name actualName = this.classifierAliases.fun(packageName.child(alias));
        if (actualName == null) {
            return alias;
        }
        return actualName;
    }

    @Override
    public void forceResolveAll() {
        this.rootPackage.acceptVoid((DeclarationDescriptorVisitor<Void, Void>)new DeclarationDescriptorVisitorEmptyBodies<Void, Void>(){

            @Override
            public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, Void data) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                return null;
            }

            @Override
            public Void visitNamespaceDescriptor(NamespaceDescriptor descriptor, Void data) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                return null;
            }

            @Override
            public Void visitClassDescriptor(ClassDescriptor descriptor, Void data) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                return null;
            }

            @Override
            public Void visitModuleDeclaration(ModuleDescriptor descriptor, Void data) {
                ForceResolveUtil.forceResolveAllContents(descriptor);
                return null;
            }

            @Override
            public Void visitScriptDescriptor(ScriptDescriptor scriptDescriptor, Void data) {
                ForceResolveUtil.forceResolveAllContents(scriptDescriptor);
                return null;
            }
        });
    }
}

