/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.sam;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class SingleAbstractMethodUtils {
    @NotNull
    public static List<CallableMemberDescriptor> getAbstractMembers(@NotNull JetType type) {
        ArrayList<CallableMemberDescriptor> abstractMembers = Lists.newArrayList();
        for (DeclarationDescriptor member : type.getMemberScope().getAllDescriptors()) {
            if (!(member instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)member).getModality() != Modality.ABSTRACT) continue;
            abstractMembers.add((CallableMemberDescriptor)member);
        }
        return abstractMembers;
    }

    private static JetType fixProjections(@NotNull JetType functionType) {
        ArrayList<TypeProjection> arguments = Lists.newArrayList();
        for (TypeParameterDescriptor typeParameter : functionType.getConstructor().getParameters()) {
            Variance variance = typeParameter.getVariance();
            TypeProjection argument = functionType.getArguments().get(typeParameter.getIndex());
            Variance kind = argument.getProjectionKind();
            if (kind != Variance.INVARIANT && variance != Variance.INVARIANT) {
                if (kind == variance) {
                    arguments.add(new TypeProjection(argument.getType()));
                    continue;
                }
                return null;
            }
            arguments.add(argument);
        }
        ClassifierDescriptor classifier = functionType.getConstructor().getDeclarationDescriptor();
        assert (classifier instanceof ClassDescriptor) : "Not class: " + classifier;
        return new JetTypeImpl(functionType.getAnnotations(), functionType.getConstructor(), functionType.isNullable(), arguments, ((ClassDescriptor)classifier).getMemberScope(arguments));
    }

    @Nullable
    private static JetType getFunctionTypeForSamType(@NotNull JetType samType) {
        JetType functionTypeDefault;
        ClassifierDescriptor classifier = samType.getConstructor().getDeclarationDescriptor();
        if (classifier instanceof ClassDescriptorFromJvmBytecode && (functionTypeDefault = ((ClassDescriptorFromJvmBytecode)classifier).getFunctionTypeForSamInterface()) != null) {
            JetType substitute = TypeSubstitutor.create(samType).substitute(functionTypeDefault, Variance.INVARIANT);
            return substitute == null ? null : SingleAbstractMethodUtils.fixProjections(TypeUtils.makeNullableAsSpecified(substitute, samType.isNullable()));
        }
        return null;
    }

    @NotNull
    public static JetType getFunctionTypeForAbstractMethod(@NotNull FunctionDescriptor function) {
        JetType returnType = function.getReturnType();
        assert (returnType != null) : "function is not initialized: " + function;
        ArrayList<JetType> parameterTypes = Lists.newArrayList();
        for (ValueParameterDescriptor parameter : function.getValueParameters()) {
            parameterTypes.add(parameter.getType());
        }
        return KotlinBuiltIns.getInstance().getFunctionType(Collections.<AnnotationDescriptor>emptyList(), null, parameterTypes, returnType);
    }

    private static boolean isSamInterface(@NotNull ClassDescriptor klass) {
        CallableMemberDescriptor member;
        if (klass.getKind() != ClassKind.TRAIT) {
            return false;
        }
        List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(klass.getDefaultType());
        if (abstractMembers.size() == 1 && (member = abstractMembers.get(0)) instanceof SimpleFunctionDescriptor) {
            return member.getTypeParameters().isEmpty();
        }
        return false;
    }

    @NotNull
    public static SimpleFunctionDescriptor createSamConstructorFunction(@NotNull ClassOrNamespaceDescriptor owner, @NotNull ClassDescriptor samInterface) {
        assert (SingleAbstractMethodUtils.isSamInterface(samInterface)) : samInterface;
        SimpleFunctionDescriptorImpl result = new SimpleFunctionDescriptorImpl(owner, samInterface.getAnnotations(), samInterface.getName(), CallableMemberDescriptor.Kind.SYNTHESIZED);
        TypeParameters typeParameters = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(samInterface.getTypeConstructor().getParameters(), result);
        JetType parameterTypeUnsubstituted = SingleAbstractMethodUtils.getFunctionTypeForSamType(samInterface.getDefaultType());
        assert (parameterTypeUnsubstituted != null) : "couldn't get function type for SAM type " + samInterface.getDefaultType();
        JetType parameterType = typeParameters.substitutor.substitute(parameterTypeUnsubstituted, Variance.IN_VARIANCE);
        assert (parameterType != null) : "couldn't substitute type: " + parameterType + ", substitutor = " + typeParameters.substitutor;
        ValueParameterDescriptorImpl parameter = new ValueParameterDescriptorImpl(result, 0, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("function"), parameterType, false, null);
        JetType returnType = typeParameters.substitutor.substitute(samInterface.getDefaultType(), Variance.OUT_VARIANCE);
        assert (returnType != null) : "couldn't substitute type: " + returnType + ", substitutor = " + typeParameters.substitutor;
        result.initialize(null, null, typeParameters.descriptors, Arrays.asList(parameter), returnType, Modality.FINAL, samInterface.getVisibility(), false);
        return result;
    }

    public static boolean isSamType(@NotNull JetType type) {
        return SingleAbstractMethodUtils.getFunctionTypeForSamType(type) != null;
    }

    public static boolean isSamAdapterNecessary(@NotNull FunctionDescriptor fun) {
        for (ValueParameterDescriptor param : fun.getValueParameters()) {
            if (!SingleAbstractMethodUtils.isSamType(param.getType())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static SimpleFunctionDescriptor createSamAdapterFunction(final @NotNull SimpleFunctionDescriptor original) {
        final SimpleFunctionDescriptorImpl result = new SimpleFunctionDescriptorImpl(original.getContainingDeclaration(), original.getAnnotations(), original.getName(), CallableMemberDescriptor.Kind.SYNTHESIZED, original);
        FunctionInitializer initializer = new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> valueParameters, @Nullable JetType returnType) {
                result.initialize(null, original.getExpectedThisObject(), typeParameters, valueParameters, returnType, Modality.FINAL, original.getVisibility(), false);
            }
        };
        return SingleAbstractMethodUtils.initSamAdapter(original, result, initializer);
    }

    @NotNull
    public static ConstructorDescriptor createSamAdapterConstructor(final @NotNull ConstructorDescriptor original) {
        final ConstructorDescriptorImpl result = new ConstructorDescriptorImpl(original.getContainingDeclaration(), original.getAnnotations(), original.isPrimary(), CallableMemberDescriptor.Kind.SYNTHESIZED);
        FunctionInitializer initializer = new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> valueParameters, @Nullable JetType returnType) {
                result.initialize(typeParameters, valueParameters, original.getVisibility(), original.getExpectedThisObject() == ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
            }
        };
        return SingleAbstractMethodUtils.initSamAdapter(original, result, initializer);
    }

    private static <F extends FunctionDescriptor> F initSamAdapter(@NotNull F original, @NotNull F adapter, @NotNull FunctionInitializer initializer) {
        JetType returnType;
        TypeParameters typeParameters = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(original.getTypeParameters(), adapter);
        JetType returnTypeUnsubstituted = original.getReturnType();
        if (returnTypeUnsubstituted == null) {
            returnType = null;
        } else {
            returnType = typeParameters.substitutor.substitute(returnTypeUnsubstituted, Variance.OUT_VARIANCE);
            assert (returnType != null) : "couldn't substitute type: " + returnType + ", substitutor = " + typeParameters.substitutor;
        }
        ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
        for (ValueParameterDescriptor originalParam : original.getValueParameters()) {
            JetType originalType = originalParam.getType();
            JetType functionType = SingleAbstractMethodUtils.getFunctionTypeForSamType(originalType);
            JetType newTypeUnsubstituted = functionType != null ? functionType : originalType;
            JetType newType = typeParameters.substitutor.substitute(newTypeUnsubstituted, Variance.IN_VARIANCE);
            assert (newType != null) : "couldn't substitute type: " + newTypeUnsubstituted + ", substitutor = " + typeParameters.substitutor;
            ValueParameterDescriptorImpl newParam = new ValueParameterDescriptorImpl(adapter, originalParam.getIndex(), originalParam.getAnnotations(), originalParam.getName(), newType, false, null);
            valueParameters.add(newParam);
        }
        initializer.initialize(typeParameters.descriptors, valueParameters, returnType);
        return adapter;
    }

    @NotNull
    private static TypeParameters recreateAndInitializeTypeParameters(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> traitToFunTypeParameters = SignaturesUtil.recreateTypeParametersAndReturnMapping(originalParameters, newOwner);
        TypeSubstitutor typeParametersSubstitutor = SignaturesUtil.createSubstitutorForTypeParameters(traitToFunTypeParameters);
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> mapEntry : traitToFunTypeParameters.entrySet()) {
            TypeParameterDescriptor traitTypeParameter = mapEntry.getKey();
            TypeParameterDescriptorImpl funTypeParameter = mapEntry.getValue();
            for (JetType upperBound : traitTypeParameter.getUpperBounds()) {
                JetType upperBoundSubstituted = typeParametersSubstitutor.substitute(upperBound, Variance.INVARIANT);
                assert (upperBoundSubstituted != null) : "couldn't substitute type: " + upperBound + ", substitutor = " + typeParametersSubstitutor;
                funTypeParameter.addUpperBound(upperBoundSubstituted);
            }
            funTypeParameter.setInitialized();
        }
        ArrayList<TypeParameterDescriptorImpl> typeParameters = Lists.newArrayList(traitToFunTypeParameters.values());
        return new TypeParameters(typeParameters, typeParametersSubstitutor);
    }

    @NotNull
    public static SimpleFunctionDescriptor getAbstractMethodOfSamType(@NotNull JetType type) {
        return (SimpleFunctionDescriptor)SingleAbstractMethodUtils.getAbstractMembers(type).get(0);
    }

    @NotNull
    public static SimpleFunctionDescriptor getAbstractMethodOfSamInterface(@NotNull ClassDescriptor samInterface) {
        return SingleAbstractMethodUtils.getAbstractMethodOfSamType(samInterface.getDefaultType());
    }

    private SingleAbstractMethodUtils() {
    }

    private static abstract class FunctionInitializer {
        private FunctionInitializer() {
        }

        public abstract void initialize(@NotNull List<TypeParameterDescriptor> var1, @NotNull List<ValueParameterDescriptor> var2, @Nullable JetType var3);
    }

    private static class TypeParameters {
        public final List<TypeParameterDescriptor> descriptors;
        public final TypeSubstitutor substitutor;

        private TypeParameters(List<TypeParameterDescriptor> descriptors, TypeSubstitutor substitutor) {
            this.descriptors = descriptors;
            this.substitutor = substitutor;
        }
    }
}

