/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineEnterInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;

public class PseudocodeTraverser {
    @NotNull
    private static Instruction getStartInstruction(@NotNull Pseudocode pseudocode, @NotNull TraversalOrder traversalOrder) {
        return traversalOrder == TraversalOrder.FORWARD ? pseudocode.getEnterInstruction() : pseudocode.getSinkInstruction();
    }

    @NotNull
    private static Instruction getLastInstruction(@NotNull Pseudocode pseudocode, @NotNull TraversalOrder traversalOrder) {
        return traversalOrder == TraversalOrder.FORWARD ? pseudocode.getSinkInstruction() : pseudocode.getEnterInstruction();
    }

    @NotNull
    private static List<Instruction> getInstructions(@NotNull Pseudocode pseudocode, @NotNull TraversalOrder traversalOrder) {
        return traversalOrder == TraversalOrder.FORWARD ? pseudocode.getInstructions() : pseudocode.getReversedInstructions();
    }

    @NotNull
    private static Collection<Instruction> getPreviousInstruction(@NotNull Instruction instruction, @NotNull TraversalOrder traversalOrder) {
        return traversalOrder == TraversalOrder.FORWARD ? instruction.getPreviousInstructions() : instruction.getNextInstructions();
    }

    private static boolean isStartInstruction(@NotNull Instruction instruction, @NotNull TraversalOrder traversalOrder) {
        return traversalOrder == TraversalOrder.FORWARD ? instruction instanceof SubroutineEnterInstruction : instruction instanceof SubroutineSinkInstruction;
    }

    private static boolean shouldLookInside(Instruction instruction, LookInsideStrategy lookInside) {
        return lookInside == LookInsideStrategy.ANALYSE_LOCAL_DECLARATIONS && instruction instanceof LocalDeclarationInstruction;
    }

    public static <D> Map<Instruction, Edges<D>> collectData(@NotNull Pseudocode pseudocode, TraversalOrder traversalOrder, LookInsideStrategy lookInside, @NotNull D initialDataValue, @NotNull D initialDataValueForEnterInstruction, @NotNull InstructionDataMergeStrategy<D> instructionDataMergeStrategy) {
        LinkedHashMap<Instruction, Edges<D>> edgesMap = Maps.newLinkedHashMap();
        PseudocodeTraverser.initializeEdgesMap(pseudocode, lookInside, edgesMap, initialDataValue);
        edgesMap.put(PseudocodeTraverser.getStartInstruction(pseudocode, traversalOrder), Edges.create(initialDataValueForEnterInstruction, initialDataValueForEnterInstruction));
        boolean[] changed = new boolean[]{true};
        while (changed[0]) {
            changed[0] = false;
            PseudocodeTraverser.collectDataFromSubgraph(pseudocode, traversalOrder, lookInside, edgesMap, instructionDataMergeStrategy, Collections.<Instruction>emptyList(), changed, false);
        }
        return edgesMap;
    }

    private static <D> void initializeEdgesMap(@NotNull Pseudocode pseudocode, LookInsideStrategy lookInside, @NotNull Map<Instruction, Edges<D>> edgesMap, @NotNull D initialDataValue) {
        List<Instruction> instructions = pseudocode.getInstructions();
        Edges<D> initialEdge = Edges.create(initialDataValue, initialDataValue);
        for (Instruction instruction : instructions) {
            edgesMap.put(instruction, initialEdge);
            if (!PseudocodeTraverser.shouldLookInside(instruction, lookInside)) continue;
            PseudocodeTraverser.initializeEdgesMap(((LocalDeclarationInstruction)instruction).getBody(), lookInside, edgesMap, initialDataValue);
        }
    }

    private static <D> void collectDataFromSubgraph(@NotNull Pseudocode pseudocode, TraversalOrder traversalOrder, LookInsideStrategy lookInside, @NotNull Map<Instruction, Edges<D>> edgesMap, @NotNull InstructionDataMergeStrategy<D> instructionDataMergeStrategy, @NotNull Collection<Instruction> previousSubGraphInstructions, boolean[] changed, boolean isLocal) {
        List<Instruction> instructions = PseudocodeTraverser.getInstructions(pseudocode, traversalOrder);
        Instruction startInstruction = PseudocodeTraverser.getStartInstruction(pseudocode, traversalOrder);
        for (Instruction instruction : instructions) {
            Collection<Instruction> allPreviousInstructions;
            boolean isStart = PseudocodeTraverser.isStartInstruction(instruction, traversalOrder);
            if (!isLocal && isStart) continue;
            Collection<Instruction> previousInstructions = PseudocodeTraverser.getPreviousInstruction(instruction, traversalOrder);
            if (instruction == startInstruction && !previousSubGraphInstructions.isEmpty()) {
                allPreviousInstructions = Lists.newArrayList(previousInstructions);
                allPreviousInstructions.addAll(previousSubGraphInstructions);
            } else {
                allPreviousInstructions = previousInstructions;
            }
            if (PseudocodeTraverser.shouldLookInside(instruction, lookInside)) {
                Edges<D> newValue;
                Pseudocode subroutinePseudocode = ((LocalDeclarationInstruction)instruction).getBody();
                PseudocodeTraverser.collectDataFromSubgraph(subroutinePseudocode, traversalOrder, lookInside, edgesMap, instructionDataMergeStrategy, previousInstructions, changed, true);
                Instruction lastInstruction = PseudocodeTraverser.getLastInstruction(subroutinePseudocode, traversalOrder);
                Edges<D> previousValue = edgesMap.get(instruction);
                if (previousValue.equals(newValue = edgesMap.get(lastInstruction))) continue;
                changed[0] = true;
                edgesMap.put(instruction, newValue);
                continue;
            }
            Edges<D> previousDataValue = edgesMap.get(instruction);
            HashSet incomingEdgesData = Sets.newHashSet();
            for (Instruction previousInstruction : allPreviousInstructions) {
                Edges<D> previousData = edgesMap.get(previousInstruction);
                if (previousData == null) continue;
                incomingEdgesData.add(previousData.out);
            }
            Edges<D> mergedData = instructionDataMergeStrategy.execute(instruction, incomingEdgesData);
            if (mergedData.equals(previousDataValue)) continue;
            changed[0] = true;
            edgesMap.put(instruction, mergedData);
        }
    }

    public static void traverse(@NotNull Pseudocode pseudocode, TraversalOrder traversalOrder, InstructionAnalyzeStrategy instructionAnalyzeStrategy) {
        List<Instruction> instructions = PseudocodeTraverser.getInstructions(pseudocode, traversalOrder);
        for (Instruction instruction : instructions) {
            if (instruction instanceof LocalDeclarationInstruction) {
                PseudocodeTraverser.traverse(((LocalDeclarationInstruction)instruction).getBody(), traversalOrder, instructionAnalyzeStrategy);
            }
            instructionAnalyzeStrategy.execute(instruction);
        }
    }

    public static <D> void traverse(@NotNull Pseudocode pseudocode, TraversalOrder traversalOrder, @NotNull Map<Instruction, Edges<D>> edgesMap, @NotNull InstructionDataAnalyzeStrategy<D> instructionDataAnalyzeStrategy) {
        List<Instruction> instructions = PseudocodeTraverser.getInstructions(pseudocode, traversalOrder);
        for (Instruction instruction : instructions) {
            Edges<D> edges;
            if (instruction instanceof LocalDeclarationInstruction) {
                PseudocodeTraverser.traverse(((LocalDeclarationInstruction)instruction).getBody(), traversalOrder, edgesMap, instructionDataAnalyzeStrategy);
            }
            instructionDataAnalyzeStrategy.execute(instruction, (edges = edgesMap.get(instruction)) != null ? (Object)edges.in : null, edges != null ? (Object)edges.out : null);
        }
    }

    public static class Edges<T> {
        public final T in;
        public final T out;

        Edges(@NotNull T in, @NotNull T out) {
            this.in = in;
            this.out = out;
        }

        public static <T> Edges<T> create(@NotNull T in, @NotNull T out) {
            return new Edges<T>(in, out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Edges)) {
                return false;
            }
            Edges edges = (Edges)o;
            if (this.in != null ? !this.in.equals(edges.in) : edges.in != null) {
                return false;
            }
            return !(this.out != null ? !this.out.equals(edges.out) : edges.out != null);
        }

        public int hashCode() {
            int result = this.in != null ? this.in.hashCode() : 0;
            result = 31 * result + (this.out != null ? this.out.hashCode() : 0);
            return result;
        }
    }

    public static interface InstructionAnalyzeStrategy {
        public void execute(@NotNull Instruction var1);
    }

    public static interface InstructionDataAnalyzeStrategy<D> {
        public void execute(@NotNull Instruction var1, @Nullable D var2, @Nullable D var3);
    }

    public static interface InstructionDataMergeStrategy<D> {
        public Edges<D> execute(@NotNull Instruction var1, @NotNull Collection<D> var2);
    }

    public static enum LookInsideStrategy {
        ANALYSE_LOCAL_DECLARATIONS,
        SKIP_LOCAL_DECLARATIONS;

    }

    public static enum TraversalOrder {
        FORWARD,
        BACKWARD;

    }
}

