/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenAnnotatingVisitor;
import org.jetbrains.jet.codegen.binding.MutableClosure;
import org.jetbrains.jet.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class CodegenBinding {
    public static final WritableSlice<ClassDescriptor, MutableClosure> CLOSURE = Slices.createSimpleSlice();
    public static final WritableSlice<FunctionDescriptor, ClassDescriptor> CLASS_FOR_FUNCTION = Slices.createSimpleSlice();
    public static final WritableSlice<ScriptDescriptor, ClassDescriptor> CLASS_FOR_SCRIPT = Slices.createSimpleSlice();
    public static final WritableSlice<DeclarationDescriptor, JvmClassName> FQN = Slices.createSimpleSlice();
    public static final WritableSlice<JvmClassName, Boolean> SCRIPT_NAMES = Slices.createSimpleSetSlice();
    public static final WritableSlice<ClassDescriptor, Boolean> ENUM_ENTRY_CLASS_NEED_SUBCLASS = Slices.createSimpleSetSlice();
    public static final WritableSlice<ClassDescriptor, Collection<ClassDescriptor>> INNER_CLASSES = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, ClassDescriptorFromJvmBytecode> SAM_VALUE = Slices.createSimpleSlice();

    private CodegenBinding() {
    }

    public static void initTrace(BindingTrace bindingTrace, Collection<JetFile> files) {
        CodegenAnnotatingVisitor visitor = new CodegenAnnotatingVisitor(bindingTrace);
        for (JetFile file : CodegenBinding.allFilesInNamespaces(bindingTrace.getBindingContext(), files)) {
            file.accept(visitor);
        }
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, JetEnumEntry enumEntry) {
        return CodegenBinding.enumEntryNeedSubclass(bindingContext, bindingContext.get(BindingContext.CLASS, enumEntry));
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, ClassDescriptor classDescriptor) {
        return Boolean.TRUE.equals(bindingContext.get(ENUM_ENTRY_CLASS_NEED_SUBCLASS, classDescriptor));
    }

    @NotNull
    public static JvmClassName classNameForScriptDescriptor(BindingContext bindingContext, @NotNull ScriptDescriptor scriptDescriptor) {
        ClassDescriptor classDescriptor = bindingContext.get(CLASS_FOR_SCRIPT, scriptDescriptor);
        return CodegenBinding.fqn(bindingContext, classDescriptor);
    }

    @NotNull
    public static JvmClassName classNameForScriptPsi(BindingContext bindingContext, @NotNull JetScript script) {
        ScriptDescriptor scriptDescriptor = bindingContext.get(BindingContext.SCRIPT, script);
        if (scriptDescriptor == null) {
            throw new IllegalStateException("Script descriptor not found by PSI " + script);
        }
        return CodegenBinding.classNameForScriptDescriptor(bindingContext, scriptDescriptor);
    }

    public static ClassDescriptor enclosingClassDescriptor(BindingContext bindingContext, ClassDescriptor descriptor) {
        CalculatedClosure closure = bindingContext.get(CLOSURE, descriptor);
        return closure == null ? null : closure.getEnclosingClass();
    }

    @NotNull
    public static ClassDescriptor anonymousClassForFunction(@NotNull BindingContext bindingContext, @NotNull FunctionDescriptor descriptor) {
        return bindingContext.get(CLASS_FOR_FUNCTION, descriptor);
    }

    @NotNull
    private static JvmClassName fqn(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor descriptor) {
        return bindingContext.get(FQN, descriptor);
    }

    @NotNull
    public static JvmClassName classNameForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull JetElement expression) {
        ClassDescriptor descriptor;
        if (expression instanceof JetObjectLiteralExpression) {
            JetObjectLiteralExpression jetObjectLiteralExpression = (JetObjectLiteralExpression)expression;
            expression = jetObjectLiteralExpression.getObjectDeclaration();
        }
        if ((descriptor = bindingContext.get(BindingContext.CLASS, expression)) == null) {
            SimpleFunctionDescriptor functionDescriptor = bindingContext.get(BindingContext.FUNCTION, expression);
            assert (functionDescriptor != null);
            return CodegenBinding.classNameForAnonymousClass(bindingContext, functionDescriptor);
        }
        return CodegenBinding.fqn(bindingContext, descriptor);
    }

    @NotNull
    public static JvmClassName classNameForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull FunctionDescriptor descriptor) {
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForFunction(bindingContext, descriptor);
        return CodegenBinding.fqn(bindingContext, classDescriptor);
    }

    public static void registerClassNameForScript(BindingTrace bindingTrace, @NotNull ScriptDescriptor scriptDescriptor, @NotNull JvmClassName className) {
        bindingTrace.record(SCRIPT_NAMES, className);
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(scriptDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Name.special("<script-" + className + ">"));
        classDescriptor.initialize(false, Collections.emptyList(), Collections.singletonList(KotlinBuiltIns.getInstance().getAnyType()), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null, false);
        CodegenBinding.recordClosure(bindingTrace, null, classDescriptor, null, className, false);
        assert (PsiCodegenPredictor.checkPredictedClassNameForFun(bindingTrace.getBindingContext(), scriptDescriptor, classDescriptor));
        bindingTrace.record(CLASS_FOR_SCRIPT, scriptDescriptor, classDescriptor);
    }

    public static boolean canHaveOuter(BindingContext bindingContext, @NotNull ClassDescriptor classDescriptor) {
        if (CodegenBinding.isSingleton(bindingContext, classDescriptor)) {
            return false;
        }
        ClassDescriptor enclosing = CodegenBinding.enclosingClassDescriptor(bindingContext, classDescriptor);
        if (enclosing == null) {
            return false;
        }
        ClassKind kind = classDescriptor.getKind();
        if (kind == ClassKind.CLASS) {
            return classDescriptor.isInner() || !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor);
        }
        if (kind == ClassKind.OBJECT) {
            return !CodegenBinding.isSingleton(bindingContext, enclosing);
        }
        return false;
    }

    public static boolean isSingleton(BindingContext bindingContext, @NotNull ClassDescriptor classDescriptor) {
        if (CodegenBinding.isObjectDeclaration(bindingContext, classDescriptor)) {
            return true;
        }
        return classDescriptor.getKind() == ClassKind.ENUM_ENTRY;
    }

    static void recordClosure(BindingTrace bindingTrace, @Nullable JetElement element, ClassDescriptor classDescriptor, @Nullable ClassDescriptor enclosing, JvmClassName name, boolean functionLiteral) {
        JetDelegatorToSuperCall superCall = CodegenBinding.findSuperCall(bindingTrace.getBindingContext(), element);
        CallableDescriptor enclosingReceiver = null;
        if (classDescriptor.getContainingDeclaration() instanceof CallableDescriptor) {
            enclosingReceiver = (CallableDescriptor)classDescriptor.getContainingDeclaration();
            CallableDescriptor callableDescriptor = enclosingReceiver = enclosingReceiver instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)enclosingReceiver).getCorrespondingProperty() : enclosingReceiver;
            if (enclosingReceiver.getReceiverParameter() == null) {
                enclosingReceiver = null;
            }
        }
        MutableClosure closure = new MutableClosure(superCall, enclosing, enclosingReceiver);
        assert (PsiCodegenPredictor.checkPredictedNameFromPsi(bindingTrace, classDescriptor, name));
        bindingTrace.record(FQN, classDescriptor, name);
        bindingTrace.record(CLOSURE, classDescriptor, closure);
        if (CodegenBinding.canHaveOuter(bindingTrace.getBindingContext(), classDescriptor) && !functionLiteral) {
            closure.setCaptureThis();
        }
        if (enclosing != null) {
            CodegenBinding.recordInnerClass(bindingTrace, enclosing, classDescriptor);
        }
    }

    private static void recordInnerClass(@NotNull BindingTrace bindingTrace, @NotNull ClassDescriptor outer, @NotNull ClassDescriptor inner) {
        Collection<ClassDescriptor> innerClasses = bindingTrace.get(INNER_CLASSES, outer);
        if (innerClasses == null) {
            innerClasses = new ArrayList<ClassDescriptor>();
            bindingTrace.record(INNER_CLASSES, outer, innerClasses);
        }
        innerClasses.add(inner);
    }

    public static void registerClassNameForScript(BindingTrace bindingTrace, @NotNull JetScript jetScript, @NotNull JvmClassName className) {
        ScriptDescriptor descriptor = bindingTrace.getBindingContext().get(BindingContext.SCRIPT, jetScript);
        if (descriptor == null) {
            throw new IllegalStateException("Descriptor is not found for PSI " + jetScript);
        }
        CodegenBinding.registerClassNameForScript(bindingTrace, descriptor, className);
    }

    @NotNull
    public static Collection<JetFile> allFilesInNamespaces(BindingContext bindingContext, Collection<JetFile> files) {
        HashSet<FqName> names = new HashSet<FqName>();
        for (JetFile file : files) {
            if (file.isScript()) continue;
            names.add(JetPsiUtil.getFQName(file));
        }
        HashSet<JetFile> answer = new HashSet<JetFile>();
        answer.addAll(files);
        for (FqName name : names) {
            NamespaceDescriptor namespaceDescriptor = bindingContext.get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, name);
            Collection<JetFile> jetFiles = bindingContext.get(BindingContext.NAMESPACE_TO_FILES, namespaceDescriptor);
            if (jetFiles == null) continue;
            answer.addAll(jetFiles);
        }
        ArrayList<JetFile> sortedAnswer = new ArrayList<JetFile>(answer);
        Collections.sort(sortedAnswer, new Comparator<JetFile>(){

            @NotNull
            private String path(JetFile file) {
                VirtualFile virtualFile = file.getVirtualFile();
                assert (virtualFile != null) : "VirtualFile is null for JetFile: " + file.getName();
                return virtualFile.getPath();
            }

            @Override
            public int compare(JetFile first, JetFile second) {
                return this.path(first).compareTo(this.path(second));
            }
        });
        return sortedAnswer;
    }

    public static boolean isObjectLiteral(BindingContext bindingContext, ClassDescriptor declaration) {
        PsiElement psiElement = BindingContextUtils.descriptorToDeclaration(bindingContext, declaration);
        return psiElement instanceof JetObjectDeclaration && ((JetObjectDeclaration)psiElement).isObjectLiteral();
    }

    public static boolean isObjectDeclaration(BindingContext bindingContext, ClassDescriptor declaration) {
        PsiElement psiElement = BindingContextUtils.descriptorToDeclaration(bindingContext, declaration);
        return psiElement instanceof JetObjectDeclaration && !((JetObjectDeclaration)psiElement).isObjectLiteral();
    }

    public static boolean isLocalNamedFun(DeclarationDescriptor fd) {
        if (fd instanceof FunctionDescriptor) {
            FunctionDescriptor descriptor = (FunctionDescriptor)fd;
            return descriptor.getVisibility() == Visibilities.LOCAL && !descriptor.getName().isSpecial();
        }
        return false;
    }

    @NotNull
    public static JvmClassName getJvmInternalName(BindingTrace bindingTrace, @NotNull DeclarationDescriptor descriptor) {
        descriptor = descriptor.getOriginal();
        JvmClassName name = bindingTrace.getBindingContext().get(FQN, descriptor);
        if (name != null) {
            return name;
        }
        name = JvmClassName.byInternalName(CodegenBinding.getJvmInternalFQNameImpl(bindingTrace, descriptor));
        assert (PsiCodegenPredictor.checkPredictedNameFromPsi(bindingTrace, descriptor, name));
        bindingTrace.record(FQN, descriptor, name);
        return name;
    }

    private static String getJvmInternalFQNameImpl(BindingTrace bindingTrace, DeclarationDescriptor descriptor) {
        ClassDescriptor klass;
        if (descriptor instanceof FunctionDescriptor) {
            throw new IllegalStateException("requested fq name for function: " + descriptor);
        }
        if (descriptor.getContainingDeclaration() instanceof ModuleDescriptor || descriptor instanceof ScriptDescriptor) {
            return "";
        }
        if (descriptor instanceof ModuleDescriptor) {
            throw new IllegalStateException("missed something");
        }
        if (descriptor instanceof ClassDescriptor && ((klass = (ClassDescriptor)descriptor).getKind() == ClassKind.OBJECT || klass.getKind() == ClassKind.CLASS_OBJECT) && klass.getContainingDeclaration() instanceof ClassDescriptor) {
            ClassDescriptor containingKlass = (ClassDescriptor)klass.getContainingDeclaration();
            if (containingKlass.getKind() == ClassKind.ENUM_CLASS) {
                return CodegenBinding.getJvmInternalName(bindingTrace, containingKlass).getInternalName();
            }
            if (klass.getKind() == ClassKind.OBJECT) {
                return CodegenBinding.getJvmInternalName(bindingTrace, containingKlass).getInternalName() + "$" + klass.getName();
            }
            return CodegenBinding.getJvmInternalName(bindingTrace, containingKlass).getInternalName() + "$object";
        }
        DeclarationDescriptor container = descriptor.getContainingDeclaration();
        if (container == null) {
            throw new IllegalStateException("descriptor has no container: " + descriptor);
        }
        Name name = descriptor.getName();
        String baseName = CodegenBinding.getJvmInternalName(bindingTrace, container).getInternalName();
        if (!baseName.isEmpty()) {
            return baseName + (container instanceof NamespaceDescriptor ? "/" : "$") + name.getIdentifier();
        }
        return name.getIdentifier();
    }

    public static boolean isVarCapturedInClosure(BindingContext bindingContext, DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof VariableDescriptor) || descriptor instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor;
        return bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null && variableDescriptor.isVar();
    }

    public static boolean hasThis0(BindingContext bindingContext, ClassDescriptor classDescriptor) {
        CalculatedClosure closure = bindingContext.get(CLOSURE, classDescriptor);
        return closure != null && closure.getCaptureThis() != null;
    }

    private static JetDelegatorToSuperCall findSuperCall(BindingContext bindingContext, JetElement classOrObject) {
        if (!(classOrObject instanceof JetClassOrObject)) {
            return null;
        }
        if (classOrObject instanceof JetClass && ((JetClass)classOrObject).isTrait()) {
            return null;
        }
        for (JetDelegationSpecifier specifier : ((JetClassOrObject)classOrObject).getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorToSuperCall)) continue;
            JetType superType = bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null);
            ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
            assert (superClassDescriptor != null);
            if (CodegenUtil.isInterface(superClassDescriptor)) continue;
            return (JetDelegatorToSuperCall)specifier;
        }
        return null;
    }
}

