/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;

public abstract class TPrimitiveHash
extends THash {
    protected transient byte[] _states;

    public TPrimitiveHash() {
    }

    public TPrimitiveHash(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public TPrimitiveHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    public Object clone() {
        TPrimitiveHash h = (TPrimitiveHash)super.clone();
        h._states = (byte[])this._states.clone();
        return h;
    }

    @Override
    protected int capacity() {
        return this._states.length;
    }

    @Override
    protected void removeAt(int index) {
        this._states[index] = 2;
        super.removeAt(index);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._states = new byte[capacity];
        return capacity;
    }
}

