/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiScopesUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.scope.util.PsiScopesUtil");

    private PsiScopesUtil() {
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (entrance == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        return PsiScopesUtil.treeWalkUp(processor, entrance, maxScope, ResolveState.initial());
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (entrance == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (!entrance.isValid()) {
            LOG.error(new PsiInvalidElementAccessException(entrance));
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        while (scope != null) {
            PsiModifierList modifierList;
            ProgressIndicatorProvider.checkCanceled();
            if (scope instanceof PsiClass) {
                processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, scope);
            }
            if (!scope.processDeclarations(processor, state, prevParent, entrance)) {
                return false;
            }
            if (scope instanceof PsiModifierListOwner && !(scope instanceof PsiParameter) && (modifierList = ((PsiModifierListOwner)scope).getModifierList()) != null && modifierList.hasModifierProperty("static")) {
                processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
            }
            if (scope == maxScope || (scope = (prevParent = scope).getContext()) != null && scope != prevParent.getParent() && !scope.isValid()) break;
            processor.handleEvent(JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        }
        return true;
    }

    public static boolean walkChildrenScopes(@NotNull PsiElement thisElement, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        if (thisElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/util/PsiScopesUtil", "walkChildrenScopes"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/scope/util/PsiScopesUtil", "walkChildrenScopes"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/scope/util/PsiScopesUtil", "walkChildrenScopes"));
        }
        PsiElement child = null;
        if (lastParent != null && lastParent.getParent() == thisElement && (child = lastParent.getPrevSibling()) == null) {
            return true;
        }
        if (child == null) {
            child = thisElement.getLastChild();
        }
        while (child != null) {
            if (!child.processDeclarations(processor, state, null, place)) {
                return false;
            }
            child = child.getPrevSibling();
        }
        return true;
    }

    public static void processTypeDeclarations(PsiType type, PsiElement place, PsiScopeProcessor processor) {
        if (type instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(place);
            PsiClass arrayClass = JavaPsiFacade.getInstance(place.getProject()).getElementFactory().getArrayClass(languageLevel);
            PsiTypeParameter[] arrayTypeParameters = arrayClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (arrayTypeParameters.length > 0) {
                substitutor = substitutor.put(arrayTypeParameters[0], ((PsiArrayType)type).getComponentType());
            }
            arrayClass.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor), arrayClass, place);
        } else if (type instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)type).getConjuncts()) {
                PsiScopesUtil.processTypeDeclarations(psiType, place, processor);
            }
        } else if (type instanceof PsiDisjunctionType) {
            PsiType lub = ((PsiDisjunctionType)type).getLeastUpperBound();
            PsiScopesUtil.processTypeDeclarations(lub, place, processor);
        } else {
            PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType(type);
            PsiClass clazz = (PsiClass)result.getElement();
            if (clazz != null) {
                clazz.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result.getSubstitutor()), clazz, place);
            }
        }
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        return PsiScopesUtil.resolveAndWalk(processor, ref, maxScope, false);
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope, boolean incompleteCode) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        PsiElement qualifier = ref.getQualifier();
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (classNameElement == null) {
            return true;
        }
        if (qualifier != null) {
            PsiElement target = null;
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (qualifier instanceof PsiExpression || qualifier instanceof PsiJavaCodeReferenceElement) {
                PsiType type = null;
                if (qualifier instanceof PsiExpression) {
                    type = ((PsiExpression)qualifier).getType();
                    if (type != null) assert (type.isValid()) : type.getClass() + "; " + qualifier;
                    PsiScopesUtil.processTypeDeclarations(type, ref, processor);
                }
                if (type == null && qualifier instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)qualifier;
                    JavaResolveResult result = referenceElement.advancedResolve(incompleteCode);
                    target = result.getElement();
                    substitutor = result.getSubstitutor();
                    if (target instanceof PsiVariable) {
                        type = substitutor.substitute(((PsiVariable)target).getType());
                        if (type instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor = substitutor.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                    } else if (target instanceof PsiMethod) {
                        type = substitutor.substitute(((PsiMethod)target).getReturnType());
                        if (type instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor = substitutor.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                        PsiType[] types = referenceElement.getTypeParameters();
                        if (target instanceof PsiClass) {
                            substitutor = substitutor.putAll((PsiClass)target, types);
                        }
                    } else if (target instanceof PsiClass) {
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                    }
                }
            }
            if (target != null) {
                return target.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor), target, ref);
            }
        } else {
            return PsiScopesUtil.treeWalkUp(processor, ref, maxScope);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setupAndRunProcessor(MethodsProcessor processor, PsiCallExpression call, boolean dummyImplicitConstructor) throws MethodProcessorSetupFailedException {
        if (call instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)call;
            PsiReferenceExpression ref = methodCall.getMethodExpression();
            processor.setArgumentList(methodCall.getArgumentList());
            processor.obtainTypeArguments(methodCall);
            if (!ref.isQualified() || ref.getReferenceNameElement() instanceof PsiKeyword) {
                PsiElement referenceNameElement = ref.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                if (referenceNameElement instanceof PsiKeyword) {
                    PsiKeyword keyword = (PsiKeyword)referenceNameElement;
                    if (keyword.getTokenType() == JavaTokenType.THIS_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for this expression");
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(aClass);
                        aClass.processDeclarations(processor, ResolveState.initial(), null, call);
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, aClass);
                        return;
                    } else if (keyword.getTokenType() == JavaTokenType.SUPER_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for super expression");
                        }
                        PsiClass superClass = aClass.getSuperClass();
                        if (superClass == null) return;
                        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                        PsiClass runSuper = superClass;
                        ArrayList<PsiSubstitutor> contextSubstitutors = new ArrayList<PsiSubstitutor>();
                        do {
                            if (runSuper != null) {
                                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(runSuper, aClass, PsiSubstitutor.EMPTY);
                                contextSubstitutors.add(superSubstitutor);
                            }
                            if (aClass.hasModifierProperty("static")) break;
                            if ((aClass = JavaResolveUtil.getContextClass(aClass)) == null) continue;
                            runSuper = aClass.getSuperClass();
                        } while (aClass != null);
                        for (int i = contextSubstitutors.size() - 1; i >= 0; --i) {
                            PsiSubstitutor contextSubstitutor = (PsiSubstitutor)contextSubstitutors.get(i);
                            substitutor = substitutor.putAll(contextSubstitutor);
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(null);
                        PsiMethod[] constructors = superClass.getConstructors();
                        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor);
                        for (PsiMethod constructor : constructors) {
                            if (processor.execute(constructor, state)) continue;
                            return;
                        }
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, superClass);
                        return;
                    } else {
                        LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                    }
                    return;
                } else if (referenceNameElement instanceof PsiIdentifier) {
                    processor.setIsConstructor(false);
                    processor.setName(referenceNameElement.getText());
                    processor.setAccessClass(null);
                    PsiScopesUtil.resolveAndWalk(processor, ref, null);
                    return;
                } else {
                    LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                }
                return;
            } else {
                PsiElement referenceName = methodCall.getMethodExpression().getReferenceNameElement();
                PsiManager manager = call.getManager();
                PsiElement qualifier = ref.getQualifier();
                if (referenceName == null) {
                    throw new MethodProcessorSetupFailedException("Can't resolve method name for this expression");
                }
                if (referenceName instanceof PsiIdentifier && qualifier instanceof PsiExpression) {
                    PsiAnonymousClass anonymousClass;
                    PsiExpression initializer;
                    PsiElement resolve;
                    PsiType type = ((PsiExpression)qualifier).getType();
                    if (type != null && qualifier instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiVariable && ((PsiVariable)resolve).hasModifierProperty("final") && ((PsiVariable)resolve).hasInitializer() && (initializer = ((PsiVariable)resolve).getInitializer()) instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)initializer).getAnonymousClass()) != null && type.equals(anonymousClass.getBaseClassType())) {
                        type = initializer.getType();
                    }
                    if (type == null) {
                        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) throw new MethodProcessorSetupFailedException("Cant determine qualifier type!");
                        JavaResolveResult result = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(false);
                        if (!(result.getElement() instanceof PsiClass)) return;
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                        PsiScopesUtil.processQualifierResult(result, processor, methodCall);
                        return;
                    } else if (type instanceof PsiIntersectionType) {
                        PsiType[] conjuncts;
                        for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type).getConjuncts()) {
                            if (!PsiScopesUtil.processQualifierType(conjunct, processor, manager, methodCall)) break;
                        }
                        return;
                    } else if (type instanceof PsiDisjunctionType) {
                        PsiScopesUtil.processQualifierType(((PsiDisjunctionType)type).getLeastUpperBound(), processor, manager, methodCall);
                        return;
                    } else {
                        PsiScopesUtil.processQualifierType(type, processor, manager, methodCall);
                    }
                    return;
                } else {
                    LOG.error("ref: " + ref + " (" + ref.getClass() + ")," + " ref.getReferenceNameElement()=" + ref.getReferenceNameElement() + "; methodCall.getMethodExpression().getReferenceNameElement()=" + methodCall.getMethodExpression().getReferenceNameElement() + "; qualifier=" + qualifier);
                }
            }
            return;
        } else {
            LOG.assertTrue(call instanceof PsiNewExpression);
            PsiNewExpression newExpr = (PsiNewExpression)call;
            PsiJavaCodeReferenceElement classRef = newExpr.getClassOrAnonymousClassReference();
            if (classRef == null) {
                throw new MethodProcessorSetupFailedException("Cant get reference to class in new expression");
            }
            JavaResolveResult result = classRef.advancedResolve(false);
            PsiClass aClass = (PsiClass)result.getElement();
            if (aClass == null) {
                throw new MethodProcessorSetupFailedException("Cant resolve class in new expression");
            }
            processor.setIsConstructor(true);
            processor.setAccessClass(aClass);
            processor.setArgumentList(newExpr.getArgumentList());
            processor.obtainTypeArguments(newExpr);
            aClass.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result.getSubstitutor()), null, call);
            if (!dummyImplicitConstructor) return;
            PsiScopesUtil.processDummyConstructor(processor, aClass);
        }
    }

    private static boolean processQualifierType(@NotNull PsiType type, MethodsProcessor processor, PsiManager manager, PsiMethodCallExpression call) throws MethodProcessorSetupFailedException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/util/PsiScopesUtil", "processQualifierType"));
        }
        LOG.assertTrue(type.isValid());
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)type).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call);
        }
        if (type instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(call);
            PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
            PsiClassType.ClassResolveResult qualifierResult = factory.getArrayClassType(((PsiArrayType)type).getComponentType(), languageLevel).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call);
        }
        if (type instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type).getConjuncts()) {
                if (PsiScopesUtil.processQualifierType(conjunct, processor, manager, call)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processQualifierResult(JavaResolveResult qualifierResult, MethodsProcessor processor, PsiMethodCallExpression methodCall) throws MethodProcessorSetupFailedException {
        PsiExpression qualifier;
        PsiElement resolve = qualifierResult.getElement();
        if (resolve == null) {
            throw new MethodProcessorSetupFailedException("Cant determine qualifier class!");
        }
        if (resolve instanceof PsiTypeParameter) {
            processor.setAccessClass((PsiClass)resolve);
        } else if (resolve instanceof PsiClass && !((qualifier = methodCall.getMethodExpression().getQualifierExpression()) instanceof PsiSuperExpression)) {
            processor.setAccessClass((PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement());
        }
        processor.setIsConstructor(false);
        processor.setName(methodCall.getMethodExpression().getReferenceName());
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, qualifierResult.getSubstitutor());
        return resolve.processDeclarations(processor, state, methodCall, methodCall);
    }

    private static void processDummyConstructor(MethodsProcessor processor, PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        try {
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length != 0) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
            PsiMethod dummyConstructor = factory.createConstructor();
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier != null) {
                dummyConstructor.getNameIdentifier().replace(nameIdentifier);
            }
            processor.forceAddResult(dummyConstructor);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }
}

