/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.MutableInterval;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.StripedIDGenerator;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx,
MutableInterval {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.RangeMarkerImpl");
    protected final DocumentEx myDocument;
    protected RangeMarkerTree.RMNode<RangeMarkerEx> myNode;
    private final long myId;
    private static final StripedIDGenerator counter = new StripedIDGenerator();

    protected RangeMarkerImpl(@NotNull DocumentEx document, int start, int end, boolean register) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "<init>"));
        }
        this(document, start, end, register, false, false);
    }

    private RangeMarkerImpl(@NotNull DocumentEx document, int start, int end, boolean register, boolean greedyToLeft, boolean greedyToRight) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "<init>"));
        }
        if (start < 0) {
            throw new IllegalArgumentException("Wrong start: " + start + "; end=" + end);
        }
        if (end > document.getTextLength()) {
            throw new IllegalArgumentException("Wrong end: " + end + "; document length=" + document.getTextLength() + "; start=" + start);
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end: start=" + start + "; end=" + end);
        }
        this.myDocument = document;
        this.myId = counter.next();
        if (register) {
            this.registerInTree(start, end, greedyToLeft, greedyToRight, 0);
        }
    }

    protected void registerInTree(int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        ((DocumentImpl)this.myDocument).addRangeMarker(this, start, end, greedyToLeft, greedyToRight, layer);
    }

    protected boolean unregisterInTree() {
        if (!this.isValid()) {
            return false;
        }
        IntervalTreeImpl tree = this.myNode.getTree();
        tree.checkMax(true);
        boolean b = this.myDocument.removeRangeMarker(this);
        tree.checkMax(true);
        return b;
    }

    public long getId() {
        return this.myId;
    }

    @Override
    public void dispose() {
        this.unregisterInTree();
    }

    @Override
    public int getStartOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return this.intervalStart() + (node == null ? 0 : node.computeDeltaUpToRoot());
    }

    @Override
    public int getEndOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return this.intervalEnd() + (node == null ? 0 : node.computeDeltaUpToRoot());
    }

    public void invalidate(final @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "invalidate"));
        }
        this.setValid(false);
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node != null) {
            node.processAliveKeys(new Processor<RangeMarkerEx>(){

                @Override
                public boolean process(RangeMarkerEx markerEx) {
                    RangeMarkerImpl.this.myNode.getTree().reportInvalidation(markerEx, reason);
                    return true;
                }
            });
        }
    }

    @Override
    @NotNull
    public DocumentEx getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeMarkerImpl", "getDocument"));
        }
        return documentEx;
    }

    @Override
    public boolean isGreedyToLeft() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToLeft();
    }

    @Override
    public boolean isGreedyToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToRight();
    }

    public final void documentChanged(DocumentEvent e) {
        int oldStart = this.intervalStart();
        int oldEnd = this.intervalEnd();
        int docLength = this.myDocument.getTextLength();
        if (!this.isValid()) {
            LOG.error("Invalid range marker " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + ". Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (this.intervalStart() > this.intervalEnd() || this.intervalStart() < 0 || this.intervalEnd() > docLength - e.getNewLength() + e.getOldLength()) {
            LOG.error("RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " is invalid before update. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            this.invalidate(e);
            return;
        }
        this.changedUpdateImpl(e);
        if (this.isValid() && (this.intervalStart() > this.intervalEnd() || this.intervalStart() < 0 || this.intervalEnd() > docLength)) {
            LOG.error("Update failed. Event = " + e + ". " + "old doc length=" + docLength + "; real doc length = " + this.myDocument.getTextLength() + "; " + this.getClass() + "." + " After update: '" + this + "'");
            this.invalidate(e);
        }
    }

    protected void changedUpdateImpl(DocumentEvent e) {
        if (!this.isValid()) {
            return;
        }
        if (this.intervalStart() == this.intervalEnd()) {
            this.processIfOnePoint(e);
            return;
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        if (this.intervalEnd() < offset || !this.isGreedyToRight() && this.intervalEnd() == offset) {
            return;
        }
        if (this.intervalStart() > offset + oldLength || !this.isGreedyToLeft() && this.intervalStart() == offset + oldLength) {
            this.setIntervalStart(this.intervalStart() + newLength - oldLength);
            this.setIntervalEnd(this.intervalEnd() + newLength - oldLength);
            return;
        }
        if (this.intervalStart() <= offset && this.intervalEnd() >= offset + oldLength) {
            this.setIntervalEnd(this.intervalEnd() + newLength - oldLength);
            return;
        }
        if (this.intervalStart() >= offset && this.intervalStart() <= offset + oldLength && this.intervalEnd() > offset + oldLength) {
            this.setIntervalEnd(this.intervalEnd() + newLength - oldLength);
            this.setIntervalStart(offset + newLength);
            return;
        }
        if (this.intervalEnd() >= offset && this.intervalEnd() <= offset + oldLength && this.intervalStart() < offset) {
            this.setIntervalEnd(offset);
            return;
        }
        this.invalidate(e);
    }

    private void processIfOnePoint(DocumentEvent e) {
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int oldEnd = offset + oldLength;
        if (offset < this.intervalStart() && this.intervalStart() < oldEnd) {
            this.invalidate(e);
            return;
        }
        if (offset == this.intervalStart() && oldLength == 0 && this.isGreedyToRight()) {
            this.setIntervalEnd(this.intervalEnd() + e.getNewLength());
            return;
        }
        if (this.intervalStart() > oldEnd || this.intervalStart() == oldEnd && oldLength > 0) {
            this.setIntervalStart(this.intervalStart() + e.getNewLength() - oldLength);
            this.setIntervalEnd(this.intervalEnd() + e.getNewLength() - oldLength);
        }
    }

    @NonNls
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + this.getId();
    }

    public int setIntervalStart(int start) {
        return this.myNode.setIntervalStart(start);
    }

    public int setIntervalEnd(int end) {
        return this.myNode.setIntervalEnd(end);
    }

    @Override
    public boolean isValid() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isValid();
    }

    public boolean setValid(boolean value) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null || node.setValid(value);
    }

    public int intervalStart() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalStart();
    }

    public int intervalEnd() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalEnd();
    }
}

