/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.CommonBundle;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentWeakFactoryMap;
import com.intellij.util.containers.FactoryMap;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBundle {
    private Reference<ResourceBundle> myBundle;
    @NonNls
    private final String myPathToBundle;
    private static final FactoryMap<ClassLoader, ConcurrentHashMap<String, SoftReference<ResourceBundle>>> ourCache = new ConcurrentWeakFactoryMap<ClassLoader, ConcurrentHashMap<String, SoftReference<ResourceBundle>>>(){

        @Override
        protected ConcurrentHashMap<String, SoftReference<ResourceBundle>> create(ClassLoader key) {
            return new ConcurrentHashMap<String, SoftReference<ResourceBundle>>();
        }
    };

    protected AbstractBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/AbstractBundle", "<init>"));
        }
        this.myPathToBundle = pathToBundle;
    }

    public String getMessage(@NotNull String key, Object ... params) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/AbstractBundle", "getMessage"));
        }
        return CommonBundle.message(this.getBundle(), key, params);
    }

    private ResourceBundle getBundle() {
        ResourceBundle bundle = null;
        if (this.myBundle != null) {
            bundle = this.myBundle.get();
        }
        if (bundle == null) {
            bundle = AbstractBundle.getResourceBundle(this.myPathToBundle, this.getClass().getClassLoader());
            this.myBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public static ResourceBundle getResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader) {
        ResourceBundle result;
        if (pathToBundle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/AbstractBundle", "getResourceBundle"));
        }
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/AbstractBundle", "getResourceBundle"));
        }
        ConcurrentHashMap<String, SoftReference<ResourceBundle>> map = ourCache.get(loader);
        SoftReference<ResourceBundle> reference = map.get(pathToBundle);
        ResourceBundle resourceBundle = result = reference == null ? null : reference.get();
        if (result == null) {
            result = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
            map.put(pathToBundle, new SoftReference<ResourceBundle>(result));
        }
        return result;
    }
}

