/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TemporaryConstVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    @NotNull
    public static JsPropertyInitializer translateFunctionAsEcma5PropertyDescriptor(@NotNull JsFunction function, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (JsDescriptorUtils.isExtension(descriptor)) {
            JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateExtensionFunctionAsEcma5DataDescriptor(function, descriptor, context);
            if (jsPropertyInitializer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
            }
            return jsPropertyInitializer;
        }
        JsStringLiteral getOrSet = context.program().getStringLiteral(descriptor instanceof PropertyGetterDescriptor ? "get" : "set");
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(getOrSet, function);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public static JsFunction simpleReturnFunction(@NotNull JsScope functionScope, @NotNull JsExpression returnExpression) {
        if (functionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "org/jetbrains/k2js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        if (returnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        JsFunction jsFunction = new JsFunction(functionScope, new JsBlock((JsStatement)new JsReturn(returnExpression)));
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        return jsFunction;
    }

    @NotNull
    private static JsPropertyInitializer translateExtensionFunctionAsEcma5DataDescriptor(@NotNull JsFunction function, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        JsObjectLiteral meta = JsAstUtils.createDataDescriptor(function, descriptor.getModality().isOverridable(), false);
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(context.getNameForDescriptor(descriptor).makeRef(), meta);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public static JsExpression translateExclForBinaryEqualLikeExpr(@NotNull JsBinaryOperation baseBinaryExpression) {
        if (baseBinaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBinaryExpression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExclForBinaryEqualLikeExpr"));
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(TranslationUtils.notOperator(baseBinaryExpression.getOperator()), baseBinaryExpression.getArg1(), baseBinaryExpression.getArg2());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExclForBinaryEqualLikeExpr"));
        }
        return jsBinaryOperation;
    }

    public static boolean isEqualLikeOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isEqualLikeOperator"));
        }
        return TranslationUtils.notOperator(operator) != null;
    }

    @Nullable
    private static JsBinaryOperator notOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notOperator"));
        }
        switch (operator) {
            case REF_EQ: {
                return JsBinaryOperator.REF_NEQ;
            }
            case REF_NEQ: {
                return JsBinaryOperator.REF_EQ;
            }
            case EQ: {
                return JsBinaryOperator.NEQ;
            }
            case NEQ: {
                return JsBinaryOperator.EQ;
            }
        }
        return null;
    }

    @NotNull
    public static JsBinaryOperation isNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, false);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isNullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation isNotNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isNotNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, true);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isNotNullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation nullCheck(@NotNull JsExpression expressionToCheck, boolean isNegated) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/k2js/translate/utils/TranslationUtils", "nullCheck"));
        }
        JsBinaryOperator operator = isNegated ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, expressionToCheck, JsLiteral.NULL);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "nullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsConditional notNullConditional(@NotNull JsExpression expression, @NotNull JsExpression elseExpression, @NotNull TranslationContext context) {
        JsExpression thenExpression;
        JsBinaryOperation testExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (elseExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elseExpression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (TranslationUtils.isCacheNeeded(expression)) {
            TemporaryConstVariable tempVar = context.getOrDeclareTemporaryConstVariable(expression);
            testExpression = TranslationUtils.isNotNullCheck(tempVar.value());
            thenExpression = tempVar.value();
        } else {
            testExpression = TranslationUtils.isNotNullCheck(expression);
            thenExpression = expression;
        }
        JsConditional jsConditional = new JsConditional(testExpression, thenExpression, elseExpression);
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        return jsConditional;
    }

    @NotNull
    public static String getMangledName(@NotNull PropertyDescriptor descriptor, @NotNull String suggestedName) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getMangledName"));
        }
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getMangledName"));
        }
        int absHashCode = Math.abs(DescriptorUtils.getFqName(descriptor).asString().hashCode());
        String string = suggestedName + "_" + Integer.toString(absHashCode, 36) + "$";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "getMangledName"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef backingFieldReference(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        JsName backingFieldName = context.getNameForDescriptor(descriptor);
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor)) {
            String backingFieldMangledName = descriptor.getVisibility() != Visibilities.PRIVATE ? TranslationUtils.getMangledName(descriptor, Namer.getKotlinBackingFieldName(backingFieldName.getIdent())) : Namer.getKotlinBackingFieldName(backingFieldName.getIdent());
            backingFieldName = context.declarePropertyOrPropertyAccessorName(descriptor, backingFieldMangledName, false);
        }
        JsNameRef jsNameRef = new JsNameRef(backingFieldName, (JsExpression)JsLiteral.THIS);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression assignmentToBackingField(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor, @NotNull JsExpression assignTo) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        if (assignTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignTo", "org/jetbrains/k2js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context, descriptor);
        JsExpression jsExpression = JsAstUtils.assignment(backingFieldReference, assignTo);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        return jsExpression;
    }

    @Nullable
    public static JsExpression translateInitializerForProperty(@NotNull JetProperty declaration, @NotNull TranslationContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateInitializerForProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateInitializerForProperty"));
        }
        JsExpression jsInitExpression = null;
        JetExpression initializer = declaration.getInitializer();
        if (initializer != null) {
            jsInitExpression = Translation.translateAsExpression(initializer, context);
        }
        return jsInitExpression;
    }

    @NotNull
    public static List<JsExpression> translateExpressionList(@NotNull TranslationContext context, @NotNull List<JetExpression> expressions) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExpressionList"));
        }
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExpressionList"));
        }
        ArrayList<JsExpression> result = new ArrayList<JsExpression>();
        for (JetExpression expression : expressions) {
            result.add(Translation.translateAsExpression(expression, context));
        }
        ArrayList<JsExpression> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateExpressionList"));
        }
        return arrayList;
    }

    @NotNull
    public static JsExpression translateBaseExpression(@NotNull TranslationContext context, @NotNull JetUnaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        JetExpression baseExpression = PsiUtils.getBaseExpression(expression);
        JsExpression jsExpression = Translation.translateAsExpression(baseExpression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateLeftExpression(@NotNull TranslationContext context, @NotNull JetBinaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        JetExpression left = expression.getLeft();
        assert (left != null) : "Binary expression should have a left expression: " + expression.getText();
        JsExpression jsExpression = Translation.translateAsExpression(left, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context, @NotNull JetBinaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        JetExpression rightExpression = expression.getRight();
        assert (rightExpression != null) : "Binary expression should have a right expression";
        JsExpression jsExpression = Translation.translateAsExpression(rightExpression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        return jsExpression;
    }

    public static boolean hasCorrespondingFunctionIntrinsic(@NotNull TranslationContext context, @NotNull JetOperationExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "hasCorrespondingFunctionIntrinsic"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "hasCorrespondingFunctionIntrinsic"));
        }
        FunctionDescriptor operationDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        if (operationDescriptor == null) {
            return true;
        }
        return context.intrinsics().getFunctionIntrinsics().getIntrinsic(operationDescriptor).exists();
    }

    @NotNull
    public static List<JsExpression> generateInvocationArguments(@NotNull JsExpression receiver, @NotNull List<JsExpression> arguments2) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/k2js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        if (arguments2.isEmpty()) {
            List<JsExpression> list2 = Collections.singletonList(receiver);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "generateInvocationArguments"));
            }
            return list2;
        }
        ArrayList<JsExpression> argumentList = new ArrayList<JsExpression>(1 + arguments2.size());
        argumentList.add(receiver);
        argumentList.addAll(arguments2);
        ArrayList<JsExpression> arrayList = argumentList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        return arrayList;
    }

    public static boolean isCacheNeeded(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "isCacheNeeded"));
        }
        return !(expression instanceof JsLiteral) && (!(expression instanceof JsNameRef) || ((JsNameRef)expression).getQualifier() != null);
    }

    @NotNull
    public static Pair<JsVars.JsVar, JsExpression> createTemporaryIfNeed(@NotNull JsExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "createTemporaryIfNeed"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "createTemporaryIfNeed"));
        }
        if (TranslationUtils.isCacheNeeded(expression)) {
            Pair<JsVars.JsVar, JsExpression> pair = context.dynamicContext().createTemporary(expression);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "createTemporaryIfNeed"));
            }
            return pair;
        }
        Pair<Object, JsExpression> pair = Pair.create(null, expression);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "createTemporaryIfNeed"));
        }
        return pair;
    }

    @NotNull
    public static JsConditional sure(@NotNull JsExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/utils/TranslationUtils", "sure"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/utils/TranslationUtils", "sure"));
        }
        JsInvocation throwNPE = new JsInvocation(context.namer().throwNPEFunctionRef());
        JsConditional ensureNotNull = TranslationUtils.notNullConditional(expression, throwNPE, context);
        JsExpression thenExpression = ensureNotNull.getThenExpression();
        if (thenExpression instanceof JsNameRef) {
            context.associateExpressionToLazyValue(ensureNotNull, new TemporaryConstVariable(((JsNameRef)thenExpression).getName(), ensureNotNull));
        }
        JsConditional jsConditional = ensureNotNull;
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/utils/TranslationUtils", "sure"));
        }
        return jsConditional;
    }
}

