/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.dart.compiler.backend.js.ast.HasArguments;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.KotlinFunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.PatternBuilder;
import org.jetbrains.k2js.translate.reference.CallTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class TopLevelFIF
extends CompositeFIF {
    @NotNull
    public static final KotlinFunctionIntrinsic EQUALS = new KotlinFunctionIntrinsic("equals");
    @NotNull
    public static final FunctionIntrinsic IDENTITY_EQUALS = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            assert (arguments2.size() == 1) : "Unexpected argument size for jet.identityEquals: " + arguments2.size();
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_EQ, receiver, arguments2.get(0));
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            return jsBinaryOperation;
        }
    };
    @NotNull
    private static final FunctionIntrinsic RETURN_RECEIVER_INTRINSIC = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            assert (receiver != null);
            JsExpression jsExpression = receiver;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            return jsExpression;
        }
    };
    private static final FunctionIntrinsic NATIVE_MAP_GET = new NativeMapGetSet(){

        @Override
        @NotNull
        protected String operation() {
            if ("get" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "operation"));
            }
            return "get";
        }

        @Override
        @Nullable
        protected ExpressionReceiver getExpressionReceiver(@NotNull ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "getExpressionReceiver"));
            }
            ReceiverValue result = resolvedCall.getThisObject();
            return result instanceof ExpressionReceiver ? (ExpressionReceiver)result : null;
        }

        @Override
        protected JsExpression asArrayAccess(@NotNull JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "asArrayAccess"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "asArrayAccess"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$3", "asArrayAccess"));
            }
            return ArrayFIF.GET_INTRINSIC.apply(receiver, arguments2, context);
        }
    };
    private static final FunctionIntrinsic NATIVE_MAP_SET = new NativeMapGetSet(){

        @Override
        @NotNull
        protected String operation() {
            if ("put" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "operation"));
            }
            return "put";
        }

        @Override
        @Nullable
        protected ExpressionReceiver getExpressionReceiver(@NotNull ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "getExpressionReceiver"));
            }
            ReceiverValue result = resolvedCall.getReceiverArgument();
            return result instanceof ExpressionReceiver ? (ExpressionReceiver)result : null;
        }

        @Override
        protected JsExpression asArrayAccess(@NotNull JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "asArrayAccess"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "asArrayAccess"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$4", "asArrayAccess"));
            }
            return ArrayFIF.SET_INTRINSIC.apply(receiver, arguments2, context);
        }
    };
    @NotNull
    public static final KotlinFunctionIntrinsic TO_STRING = new KotlinFunctionIntrinsic("toString");
    @NotNull
    public static final FunctionIntrinsicFactory INSTANCE = new TopLevelFIF();

    private TopLevelFIF() {
        this.add(PatternBuilder.pattern("jet", "toString").receiverExists(), TO_STRING);
        this.add(PatternBuilder.pattern("jet", "equals").receiverExists(), EQUALS);
        this.add(PatternBuilder.pattern("jet", "identityEquals").receiverExists(), IDENTITY_EQUALS);
        this.add(PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS, "equals"), EQUALS);
        this.add(PatternBuilder.pattern("String|Boolean|Char|Number.equals"), EQUALS);
        this.add(PatternBuilder.pattern("jet", "arrayOfNulls"), new KotlinFunctionIntrinsic("nullArray"));
        this.add(PatternBuilder.pattern("jet", "iterator").receiverExists(), RETURN_RECEIVER_INTRINSIC);
        this.add(new DescriptorPredicate(){

            @Override
            public boolean apply(@NotNull FunctionDescriptor descriptor) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$5", "apply"));
                }
                if (!descriptor.getName().asString().equals("invoke")) {
                    return false;
                }
                int parameterCount = descriptor.getValueParameters().size();
                DeclarationDescriptor fun = descriptor.getContainingDeclaration();
                return fun == (descriptor.getReceiverParameter() == null ? KotlinBuiltIns.getInstance().getFunction(parameterCount) : KotlinBuiltIns.getInstance().getExtensionFunction(parameterCount));
            }
        }, new FunctionIntrinsic.CallParametersAwareFunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@NotNull CallTranslator callTranslator, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
                if (callTranslator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTranslator", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
                }
                if (arguments2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
                }
                JsExpression thisExpression = callTranslator.getCallParameters().getThisObject();
                JsExpression functionReference = callTranslator.getCallParameters().getFunctionReference();
                if (thisExpression == null) {
                    JsInvocation jsInvocation = new JsInvocation(functionReference, arguments2);
                    if (jsInvocation == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
                    }
                    return jsInvocation;
                }
                if (callTranslator.getResolvedCall().getReceiverArgument().exists()) {
                    JsExpression jsExpression = callTranslator.extensionFunctionCall(false);
                    if (jsExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
                    }
                    return jsExpression;
                }
                if (functionReference instanceof JsNameRef && ((JsNameRef)functionReference).getIdent().equals("invoke")) {
                    JsExpression jsExpression = callTranslator.explicitInvokeCall();
                    if (jsExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
                    }
                    return jsExpression;
                }
                JsInvocation jsInvocation = new JsInvocation((JsExpression)Namer.getFunctionCallRef(functionReference), TranslationUtils.generateInvocationArguments(thisExpression, arguments2));
                if (jsInvocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
                }
                return jsInvocation;
            }
        });
        this.add(PatternBuilder.pattern("jet", "Map", "get").checkOverridden(), NATIVE_MAP_GET);
        this.add(PatternBuilder.pattern("js", "set").receiverExists(), NATIVE_MAP_SET);
        this.add(PatternBuilder.pattern("java.util", "HashMap", "<init>"), new MapSelectImplementationIntrinsic(false));
        this.add(PatternBuilder.pattern("java.util", "HashSet", "<init>"), new MapSelectImplementationIntrinsic(true));
        this.add(PatternBuilder.pattern("js", "Json", "get"), ArrayFIF.GET_INTRINSIC);
        this.add(PatternBuilder.pattern("js", "Json", "set"), ArrayFIF.SET_INTRINSIC);
    }

    private static class MapSelectImplementationIntrinsic
    extends FunctionIntrinsic.CallParametersAwareFunctionIntrinsic {
        private final boolean isSet;

        private MapSelectImplementationIntrinsic(boolean isSet) {
            this.isSet = isSet;
        }

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallTranslator callTranslator, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callTranslator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTranslator", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            JetType keyType = callTranslator.getResolvedCall().getTypeArguments().values().iterator().next();
            Name keyTypeName = JsDescriptorUtils.getNameIfStandardType(keyType);
            String collectionClassName = keyTypeName != null && (NamePredicate.PRIMITIVE_NUMBERS.apply(keyTypeName) || keyTypeName.asString().equals("String") || PrimitiveType.BOOLEAN.getTypeName().equals(keyTypeName)) ? (this.isSet ? "PrimitiveHashSet" : "PrimitiveHashMap") : (this.isSet ? "ComplexHashSet" : "ComplexHashMap");
            HasArguments hasArguments = callTranslator.createConstructorCallExpression(context.namer().kotlin(collectionClassName));
            if (hasArguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$MapSelectImplementationIntrinsic", "apply"));
            }
            return hasArguments;
        }
    }

    private static abstract class NativeMapGetSet
    extends FunctionIntrinsic.CallParametersAwareFunctionIntrinsic {
        private NativeMapGetSet() {
        }

        @NotNull
        protected abstract String operation();

        @Nullable
        protected abstract ExpressionReceiver getExpressionReceiver(@NotNull ResolvedCall<?> var1);

        protected abstract JsExpression asArrayAccess(@NotNull JsExpression var1, @NotNull List<JsExpression> var2, @NotNull TranslationContext var3);

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallTranslator callTranslator, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callTranslator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTranslator", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            ExpressionReceiver expressionReceiver = this.getExpressionReceiver(callTranslator.getResolvedCall());
            JsExpression thisOrReceiver = callTranslator.getCallParameters().getThisOrReceiverOrNull();
            assert (thisOrReceiver != null);
            if (expressionReceiver != null) {
                Object candidate;
                JetExpression expression = expressionReceiver.getExpression();
                JetReferenceExpression referenceExpression = null;
                if (expression instanceof JetReferenceExpression) {
                    referenceExpression = (JetReferenceExpression)expression;
                } else if (expression instanceof JetQualifiedExpression && (candidate = ((JetQualifiedExpression)expression).getReceiverExpression()) instanceof JetReferenceExpression) {
                    referenceExpression = (JetReferenceExpression)candidate;
                }
                if (referenceExpression != null && (candidate = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), referenceExpression)) instanceof PropertyDescriptor && AnnotationsUtils.isNativeObject((DeclarationDescriptor)candidate)) {
                    JsExpression jsExpression = this.asArrayAccess(thisOrReceiver, arguments2, context);
                    if (jsExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
                    }
                    return jsExpression;
                }
            }
            JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef(this.operation(), thisOrReceiver), arguments2);
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/TopLevelFIF$NativeMapGetSet", "apply"));
            }
            return jsInvocation;
        }
    }
}

