/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.k2js.translate.LabelGenerator;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.DefineInvocation;
import org.jetbrains.k2js.translate.declaration.FileDeclarationVisitor;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;

final class NamespaceTranslator
extends AbstractTranslator {
    @NotNull
    private final PackageFragmentDescriptor descriptor;
    private final FileDeclarationVisitor visitor;
    private final NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>> definitionPlace;

    NamespaceTranslator(final @NotNull PackageFragmentDescriptor descriptor, final @NotNull Map<FqName, DefineInvocation> packageFqNameToDefineInvocation, @NotNull TranslationContext context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "<init>"));
        }
        if (packageFqNameToDefineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqNameToDefineInvocation", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "<init>"));
        }
        super(context.newDeclaration(descriptor));
        this.descriptor = descriptor;
        this.visitor = new FileDeclarationVisitor(this.context());
        this.definitionPlace = new NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>>(){

            @Override
            @NotNull
            public Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> compute() {
                DefineInvocation defineInvocation = (DefineInvocation)packageFqNameToDefineInvocation.get(descriptor.getFqName());
                if (defineInvocation == null) {
                    defineInvocation = NamespaceTranslator.this.createDefinitionPlace(null, packageFqNameToDefineInvocation);
                }
                Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> trinity = LiteralFunctionTranslator.createPlace(defineInvocation.getMembers(), NamespaceTranslator.this.context().getQualifiedReference(descriptor.getFqName()));
                if (trinity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator$1", "compute"));
                }
                return trinity;
            }
        };
    }

    public void translate(JetFile file) {
        this.context().literalFunctionTranslator().setDefinitionPlace(this.definitionPlace);
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (AnnotationsUtils.isPredefinedObject(BindingUtils.getDescriptorForElement(this.bindingContext(), declaration))) continue;
            declaration.accept(this.visitor, this.context());
        }
        this.context().literalFunctionTranslator().setDefinitionPlace(null);
    }

    private DefineInvocation createDefinitionPlace(@Nullable JsExpression initializer, Map<FqName, DefineInvocation> packageFqNameToDefineInvocation) {
        FqName fqName = this.descriptor.getFqName();
        DefineInvocation place = DefineInvocation.createDefineInvocation(fqName, initializer, new JsObjectLiteral(this.visitor.getResult(), true), this.context());
        packageFqNameToDefineInvocation.put(fqName, place);
        this.addToParent(fqName.parent(), this.getEntry(fqName, place), packageFqNameToDefineInvocation);
        return place;
    }

    public void add(@NotNull Map<FqName, DefineInvocation> packageFqNameToDefineInvocation) {
        if (packageFqNameToDefineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqNameToDefineInvocation", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "add"));
        }
        JsFunction initializer = this.visitor.computeInitializer();
        DefineInvocation defineInvocation = packageFqNameToDefineInvocation.get(this.descriptor.getFqName());
        if (defineInvocation == null) {
            if (initializer != null || !this.visitor.getResult().isEmpty()) {
                this.createDefinitionPlace(initializer, packageFqNameToDefineInvocation);
            }
        } else {
            List<JsPropertyInitializer> listFromPlace;
            if (initializer != null) {
                assert (defineInvocation.getInitializer() == JsLiteral.NULL);
                defineInvocation.setInitializer(initializer);
            }
            if ((listFromPlace = defineInvocation.getMembers()) != this.visitor.getResult()) {
                listFromPlace.addAll(this.visitor.getResult());
            }
        }
    }

    private JsPropertyInitializer getEntry(@NotNull FqName fqName, DefineInvocation defineInvocation) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "getEntry"));
        }
        return new JsPropertyInitializer(this.context().getNameForPackage(fqName).makeRef(), new JsInvocation(this.context().namer().packageDefinitionMethodReference(), defineInvocation.asList()));
    }

    private static boolean addEntryIfParentExists(FqName parentFqName, JsPropertyInitializer entry, Map<FqName, DefineInvocation> packageFqNameToDeclarationPlace) {
        DefineInvocation parentDefineInvocation = packageFqNameToDeclarationPlace.get(parentFqName);
        if (parentDefineInvocation != null) {
            parentDefineInvocation.getMembers().add(entry);
            return true;
        }
        return false;
    }

    private void addToParent(@NotNull FqName parentFqName, JsPropertyInitializer entry, Map<FqName, DefineInvocation> packageFqNameToDefineInvocation) {
        if (parentFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFqName", "org/jetbrains/k2js/translate/declaration/NamespaceTranslator", "addToParent"));
        }
        while (!NamespaceTranslator.addEntryIfParentExists(parentFqName, entry, packageFqNameToDefineInvocation)) {
            JsObjectLiteral members = new JsObjectLiteral(new SmartList<JsPropertyInitializer>(entry), true);
            DefineInvocation defineInvocation = DefineInvocation.createDefineInvocation(parentFqName, null, members, this.context());
            entry = this.getEntry(parentFqName, defineInvocation);
            packageFqNameToDefineInvocation.put(parentFqName, defineInvocation);
            parentFqName = parentFqName.parent();
        }
    }
}

