/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.types.lang.InlineStrategy;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class InlineUtil {
    public static boolean DEFAULT_INLINE_FLAG = false;
    public static boolean DEFAULT_INLINE_FLAG_FOR_TEST = true;
    public static boolean DEFAULT_INLINE_FLAG_FOR_TOOLWINDOW = false;
    public static boolean DEFAULT_INLINE_FLAG_FOR_STUB = false;

    @NotNull
    public static InlineStrategy getInlineType(@NotNull Annotated annotated) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getInlineType"));
        }
        InlineStrategy inlineStrategy = InlineUtil.getInlineType(annotated.getAnnotations());
        if (inlineStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getInlineType"));
        }
        return inlineStrategy;
    }

    public static boolean hasNoinlineAnnotation(@NotNull CallableDescriptor valueParameterDescriptor) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/lang/types/lang/InlineUtil", "hasNoinlineAnnotation"));
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        return KotlinBuiltIns.containsAnnotation(valueParameterDescriptor, builtIns.getNoinlineClassAnnotation());
    }

    @NotNull
    public static InlineStrategy getInlineType(@Nullable List<AnnotationDescriptor> annotations) {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        ClassDescriptor annotationClass = builtIns.getInlineClassAnnotation();
        AnnotationDescriptor annotation = InlineUtil.getAnnotation(annotations, annotationClass);
        if (annotation != null) {
            ValueParameterDescriptor parameterDescriptor = annotationClass.getConstructors().iterator().next().getValueParameters().get(0);
            CompileTimeConstant<?> argument = annotation.getValueArgument(parameterDescriptor);
            if (argument == null) {
                InlineStrategy inlineStrategy = InlineStrategy.AS_FUNCTION;
                if (inlineStrategy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getInlineType"));
                }
                return inlineStrategy;
            }
            assert (argument instanceof EnumValue) : "Inline annotation parameter should be inline entry but was: " + argument + "!";
            ClassDescriptor value = (ClassDescriptor)((EnumValue)argument).getValue();
            String name = value.getName().asString();
            InlineStrategy inlineStrategy = name.equals(InlineStrategy.IN_PLACE.name()) ? InlineStrategy.IN_PLACE : InlineStrategy.AS_FUNCTION;
            if (inlineStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getInlineType"));
            }
            return inlineStrategy;
        }
        InlineStrategy inlineStrategy = InlineStrategy.NOT_INLINE;
        if (inlineStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getInlineType"));
        }
        return inlineStrategy;
    }

    @Nullable
    private static AnnotationDescriptor getAnnotation(@Nullable List<AnnotationDescriptor> annotations, @NotNull ClassDescriptor annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "org/jetbrains/jet/lang/types/lang/InlineUtil", "getAnnotation"));
        }
        if (annotations != null) {
            for (AnnotationDescriptor annotation : annotations) {
                if (!annotationClass.equals(annotation.getType().getConstructor().getDeclarationDescriptor())) continue;
                return annotation;
            }
        }
        return null;
    }
}

