/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.AbstractDescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.lang.BuiltInsSerializationUtil;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;

class BuiltinsPackageFragment
extends DeclarationDescriptorImpl
implements PackageFragmentDescriptor {
    private final DeserializedPackageMemberScope members;
    private final NameResolver nameResolver;
    private final ModuleDescriptor module;
    private final PackageFragmentProvider packageFragmentProvider;

    public BuiltinsPackageFragment(@NotNull StorageManager storageManager, @NotNull ModuleDescriptor module) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "<init>"));
        }
        super(Collections.<AnnotationDescriptor>emptyList(), KotlinBuiltIns.BUILT_INS_PACKAGE_NAME);
        this.module = module;
        this.nameResolver = NameSerializationUtil.deserializeNameResolver(BuiltinsPackageFragment.getStream(BuiltInsSerializationUtil.getNameTableFilePath(this)));
        this.packageFragmentProvider = new BuiltinsPackageFragmentProvider();
        this.members = new DeserializedPackageMemberScope(storageManager, this, AnnotationDeserializer.UNSUPPORTED, new BuiltInsDescriptorFinder(storageManager), this.loadPackage(), this.nameResolver);
    }

    @NotNull
    private ProtoBuf.Package loadPackage() {
        ProtoBuf.Package package_;
        String packageFilePath = BuiltInsSerializationUtil.getPackageFilePath(this);
        InputStream stream = BuiltinsPackageFragment.getStream(packageFilePath);
        try {
            package_ = ProtoBuf.Package.parseFrom(stream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (package_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "loadPackage"));
        }
        return package_;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        DeserializedPackageMemberScope deserializedPackageMemberScope = this.members;
        if (deserializedPackageMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getMemberScope"));
        }
        return deserializedPackageMemberScope;
    }

    @Override
    @NotNull
    public PackageFragmentProvider getProvider() {
        PackageFragmentProvider packageFragmentProvider = this.packageFragmentProvider;
        if (packageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getProvider"));
        }
        return packageFragmentProvider;
    }

    @Override
    @NotNull
    public ModuleDescriptor getContainingDeclaration() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getContainingDeclaration"));
        }
        return moduleDescriptor;
    }

    @Override
    @Nullable
    public DeclarationDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "substitute"));
        }
        return this;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitPackageFragmentDescriptor(this, data2);
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getFqName"));
        }
        return fqName;
    }

    @NotNull
    private static InputStream getStream(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getStream"));
        }
        InputStream stream = BuiltinsPackageFragment.getStreamNullable(path);
        if (stream == null) {
            throw new IllegalStateException("Resource not found in classpath: " + path);
        }
        InputStream inputStream = stream;
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getStream"));
        }
        return inputStream;
    }

    @Nullable
    private static InputStream getStreamNullable(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment", "getStreamNullable"));
        }
        return KotlinBuiltIns.class.getClassLoader().getResourceAsStream(path);
    }

    private class BuiltInsDescriptorFinder
    extends AbstractDescriptorFinder {
        private final NotNullLazyValue<Collection<Name>> classNames;

        public BuiltInsDescriptorFinder(@NotNull StorageManager storageManager) {
            if (storageManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltInsDescriptorFinder", "<init>"));
            }
            super(storageManager, AnnotationDeserializer.UNSUPPORTED, BuiltinsPackageFragment.this.packageFragmentProvider);
            this.classNames = storageManager.createLazyValue(new Function0<Collection<Name>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                @NotNull
                public Collection<Name> invoke() {
                    InputStream in = BuiltinsPackageFragment.getStream(BuiltInsSerializationUtil.getClassNamesFilePath(BuiltinsPackageFragment.this));
                    DataInputStream data2 = new DataInputStream(in);
                    int size = data2.readInt();
                    ArrayList<Name> result = new ArrayList<Name>(size);
                    for (int i = 0; i < size; ++i) {
                        result.add(BuiltinsPackageFragment.this.nameResolver.getName(data2.readInt()));
                    }
                    ArrayList<Name> arrayList = result;
                    data2.close();
                    ArrayList<Name> arrayList2 = arrayList;
                    if (arrayList2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltInsDescriptorFinder$1", "invoke"));
                    }
                    return arrayList2;
                    {
                        catch (Throwable throwable) {
                            try {
                                data2.close();
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                    }
                }
            });
        }

        @Override
        @Nullable
        protected ClassData getClassData(@NotNull ClassId classId) {
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltInsDescriptorFinder", "getClassData"));
            }
            InputStream stream = BuiltinsPackageFragment.getStreamNullable(BuiltInsSerializationUtil.getClassMetadataPath(classId));
            if (stream == null) {
                return null;
            }
            try {
                ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(stream);
                Name expectedShortName = classId.getRelativeClassName().shortName();
                Name actualShortName = BuiltinsPackageFragment.this.nameResolver.getClassId(classProto.getFqName()).getRelativeClassName().shortName();
                if (!actualShortName.isSpecial() && !actualShortName.equals(expectedShortName)) {
                    return null;
                }
                return new ClassData(BuiltinsPackageFragment.this.nameResolver, classProto);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        @NotNull
        public Collection<Name> getClassNames(@NotNull FqName packageName) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltInsDescriptorFinder", "getClassNames"));
            }
            Collection<Name> collection = packageName.equals(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME) ? (Collection)this.classNames.invoke() : Collections.emptyList();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltInsDescriptorFinder", "getClassNames"));
            }
            return collection;
        }
    }

    private class BuiltinsPackageFragmentProvider
    implements PackageFragmentProvider {
        private final PackageFragmentDescriptor rootPackage;

        private BuiltinsPackageFragmentProvider() {
            this.rootPackage = new MutablePackageFragmentDescriptor(this, BuiltinsPackageFragment.this.module, FqName.ROOT);
        }

        @Override
        @NotNull
        public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName) {
            if (fqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getPackageFragments"));
            }
            if (fqName.isRoot()) {
                List<PackageFragmentDescriptor> list2 = Collections.singletonList(this.rootPackage);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getPackageFragments"));
                }
                return list2;
            }
            if (KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.equals(fqName)) {
                List<PackageFragmentDescriptor> list3 = Collections.singletonList(BuiltinsPackageFragment.this);
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getPackageFragments"));
                }
                return list3;
            }
            List<PackageFragmentDescriptor> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getPackageFragments"));
            }
            return list4;
        }

        @Override
        @NotNull
        public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName) {
            if (fqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getSubPackagesOf"));
            }
            if (fqName.isRoot()) {
                Set<FqName> set = Collections.singleton(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getSubPackagesOf"));
                }
                return set;
            }
            List<FqName> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsPackageFragment$BuiltinsPackageFragmentProvider", "getSubPackagesOf"));
            }
            return list2;
        }
    }
}

