/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.AbstractJetType;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.IntersectionTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.utils.DFS;

public class TypeUtils {
    public static final JetType DONT_CARE = ErrorUtils.createErrorTypeWithCustomDebugName("DONT_CARE");
    public static final JetType CANT_INFER_TYPE_PARAMETER = ErrorUtils.createErrorTypeWithCustomDebugName("CANT_INFER_TYPE_PARAMETER");
    public static final JetType PLACEHOLDER_FUNCTION_TYPE = ErrorUtils.createErrorTypeWithCustomDebugName("PLACEHOLDER_FUNCTION_TYPE");
    public static final JetType CANT_INFER_LAMBDA_PARAM_TYPE = ErrorUtils.createErrorType("Cannot be inferred");
    public static final JetType NO_EXPECTED_TYPE = new SpecialType("NO_EXPECTED_TYPE");
    public static final JetType UNIT_EXPECTED_TYPE = new SpecialType("UNIT_EXPECTED_TYPE");

    public static boolean noExpectedType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "noExpectedType"));
        }
        return type == NO_EXPECTED_TYPE || type == UNIT_EXPECTED_TYPE;
    }

    @NotNull
    public static JetType makeNullable(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "makeNullable"));
        }
        JetType jetType = TypeUtils.makeNullableAsSpecified(type, true);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "makeNullable"));
        }
        return jetType;
    }

    @NotNull
    public static JetType makeNotNullable(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "makeNotNullable"));
        }
        JetType jetType = TypeUtils.makeNullableAsSpecified(type, false);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "makeNotNullable"));
        }
        return jetType;
    }

    @NotNull
    public static JetType makeNullableAsSpecified(@NotNull JetType type, boolean nullable) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "makeNullableAsSpecified"));
        }
        if (type.isNullable() == nullable) {
            JetType jetType = type;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "makeNullableAsSpecified"));
            }
            return jetType;
        }
        if (type instanceof AbstractTypeWithKnownNullability) {
            JetType jetType = TypeUtils.makeNullableAsSpecified(((AbstractTypeWithKnownNullability)type).delegate, nullable);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "makeNullableAsSpecified"));
            }
            return jetType;
        }
        AbstractTypeWithKnownNullability abstractTypeWithKnownNullability = nullable ? new NullableType(type) : new NotNullType(type);
        if (abstractTypeWithKnownNullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "makeNullableAsSpecified"));
        }
        return abstractTypeWithKnownNullability;
    }

    public static boolean isIntersectionEmpty(@NotNull JetType typeA, @NotNull JetType typeB) {
        if (typeA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeA", "org/jetbrains/jet/lang/types/TypeUtils", "isIntersectionEmpty"));
        }
        if (typeB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeB", "org/jetbrains/jet/lang/types/TypeUtils", "isIntersectionEmpty"));
        }
        return TypeUtils.intersect(JetTypeChecker.INSTANCE, Sets.newLinkedHashSet(Lists.newArrayList(typeA, typeB))) == null;
    }

    @Nullable
    public static JetType intersect(@NotNull JetTypeChecker typeChecker, @NotNull Set<JetType> types) {
        if (typeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeChecker", "org/jetbrains/jet/lang/types/TypeUtils", "intersect"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/TypeUtils", "intersect"));
        }
        if (types.isEmpty()) {
            return KotlinBuiltIns.getInstance().getNullableAnyType();
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        boolean allNullable = true;
        boolean nothingTypePresent = false;
        ArrayList<JetType> nullabilityStripped = Lists.newArrayList();
        for (JetType type : types) {
            nothingTypePresent |= KotlinBuiltIns.getInstance().isNothingOrNullableNothing(type);
            allNullable &= type.isNullable();
            nullabilityStripped.add(TypeUtils.makeNotNullable(type));
        }
        if (nothingTypePresent) {
            return allNullable ? KotlinBuiltIns.getInstance().getNullableNothingType() : KotlinBuiltIns.getInstance().getNothingType();
        }
        ArrayList<JetType> resultingTypes = Lists.newArrayList();
        block1: for (JetType type : nullabilityStripped) {
            if (!TypeUtils.canHaveSubtypes(typeChecker, type)) {
                for (JetType other : nullabilityStripped) {
                    if (TypeUnifier.mayBeEqual(type, other) || typeChecker.isSubtypeOf(type, other) || typeChecker.isSubtypeOf(other, type)) continue;
                    return null;
                }
                return TypeUtils.makeNullableAsSpecified(type, allNullable);
            }
            for (JetType other : nullabilityStripped) {
                if (((Object)type).equals(other) || !typeChecker.isSubtypeOf(other, type)) continue;
                continue block1;
            }
            for (JetType other : resultingTypes) {
                if (!typeChecker.equalTypes(other, type)) continue;
                continue block1;
            }
            resultingTypes.add(type);
        }
        if (resultingTypes.size() == 1) {
            return TypeUtils.makeNullableAsSpecified((JetType)resultingTypes.get(0), allNullable);
        }
        List<AnnotationDescriptor> noAnnotations = Collections.emptyList();
        IntersectionTypeConstructor constructor = new IntersectionTypeConstructor(noAnnotations, resultingTypes);
        JetScope[] scopes = new JetScope[resultingTypes.size()];
        int i = 0;
        for (JetType type : resultingTypes) {
            scopes[i] = type.getMemberScope();
            ++i;
        }
        return new JetTypeImpl(noAnnotations, constructor, allNullable, Collections.emptyList(), new ChainedScope(null, scopes));
    }

    public static boolean canHaveSubtypes(JetTypeChecker typeChecker, JetType type) {
        if (type.isNullable()) {
            return true;
        }
        if (!type.getConstructor().isFinal()) {
            return true;
        }
        List<TypeParameterDescriptor> parameters = type.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type.getArguments();
        int parametersSize = parameters.size();
        block10: for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters.get(i);
            TypeProjection typeProjection = arguments2.get(i);
            Variance projectionKind = typeProjection.getProjectionKind();
            JetType argument = typeProjection.getType();
            switch (parameterDescriptor.getVariance()) {
                case INVARIANT: {
                    switch (projectionKind) {
                        case INVARIANT: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) && !TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                        case IN_VARIANCE: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor)) break;
                            return true;
                        }
                        case OUT_VARIANCE: {
                            if (!TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                    }
                    continue block10;
                }
                case IN_VARIANCE: {
                    if (!(projectionKind != Variance.OUT_VARIANCE ? TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) : TypeUtils.canHaveSubtypes(typeChecker, argument))) continue block10;
                    return true;
                }
                case OUT_VARIANCE: {
                    if (!(projectionKind != Variance.IN_VARIANCE ? TypeUtils.canHaveSubtypes(typeChecker, argument) : TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor))) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean lowerThanBound(JetTypeChecker typeChecker, JetType argument, TypeParameterDescriptor parameterDescriptor) {
        for (JetType bound : parameterDescriptor.getUpperBounds()) {
            if (!typeChecker.isSubtypeOf(argument, bound) || argument.getConstructor().equals(bound.getConstructor())) continue;
            return true;
        }
        return false;
    }

    public static JetType makeNullableIfNeeded(JetType type, boolean nullable) {
        if (nullable) {
            return TypeUtils.makeNullable(type);
        }
        return type;
    }

    @NotNull
    public static JetType makeUnsubstitutedType(ClassDescriptor classDescriptor, JetScope unsubstitutedMemberScope) {
        if (ErrorUtils.isError(classDescriptor)) {
            JetType jetType = ErrorUtils.createErrorType("Unsubstituted type for " + classDescriptor);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "makeUnsubstitutedType"));
            }
            return jetType;
        }
        TypeConstructor typeConstructor = classDescriptor.getTypeConstructor();
        List<TypeProjection> arguments2 = TypeUtils.getDefaultTypeProjections(typeConstructor.getParameters());
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), typeConstructor, false, arguments2, unsubstitutedMemberScope);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "makeUnsubstitutedType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public static List<TypeProjection> getDefaultTypeProjections(List<TypeParameterDescriptor> parameters) {
        ArrayList<TypeProjection> result = new ArrayList<TypeProjection>();
        for (TypeParameterDescriptor parameterDescriptor : parameters) {
            result.add(new TypeProjectionImpl(parameterDescriptor.getDefaultType()));
        }
        ArrayList<TypeProjection> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getDefaultTypeProjections"));
        }
        return arrayList;
    }

    @NotNull
    public static List<JetType> getDefaultTypes(List<TypeParameterDescriptor> parameters) {
        ArrayList<JetType> result = Lists.newArrayList();
        for (TypeParameterDescriptor parameterDescriptor : parameters) {
            result.add(parameterDescriptor.getDefaultType());
        }
        ArrayList<JetType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getDefaultTypes"));
        }
        return arrayList;
    }

    private static void collectImmediateSupertypes(@NotNull JetType type, @NotNull Collection<JetType> result) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "collectImmediateSupertypes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/types/TypeUtils", "collectImmediateSupertypes"));
        }
        TypeSubstitutor substitutor = TypeSubstitutor.create(type);
        for (JetType supertype : type.getConstructor().getSupertypes()) {
            result.add(substitutor.substitute(supertype, Variance.INVARIANT));
        }
    }

    @NotNull
    public static List<JetType> getImmediateSupertypes(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "getImmediateSupertypes"));
        }
        ArrayList<JetType> result = Lists.newArrayList();
        TypeUtils.collectImmediateSupertypes(type, result);
        ArrayList<JetType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getImmediateSupertypes"));
        }
        return arrayList;
    }

    private static void collectAllSupertypes(@NotNull JetType type, @NotNull Set<JetType> result) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "collectAllSupertypes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/types/TypeUtils", "collectAllSupertypes"));
        }
        List<JetType> immediateSupertypes = TypeUtils.getImmediateSupertypes(type);
        result.addAll(immediateSupertypes);
        for (JetType supertype : immediateSupertypes) {
            TypeUtils.collectAllSupertypes(supertype, result);
        }
    }

    @NotNull
    public static Set<JetType> getAllSupertypes(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "getAllSupertypes"));
        }
        LinkedHashSet<JetType> result = new LinkedHashSet<JetType>(15);
        TypeUtils.collectAllSupertypes(type, result);
        LinkedHashSet<JetType> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getAllSupertypes"));
        }
        return linkedHashSet;
    }

    public static boolean hasNullableLowerBound(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/jet/lang/types/TypeUtils", "hasNullableLowerBound"));
        }
        for (JetType bound : typeParameterDescriptor.getLowerBounds()) {
            if (!bound.isNullable()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNullableSuperType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "hasNullableSuperType"));
        }
        if (type.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        for (JetType supertype : TypeUtils.getImmediateSupertypes(type)) {
            if (supertype.isNullable()) {
                return true;
            }
            if (!TypeUtils.hasNullableSuperType(supertype)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalClasses(@NotNull JetType type1, @NotNull JetType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "org/jetbrains/jet/lang/types/TypeUtils", "equalClasses"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "org/jetbrains/jet/lang/types/TypeUtils", "equalClasses"));
        }
        ClassifierDescriptor declarationDescriptor1 = type1.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor1 == null) {
            return false;
        }
        ClassifierDescriptor declarationDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor2 == null) {
            return false;
        }
        return declarationDescriptor1.getOriginal().equals(declarationDescriptor2.getOriginal());
    }

    @Nullable
    public static ClassDescriptor getClassDescriptor(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "getClassDescriptor"));
        }
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)declarationDescriptor;
        }
        return null;
    }

    @NotNull
    public static JetType substituteParameters(@NotNull ClassDescriptor clazz, @NotNull List<JetType> typeArguments) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/jet/lang/types/TypeUtils", "substituteParameters"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/jet/lang/types/TypeUtils", "substituteParameters"));
        }
        List<TypeProjection> projections = ContainerUtil.map(typeArguments, new com.intellij.util.Function<JetType, TypeProjection>(){

            @Override
            public TypeProjection fun(JetType type) {
                return new TypeProjectionImpl(type);
            }
        });
        JetType jetType = TypeUtils.substituteProjectionsForParameters(clazz, projections);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "substituteParameters"));
        }
        return jetType;
    }

    @NotNull
    public static JetType substituteProjectionsForParameters(@NotNull ClassDescriptor clazz, @NotNull List<TypeProjection> projections) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/jet/lang/types/TypeUtils", "substituteProjectionsForParameters"));
        }
        if (projections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projections", "org/jetbrains/jet/lang/types/TypeUtils", "substituteProjectionsForParameters"));
        }
        List<TypeParameterDescriptor> clazzTypeParameters = clazz.getTypeConstructor().getParameters();
        if (clazzTypeParameters.size() != projections.size()) {
            throw new IllegalArgumentException("type parameter counts do not match: " + clazz + ", " + projections);
        }
        HashMap<TypeConstructor, TypeProjection> substitutions = Maps.newHashMap();
        for (int i = 0; i < clazzTypeParameters.size(); ++i) {
            TypeConstructor typeConstructor = clazzTypeParameters.get(i).getTypeConstructor();
            substitutions.put(typeConstructor, projections.get(i));
        }
        JetType jetType = TypeSubstitutor.create(substitutions).substitute(clazz.getDefaultType(), Variance.INVARIANT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "substituteProjectionsForParameters"));
        }
        return jetType;
    }

    public static boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/types/TypeUtils", "equalTypes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/types/TypeUtils", "equalTypes"));
        }
        return JetTypeChecker.INSTANCE.isSubtypeOf(a, b) && JetTypeChecker.INSTANCE.isSubtypeOf(b, a);
    }

    public static boolean typeConstructorUsedInType(@NotNull TypeConstructor key, @NotNull JetType value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/jet/lang/types/TypeUtils", "typeConstructorUsedInType"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/types/TypeUtils", "typeConstructorUsedInType"));
        }
        if (value.getConstructor() == key) {
            return true;
        }
        for (TypeProjection projection : value.getArguments()) {
            if (!TypeUtils.typeConstructorUsedInType(key, projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOnTypeParameters(@NotNull JetType type, @NotNull Collection<TypeParameterDescriptor> typeParameters) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "dependsOnTypeParameters"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/types/TypeUtils", "dependsOnTypeParameters"));
        }
        return TypeUtils.dependsOnTypeConstructors(type, Collections2.transform(typeParameters, new Function<TypeParameterDescriptor, TypeConstructor>(){

            @Override
            public TypeConstructor apply(@Nullable TypeParameterDescriptor typeParameterDescriptor) {
                assert (typeParameterDescriptor != null);
                return typeParameterDescriptor.getTypeConstructor();
            }
        }));
    }

    public static boolean dependsOnTypeConstructors(@NotNull JetType type, @NotNull Collection<TypeConstructor> typeParameterConstructors) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "dependsOnTypeConstructors"));
        }
        if (typeParameterConstructors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterConstructors", "org/jetbrains/jet/lang/types/TypeUtils", "dependsOnTypeConstructors"));
        }
        if (typeParameterConstructors.contains(type.getConstructor())) {
            return true;
        }
        for (TypeProjection typeProjection : type.getArguments()) {
            if (!TypeUtils.dependsOnTypeConstructors(typeProjection.getType(), typeParameterConstructors)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOrContainsAsArgument(@Nullable JetType type, JetType ... possibleArgumentTypes) {
        if (possibleArgumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleArgumentTypes", "org/jetbrains/jet/lang/types/TypeUtils", "equalsOrContainsAsArgument"));
        }
        return TypeUtils.equalsOrContainsAsArgument(type, Sets.newHashSet(possibleArgumentTypes));
    }

    private static boolean equalsOrContainsAsArgument(@Nullable JetType type, @NotNull Set<JetType> possibleArgumentTypes) {
        if (possibleArgumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleArgumentTypes", "org/jetbrains/jet/lang/types/TypeUtils", "equalsOrContainsAsArgument"));
        }
        if (type == null) {
            return false;
        }
        if (possibleArgumentTypes.contains(type)) {
            return true;
        }
        if (type instanceof NamespaceType) {
            return false;
        }
        for (TypeProjection projection : type.getArguments()) {
            if (!TypeUtils.equalsOrContainsAsArgument(projection.getType(), possibleArgumentTypes)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getTypeNameAndStarProjectionsString(@NotNull String name, int size) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/TypeUtils", "getTypeNameAndStarProjectionsString"));
        }
        StringBuilder builder = new StringBuilder(name);
        builder.append("<");
        for (int i = 0; i < size; ++i) {
            builder.append("*");
            if (i == size - 1) break;
            builder.append(", ");
        }
        builder.append(">");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getTypeNameAndStarProjectionsString"));
        }
        return string;
    }

    @Nullable
    public static JetType commonSupertypeForNumberTypes(@NotNull Collection<JetType> numberLowerBounds) {
        if (numberLowerBounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberLowerBounds", "org/jetbrains/jet/lang/types/TypeUtils", "commonSupertypeForNumberTypes"));
        }
        if (numberLowerBounds.isEmpty()) {
            return null;
        }
        assert (!numberLowerBounds.isEmpty());
        Set<JetType> intersectionOfSupertypes = TypeUtils.getIntersectionOfSupertypes(numberLowerBounds);
        JetType primitiveNumberType = TypeUtils.getDefaultPrimitiveNumberType(intersectionOfSupertypes);
        if (primitiveNumberType != null) {
            return primitiveNumberType;
        }
        return CommonSupertypes.commonSupertype(numberLowerBounds);
    }

    @NotNull
    private static Set<JetType> getIntersectionOfSupertypes(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/TypeUtils", "getIntersectionOfSupertypes"));
        }
        AbstractSet upperBounds = Sets.newHashSet();
        for (JetType type : types) {
            HashSet<JetType> supertypes = Sets.newHashSet(type.getConstructor().getSupertypes());
            if (upperBounds.isEmpty()) {
                upperBounds.addAll(supertypes);
                continue;
            }
            upperBounds = Sets.intersection(upperBounds, supertypes);
        }
        HashSet<JetType> hashSet = upperBounds;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getIntersectionOfSupertypes"));
        }
        return hashSet;
    }

    @NotNull
    public static JetType getDefaultPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor) {
        if (numberValueTypeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberValueTypeConstructor", "org/jetbrains/jet/lang/types/TypeUtils", "getDefaultPrimitiveNumberType"));
        }
        JetType type = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor.getSupertypes());
        assert (type != null) : "Strange number value type constructor: " + numberValueTypeConstructor + ". " + "Super types doesn't contain double, int or long: " + numberValueTypeConstructor.getSupertypes();
        JetType jetType = type;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getDefaultPrimitiveNumberType"));
        }
        return jetType;
    }

    @Nullable
    private static JetType getDefaultPrimitiveNumberType(@NotNull Collection<JetType> supertypes) {
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/types/TypeUtils", "getDefaultPrimitiveNumberType"));
        }
        JetType doubleType = KotlinBuiltIns.getInstance().getDoubleType();
        if (supertypes.contains(doubleType)) {
            return doubleType;
        }
        JetType intType = KotlinBuiltIns.getInstance().getIntType();
        if (supertypes.contains(intType)) {
            return intType;
        }
        JetType longType = KotlinBuiltIns.getInstance().getLongType();
        if (supertypes.contains(longType)) {
            return longType;
        }
        return null;
    }

    @NotNull
    public static JetType getPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor, @NotNull JetType expectedType) {
        if (numberValueTypeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberValueTypeConstructor", "org/jetbrains/jet/lang/types/TypeUtils", "getPrimitiveNumberType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/types/TypeUtils", "getPrimitiveNumberType"));
        }
        if (TypeUtils.noExpectedType(expectedType) || expectedType.isError()) {
            JetType jetType = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getPrimitiveNumberType"));
            }
            return jetType;
        }
        for (JetType primitiveNumberType : numberValueTypeConstructor.getSupertypes()) {
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(primitiveNumberType, expectedType)) continue;
            JetType jetType = primitiveNumberType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getPrimitiveNumberType"));
            }
            return jetType;
        }
        JetType jetType = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "getPrimitiveNumberType"));
        }
        return jetType;
    }

    @NotNull
    public static Pair<Collection<JetType>, Collection<JetType>> filterNumberTypes(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/types/TypeUtils", "filterNumberTypes"));
        }
        LinkedHashSet<JetType> numberTypes = Sets.newLinkedHashSet();
        LinkedHashSet<JetType> otherTypes = Sets.newLinkedHashSet();
        for (JetType type : types) {
            if (type.getConstructor() instanceof IntegerValueTypeConstructor) {
                numberTypes.add(type);
                continue;
            }
            otherTypes.add(type);
        }
        Pair<Collection<JetType>, Collection<JetType>> pair = Pair.create(otherTypes, numberTypes);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils", "filterNumberTypes"));
        }
        return pair;
    }

    public static List<TypeConstructor> topologicallySortSuperclassesAndRecordAllInstances(@NotNull JetType type, final @NotNull Map<TypeConstructor, Set<JetType>> constructorToAllInstances, final @NotNull Set<TypeConstructor> visited) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        if (constructorToAllInstances == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorToAllInstances", "org/jetbrains/jet/lang/types/TypeUtils", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/jet/lang/types/TypeUtils", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        return DFS.dfs(Collections.singletonList(type), new DFS.Neighbors<JetType>(){

            @Override
            @NotNull
            public Iterable<JetType> getNeighbors(JetType current) {
                TypeSubstitutor substitutor = TypeSubstitutor.create(current);
                ArrayList<JetType> result = Lists.newArrayList();
                for (JetType supertype : current.getConstructor().getSupertypes()) {
                    if (visited.contains(supertype.getConstructor())) continue;
                    result.add(substitutor.safeSubstitute(supertype, Variance.INVARIANT));
                }
                ArrayList<JetType> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils$3", "getNeighbors"));
                }
                return arrayList;
            }
        }, new DFS.Visited<JetType>(){

            @Override
            public boolean checkAndMarkVisited(JetType current) {
                return visited.add(current.getConstructor());
            }
        }, new DFS.NodeHandlerWithListResult<JetType, TypeConstructor>(){

            @Override
            public void beforeChildren(JetType current) {
                TypeConstructor constructor = current.getConstructor();
                HashSet<JetType> instances = (HashSet<JetType>)constructorToAllInstances.get(constructor);
                if (instances == null) {
                    instances = new HashSet<JetType>();
                    constructorToAllInstances.put(constructor, instances);
                }
                instances.add(current);
            }

            @Override
            public void afterChildren(JetType current) {
                this.result.addFirst(current.getConstructor());
            }
        });
    }

    public static TypeSubstitutor makeConstantSubstitutor(Collection<TypeParameterDescriptor> typeParameterDescriptors, JetType type) {
        final HashSet<TypeConstructor> constructors = Sets.newHashSet();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
            constructors.add(typeParameterDescriptor.getTypeConstructor());
        }
        final TypeProjectionImpl projection = new TypeProjectionImpl(type);
        return TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                if (constructors.contains(key)) {
                    return projection;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        });
    }

    public static TypeSubstitutor makeSubstitutorForTypeParametersMap(final @NotNull Map<TypeParameterDescriptor, TypeProjection> substitutionContext) {
        if (substitutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionContext", "org/jetbrains/jet/lang/types/TypeUtils", "makeSubstitutorForTypeParametersMap"));
        }
        return TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            @Nullable
            public TypeProjection get(TypeConstructor key) {
                ClassifierDescriptor declarationDescriptor = key.getDeclarationDescriptor();
                if (declarationDescriptor instanceof TypeParameterDescriptor) {
                    TypeParameterDescriptor descriptor = (TypeParameterDescriptor)declarationDescriptor;
                    return (TypeProjection)substitutionContext.get(descriptor);
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return substitutionContext.isEmpty();
            }

            public String toString() {
                return substitutionContext.toString();
            }
        });
    }

    private static class NotNullType
    extends AbstractTypeWithKnownNullability {
        private NotNullType(@NotNull JetType delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/lang/types/TypeUtils$NotNullType", "<init>"));
            }
            super(delegate);
        }

        @Override
        public boolean isNullable() {
            return false;
        }
    }

    private static class NullableType
    extends AbstractTypeWithKnownNullability {
        private NullableType(@NotNull JetType delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/lang/types/TypeUtils$NullableType", "<init>"));
            }
            super(delegate);
        }

        @Override
        public boolean isNullable() {
            return true;
        }
    }

    private static abstract class AbstractTypeWithKnownNullability
    extends AbstractJetType {
        private final JetType delegate;

        private AbstractTypeWithKnownNullability(@NotNull JetType delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/lang/types/TypeUtils$AbstractTypeWithKnownNullability", "<init>"));
            }
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            TypeConstructor typeConstructor = this.delegate.getConstructor();
            if (typeConstructor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils$AbstractTypeWithKnownNullability", "getConstructor"));
            }
            return typeConstructor;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            List<TypeProjection> list2 = this.delegate.getArguments();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils$AbstractTypeWithKnownNullability", "getArguments"));
            }
            return list2;
        }

        @Override
        public abstract boolean isNullable();

        @Override
        @NotNull
        public JetScope getMemberScope() {
            JetScope jetScope = this.delegate.getMemberScope();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils$AbstractTypeWithKnownNullability", "getMemberScope"));
            }
            return jetScope;
        }

        @Override
        public boolean isError() {
            return this.delegate.isError();
        }

        @Override
        @NotNull
        public List<AnnotationDescriptor> getAnnotations() {
            List<AnnotationDescriptor> list2 = this.delegate.getAnnotations();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeUtils$AbstractTypeWithKnownNullability", "getAnnotations"));
            }
            return list2;
        }
    }

    private static class TypeUnifier {
        private TypeUnifier() {
        }

        public static boolean mayBeEqual(@NotNull JetType type, @NotNull JetType other) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeUtils$TypeUnifier", "mayBeEqual"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/jet/lang/types/TypeUtils$TypeUnifier", "mayBeEqual"));
            }
            return TypeUnifier.unify(type, other);
        }

        private static boolean unify(JetType withParameters, JetType expected) {
            final HashMap<TypeParameterDescriptor, Variance> parameters = Maps.newHashMap();
            Processor<TypeParameterUsage> processor = new Processor<TypeParameterUsage>(){

                @Override
                public boolean process(TypeParameterUsage parameterUsage) {
                    Variance howTheTypeIsUsedBefore = (Variance)((Object)parameters.get(parameterUsage.typeParameterDescriptor));
                    if (howTheTypeIsUsedBefore == null) {
                        howTheTypeIsUsedBefore = Variance.INVARIANT;
                    }
                    parameters.put(parameterUsage.typeParameterDescriptor, parameterUsage.howTheTypeParameterIsUsed.superpose(howTheTypeIsUsedBefore));
                    return true;
                }
            };
            TypeUnifier.processAllTypeParameters(withParameters, Variance.INVARIANT, processor);
            TypeUnifier.processAllTypeParameters(expected, Variance.INVARIANT, processor);
            ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
            constraintSystem.registerTypeVariables(parameters);
            constraintSystem.addSubtypeConstraint(withParameters, expected, ConstraintPosition.SPECIAL);
            return constraintSystem.getStatus().isSuccessful();
        }

        private static void processAllTypeParameters(JetType type, Variance howThiTypeIsUsed, Processor<TypeParameterUsage> result) {
            ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
            if (descriptor instanceof TypeParameterDescriptor) {
                result.process(new TypeParameterUsage((TypeParameterDescriptor)descriptor, howThiTypeIsUsed));
            }
            for (TypeProjection projection : type.getArguments()) {
                TypeUnifier.processAllTypeParameters(projection.getType(), projection.getProjectionKind(), result);
            }
        }

        private static class TypeParameterUsage {
            private final TypeParameterDescriptor typeParameterDescriptor;
            private final Variance howTheTypeParameterIsUsed;

            public TypeParameterUsage(TypeParameterDescriptor typeParameterDescriptor, Variance howTheTypeParameterIsUsed) {
                this.typeParameterDescriptor = typeParameterDescriptor;
                this.howTheTypeParameterIsUsed = howTheTypeParameterIsUsed;
            }
        }
    }

    public static class SpecialType
    implements JetType {
        private final String name;

        public SpecialType(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            throw new IllegalStateException(this.name);
        }

        @Override
        public boolean isNullable() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            throw new IllegalStateException(this.name);
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        @NotNull
        public List<AnnotationDescriptor> getAnnotations() {
            throw new IllegalStateException(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

