/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeWithImports;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.utils.CommonSuppliers;
import org.jetbrains.jet.utils.Printer;

public class WritableScopeImpl
extends WritableScopeWithImports {
    private final Collection<DeclarationDescriptor> allDescriptors;
    private final Multimap<Name, DeclarationDescriptor> declaredDescriptorsAccessibleBySimpleName;
    private boolean allDescriptorsDone;
    @NotNull
    private final DeclarationDescriptor ownerDeclarationDescriptor;
    @Nullable
    private SetMultimap<Name, FunctionDescriptor> functionGroups;
    @Nullable
    private Map<Name, DeclarationDescriptor> variableOrClassDescriptors;
    @Nullable
    private SetMultimap<Name, VariableDescriptor> propertyGroups;
    @Nullable
    private Map<Name, PackageViewDescriptor> packageAliases;
    @Nullable
    private Map<LabelName, List<DeclarationDescriptor>> labelsToDescriptors;
    @Nullable
    private ReceiverParameterDescriptor implicitReceiver;

    public WritableScopeImpl(@NotNull JetScope scope, @NotNull DeclarationDescriptor owner, @NotNull RedeclarationHandler redeclarationHandler, @NotNull String debugName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "<init>"));
        }
        if (redeclarationHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarationHandler", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "<init>"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "<init>"));
        }
        super(scope, redeclarationHandler, debugName);
        this.allDescriptors = Lists.newArrayList();
        this.declaredDescriptorsAccessibleBySimpleName = HashMultimap.create();
        this.allDescriptorsDone = false;
        this.ownerDeclarationDescriptor = owner;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.ownerDeclarationDescriptor;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    public void importScope(@NotNull JetScope imported) {
        if (imported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imported", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "importScope"));
        }
        this.checkMayWrite();
        super.importScope(imported);
    }

    @Override
    public void importClassifierAlias(@NotNull Name importedClassifierName, @NotNull ClassifierDescriptor classifierDescriptor) {
        if (importedClassifierName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedClassifierName", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "importClassifierAlias"));
        }
        if (classifierDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifierDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "importClassifierAlias"));
        }
        this.checkMayWrite();
        this.allDescriptors.add(classifierDescriptor);
        super.importClassifierAlias(importedClassifierName, classifierDescriptor);
    }

    @Override
    public void importPackageAlias(@NotNull Name aliasName, @NotNull PackageViewDescriptor packageView) {
        if (aliasName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasName", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "importPackageAlias"));
        }
        if (packageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageView", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "importPackageAlias"));
        }
        this.checkMayWrite();
        this.allDescriptors.add(packageView);
        super.importPackageAlias(aliasName, packageView);
    }

    @Override
    public void importFunctionAlias(@NotNull Name aliasName, @NotNull FunctionDescriptor functionDescriptor) {
        if (aliasName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasName", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "importFunctionAlias"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "importFunctionAlias"));
        }
        this.checkMayWrite();
        this.addFunctionDescriptor(functionDescriptor);
        super.importFunctionAlias(aliasName, functionDescriptor);
    }

    @Override
    public void importVariableAlias(@NotNull Name aliasName, @NotNull VariableDescriptor variableDescriptor) {
        if (aliasName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasName", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "importVariableAlias"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "importVariableAlias"));
        }
        this.checkMayWrite();
        this.addPropertyDescriptor(variableDescriptor);
        super.importVariableAlias(aliasName, variableDescriptor);
    }

    @Override
    public void clearImports() {
        this.checkMayWrite();
        super.clearImports();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        this.checkMayRead();
        if (!this.allDescriptorsDone) {
            this.allDescriptorsDone = true;
            this.changeLockLevel(WritableScope.LockLevel.READING);
            this.allDescriptors.addAll(this.getWorkerScope().getAllDescriptors());
            for (JetScope imported : this.getImports()) {
                this.allDescriptors.addAll(imported.getAllDescriptors());
            }
        }
        Collection<DeclarationDescriptor> collection = this.allDescriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getAllDescriptors"));
        }
        return collection;
    }

    @NotNull
    private Map<LabelName, List<DeclarationDescriptor>> getLabelsToDescriptors() {
        if (this.labelsToDescriptors == null) {
            this.labelsToDescriptors = new HashMap<LabelName, List<DeclarationDescriptor>>();
        }
        Map<LabelName, List<DeclarationDescriptor>> map = this.labelsToDescriptors;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getLabelsToDescriptors"));
        }
        return map;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getDeclarationsByLabel"));
        }
        this.checkMayRead();
        Collection<DeclarationDescriptor> superResult = super.getDeclarationsByLabel(labelName);
        Map<LabelName, List<DeclarationDescriptor>> labelsToDescriptors = this.getLabelsToDescriptors();
        List<DeclarationDescriptor> declarationDescriptors = labelsToDescriptors.get(labelName);
        if (declarationDescriptors == null) {
            Collection<DeclarationDescriptor> collection = superResult;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getDeclarationsByLabel"));
            }
            return collection;
        }
        if (superResult.isEmpty()) {
            List<DeclarationDescriptor> list2 = declarationDescriptors;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getDeclarationsByLabel"));
            }
            return list2;
        }
        ArrayList<DeclarationDescriptor> result = new ArrayList<DeclarationDescriptor>(declarationDescriptors);
        result.addAll(superResult);
        ArrayList<DeclarationDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getDeclarationsByLabel"));
        }
        return arrayList;
    }

    @Override
    public void addLabeledDeclaration(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addLabeledDeclaration"));
        }
        this.checkMayWrite();
        Map<LabelName, List<DeclarationDescriptor>> labelsToDescriptors = this.getLabelsToDescriptors();
        LabelName name = new LabelName(descriptor.getName().asString());
        List<DeclarationDescriptor> declarationDescriptors = labelsToDescriptors.get(name);
        if (declarationDescriptors == null) {
            declarationDescriptors = new ArrayList<DeclarationDescriptor>();
            labelsToDescriptors.put(name, declarationDescriptors);
        }
        declarationDescriptors.add(descriptor);
    }

    @NotNull
    private Map<Name, DeclarationDescriptor> getVariableOrClassDescriptors() {
        if (this.variableOrClassDescriptors == null) {
            this.variableOrClassDescriptors = Maps.newHashMap();
        }
        Map<Name, DeclarationDescriptor> map = this.variableOrClassDescriptors;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getVariableOrClassDescriptors"));
        }
        return map;
    }

    @NotNull
    private Map<Name, PackageViewDescriptor> getPackageAliases() {
        if (this.packageAliases == null) {
            this.packageAliases = Maps.newHashMap();
        }
        Map<Name, PackageViewDescriptor> map = this.packageAliases;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getPackageAliases"));
        }
        return map;
    }

    @Override
    public void addVariableDescriptor(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addVariableDescriptor"));
        }
        this.addVariableDescriptor(variableDescriptor, false);
    }

    @Override
    public void addPropertyDescriptor(@NotNull VariableDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addPropertyDescriptor"));
        }
        this.addVariableDescriptor(propertyDescriptor, true);
    }

    private void addVariableDescriptor(@NotNull VariableDescriptor variableDescriptor, boolean isProperty) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addVariableDescriptor"));
        }
        this.checkMayWrite();
        Name name = variableDescriptor.getName();
        if (isProperty) {
            this.checkForPropertyRedeclaration(name, variableDescriptor);
            this.getPropertyGroups().put(name, variableDescriptor);
        }
        if (variableDescriptor.getReceiverParameter() == null) {
            this.checkForRedeclaration(name, variableDescriptor);
            this.getVariableOrClassDescriptors().put(name, variableDescriptor);
        }
        this.allDescriptors.add(variableDescriptor);
        this.addToDeclared(variableDescriptor);
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getProperties"));
        }
        this.checkMayRead();
        LinkedHashSet<VariableDescriptor> result = Sets.newLinkedHashSet(this.getPropertyGroups().get(name));
        result.addAll(this.getWorkerScope().getProperties(name));
        result.addAll(super.getProperties(name));
        LinkedHashSet<VariableDescriptor> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getProperties"));
        }
        return linkedHashSet;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getLocalVariable"));
        }
        this.checkMayRead();
        Map<Name, DeclarationDescriptor> variableClassOrNamespaceDescriptors = this.getVariableOrClassDescriptors();
        DeclarationDescriptor descriptor = variableClassOrNamespaceDescriptors.get(name);
        if (descriptor instanceof VariableDescriptor && !this.getPropertyGroups().get(name).contains(descriptor)) {
            return (VariableDescriptor)descriptor;
        }
        VariableDescriptor variableDescriptor = this.getWorkerScope().getLocalVariable(name);
        if (variableDescriptor != null) {
            return variableDescriptor;
        }
        return super.getLocalVariable(name);
    }

    @NotNull
    private SetMultimap<Name, VariableDescriptor> getPropertyGroups() {
        if (this.propertyGroups == null) {
            this.propertyGroups = CommonSuppliers.newLinkedHashSetHashSetMultimap();
        }
        SetMultimap<Name, VariableDescriptor> setMultimap = this.propertyGroups;
        if (setMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getPropertyGroups"));
        }
        return setMultimap;
    }

    @NotNull
    private SetMultimap<Name, FunctionDescriptor> getFunctionGroups() {
        if (this.functionGroups == null) {
            this.functionGroups = CommonSuppliers.newLinkedHashSetHashSetMultimap();
        }
        SetMultimap<Name, FunctionDescriptor> setMultimap = this.functionGroups;
        if (setMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getFunctionGroups"));
        }
        return setMultimap;
    }

    @Override
    public void addFunctionDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addFunctionDescriptor"));
        }
        this.checkMayWrite();
        this.getFunctionGroups().put(functionDescriptor.getName(), functionDescriptor);
        this.allDescriptors.add(functionDescriptor);
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getFunctions"));
        }
        this.checkMayRead();
        LinkedHashSet<FunctionDescriptor> result = Sets.newLinkedHashSet(this.getFunctionGroups().get(name));
        result.addAll(this.getWorkerScope().getFunctions(name));
        result.addAll(super.getFunctions(name));
        LinkedHashSet<FunctionDescriptor> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getFunctions"));
        }
        return linkedHashSet;
    }

    @Override
    public void addTypeParameterDescriptor(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addTypeParameterDescriptor"));
        }
        this.checkMayWrite();
        Name name = typeParameterDescriptor.getName();
        this.addClassifierAlias(name, typeParameterDescriptor);
    }

    @Override
    public void addClassifierDescriptor(@NotNull ClassifierDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addClassifierDescriptor"));
        }
        this.checkMayWrite();
        this.addClassifierAlias(classDescriptor.getName(), classDescriptor);
    }

    @Override
    public void addClassifierAlias(@NotNull Name name, @NotNull ClassifierDescriptor classifierDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addClassifierAlias"));
        }
        if (classifierDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifierDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addClassifierAlias"));
        }
        this.checkMayWrite();
        this.checkForRedeclaration(name, classifierDescriptor);
        this.getVariableOrClassDescriptors().put(name, classifierDescriptor);
        this.allDescriptors.add(classifierDescriptor);
        this.addToDeclared(classifierDescriptor);
    }

    @Override
    public void addPackageAlias(@NotNull Name name, @NotNull PackageViewDescriptor packageView) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addPackageAlias"));
        }
        if (packageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageView", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addPackageAlias"));
        }
        this.checkMayWrite();
        this.checkForRedeclaration(name, packageView);
        this.getPackageAliases().put(name, packageView);
        this.allDescriptors.add(packageView);
        this.addToDeclared(packageView);
    }

    @Override
    public void addFunctionAlias(@NotNull Name name, @NotNull FunctionDescriptor functionDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addFunctionAlias"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addFunctionAlias"));
        }
        this.checkMayWrite();
        this.checkForRedeclaration(name, functionDescriptor);
        this.getFunctionGroups().put(name, functionDescriptor);
        this.allDescriptors.add(functionDescriptor);
    }

    @Override
    public void addVariableAlias(@NotNull Name name, @NotNull VariableDescriptor variableDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addVariableAlias"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "addVariableAlias"));
        }
        this.checkMayWrite();
        this.checkForRedeclaration(name, variableDescriptor);
        this.getVariableOrClassDescriptors().put(name, variableDescriptor);
        this.allDescriptors.add(variableDescriptor);
        this.addToDeclared(variableDescriptor);
    }

    private void checkForPropertyRedeclaration(@NotNull Name name, VariableDescriptor variableDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "checkForPropertyRedeclaration"));
        }
        Set<VariableDescriptor> properties = this.getPropertyGroups().get(name);
        ReceiverParameterDescriptor receiverParameter = variableDescriptor.getReceiverParameter();
        for (VariableDescriptor oldProperty : properties) {
            ReceiverParameterDescriptor receiverParameterForOldVariable = oldProperty.getReceiverParameter();
            if (receiverParameter == null || receiverParameterForOldVariable == null || !JetTypeChecker.INSTANCE.equalTypes(receiverParameter.getType(), receiverParameterForOldVariable.getType())) continue;
            this.redeclarationHandler.handleRedeclaration(oldProperty, variableDescriptor);
        }
    }

    private void checkForRedeclaration(@NotNull Name name, DeclarationDescriptor classifierDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "checkForRedeclaration"));
        }
        DeclarationDescriptor originalDescriptor = this.getVariableOrClassDescriptors().get(name);
        if (originalDescriptor != null) {
            this.redeclarationHandler.handleRedeclaration(originalDescriptor, classifierDescriptor);
        }
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getClassifier"));
        }
        this.checkMayRead();
        Map<Name, DeclarationDescriptor> variableClassOrNamespaceDescriptors = this.getVariableOrClassDescriptors();
        DeclarationDescriptor descriptor = variableClassOrNamespaceDescriptors.get(name);
        if (descriptor instanceof ClassifierDescriptor) {
            return (ClassifierDescriptor)descriptor;
        }
        ClassifierDescriptor classifierDescriptor = this.getWorkerScope().getClassifier(name);
        if (classifierDescriptor != null) {
            return classifierDescriptor;
        }
        return super.getClassifier(name);
    }

    @Override
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getPackage"));
        }
        this.checkMayRead();
        PackageViewDescriptor aliased = this.getPackageAliases().get(name);
        if (aliased != null) {
            return aliased;
        }
        PackageViewDescriptor packageView = this.getWorkerScope().getPackage(name);
        if (packageView != null) {
            return packageView;
        }
        return super.getPackage(name);
    }

    @Override
    public void setImplicitReceiver(@NotNull ReceiverParameterDescriptor implicitReceiver) {
        if (implicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implicitReceiver", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "setImplicitReceiver"));
        }
        this.checkMayWrite();
        if (this.implicitReceiver != null) {
            throw new UnsupportedOperationException("Receiver redeclared");
        }
        this.implicitReceiver = implicitReceiver;
    }

    @Override
    protected List<ReceiverParameterDescriptor> computeImplicitReceiversHierarchy() {
        ArrayList<ReceiverParameterDescriptor> implicitReceiverHierarchy = Lists.newArrayList();
        if (this.implicitReceiver != null) {
            implicitReceiverHierarchy.add(this.implicitReceiver);
        }
        implicitReceiverHierarchy.addAll(super.computeImplicitReceiversHierarchy());
        return implicitReceiverHierarchy;
    }

    private void addToDeclared(DeclarationDescriptor descriptor) {
        this.declaredDescriptorsAccessibleBySimpleName.put(descriptor.getName(), descriptor);
    }

    @Override
    @NotNull
    public Multimap<Name, DeclarationDescriptor> getDeclaredDescriptorsAccessibleBySimpleName() {
        Multimap<Name, DeclarationDescriptor> multimap = this.declaredDescriptorsAccessibleBySimpleName;
        if (multimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getDeclaredDescriptorsAccessibleBySimpleName"));
        }
        return multimap;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        Collection<DeclarationDescriptor> collection = this.declaredDescriptorsAccessibleBySimpleName.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "getOwnDeclaredDescriptors"));
        }
        return collection;
    }

    @Override
    protected void printAdditionalScopeStructure(@NotNull Printer p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/resolve/scopes/WritableScopeImpl", "printAdditionalScopeStructure"));
        }
        p.println("allDescriptorsDone = ", this.allDescriptorsDone);
    }
}

