/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.LazyDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageMemberScope;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class LazyPackageDescriptor
extends DeclarationDescriptorImpl
implements PackageFragmentDescriptor,
LazyDescriptor {
    private final ResolveSession resolveSession;
    private final ModuleDescriptor module;
    private final JetScope memberScope;
    private final FqName fqName;
    private final PackageMemberDeclarationProvider declarationProvider;

    public LazyPackageDescriptor(@NotNull ModuleDescriptor module, @NotNull FqName fqName, @NotNull ResolveSession resolveSession, @NotNull PackageMemberDeclarationProvider declarationProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "<init>"));
        }
        super(Collections.<AnnotationDescriptor>emptyList(), fqName.shortNameOrSpecial());
        this.resolveSession = resolveSession;
        this.module = module;
        this.fqName = fqName;
        this.declarationProvider = declarationProvider;
        this.memberScope = new LazyPackageMemberScope(resolveSession, declarationProvider, this);
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.memberScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public PackageFragmentProvider getProvider() {
        PackageFragmentProvider packageFragmentProvider = this.resolveSession.getPackageFragmentProvider();
        if (packageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "getProvider"));
        }
        return packageFragmentProvider;
    }

    @Override
    @NotNull
    public ModuleDescriptor getContainingDeclaration() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "getContainingDeclaration"));
        }
        return moduleDescriptor;
    }

    @Override
    @Nullable
    public DeclarationDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "substitute"));
        }
        return this;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitPackageFragmentDescriptor(this, data2);
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName = this.fqName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "getFqName"));
        }
        return fqName;
    }

    @Override
    public void forceResolveAllContents() {
        ForceResolveUtil.forceResolveAllContents(this.memberScope);
    }

    @NotNull
    public PackageMemberDeclarationProvider getDeclarationProvider() {
        PackageMemberDeclarationProvider packageMemberDeclarationProvider = this.declarationProvider;
        if (packageMemberDeclarationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyPackageDescriptor", "getDeclarationProvider"));
        }
        return packageMemberDeclarationProvider;
    }
}

