/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBufUtil;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaPackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.kotlin.AnnotationDescriptorDeserializer;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassHeader;
import org.jetbrains.jet.lang.resolve.kotlin.header.SerializedDataHeader;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public final class DeserializedDescriptorResolver {
    private AnnotationDescriptorDeserializer annotationDeserializer;
    private final LockBasedStorageManager storageManager = new LockBasedStorageManager();
    private JavaPackageFragmentProvider javaPackageFragmentProvider;
    private JavaClassResolver javaClassResolver;
    private ErrorReporter errorReporter;
    @NotNull
    private final DescriptorFinder javaDescriptorFinder = new DescriptorFinder(){

        @Override
        @Nullable
        public ClassDescriptor findClass(@NotNull ClassId classId) {
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver$1", "findClass"));
            }
            return DeserializedDescriptorResolver.this.javaClassResolver.resolveClass(DeserializedResolverUtils.kotlinFqNameToJavaFqName(classId.asSingleFqName()), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
        }

        @Override
        @NotNull
        public Collection<Name> getClassNames(@NotNull FqName packageName) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver$1", "getClassNames"));
            }
            Collection<Name> collection = DeserializedDescriptorResolver.this.javaPackageFragmentProvider.getClassNamesInPackage(packageName);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver$1", "getClassNames"));
            }
            return collection;
        }
    };

    public void setAnnotationDeserializer(AnnotationDescriptorDeserializer annotationDeserializer) {
        this.annotationDeserializer = annotationDeserializer;
    }

    public void setJavaPackageFragmentProvider(JavaPackageFragmentProvider javaPackageFragmentProvider) {
        this.javaPackageFragmentProvider = javaPackageFragmentProvider;
    }

    public void setJavaClassResolver(JavaClassResolver javaClassResolver) {
        this.javaClassResolver = javaClassResolver;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "resolveClass"));
        }
        String[] data2 = this.readData(kotlinClass, SerializedDataHeader.Kind.CLASS);
        if (data2 != null) {
            ClassData classData = JavaProtoBufUtil.readClassDataFrom(data2);
            return new DeserializedClassDescriptor(this.storageManager, this.annotationDeserializer, this.javaDescriptorFinder, this.javaPackageFragmentProvider, classData.getNameResolver(), classData.getClassProto());
        }
        return null;
    }

    @Nullable
    public JetScope createKotlinPackageScope(@NotNull PackageFragmentDescriptor descriptor, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        String[] data2 = this.readData(kotlinClass, SerializedDataHeader.Kind.PACKAGE);
        if (data2 != null) {
            return new DeserializedPackageMemberScope(this.storageManager, descriptor, this.annotationDeserializer, this.javaDescriptorFinder, JavaProtoBufUtil.readPackageDataFrom(data2));
        }
        return null;
    }

    @Nullable
    private String[] readData(@NotNull KotlinJvmBinaryClass kotlinClass, @NotNull SerializedDataHeader.Kind expectedKind) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        if (expectedKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKind", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        KotlinClassHeader header = KotlinClassHeader.read(kotlinClass);
        if (header instanceof SerializedDataHeader) {
            SerializedDataHeader serializedDataHeader = (SerializedDataHeader)header;
            if (serializedDataHeader.getKind() != expectedKind) {
                return null;
            }
            return serializedDataHeader.getAnnotationData();
        }
        if (header != null) {
            this.errorReporter.reportIncompatibleAbiVersion(kotlinClass, header.getVersion());
        }
        return null;
    }
}

