/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaPackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.SamConstructorDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.ProgressChecker;
import org.jetbrains.jet.lang.resolve.java.scope.JavaBaseScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaPackageFragmentScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaPurePackageScope
extends JavaBaseScope
implements JavaPackageFragmentScope {
    @NotNull
    private final JavaPackage javaPackage;
    @NotNull
    private final FqName packageFQN;
    private final boolean includeCompiledKotlinClasses;

    public JavaPurePackageScope(@NotNull PackageFragmentDescriptor descriptor, @NotNull JavaPackage javaPackage, @NotNull FqName packageFQN, @NotNull JavaMemberResolver memberResolver, boolean includeCompiledKotlinClasses) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "<init>"));
        }
        if (javaPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaPackage", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "<init>"));
        }
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "<init>"));
        }
        if (memberResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberResolver", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "<init>"));
        }
        super(descriptor, memberResolver, MembersProvider.forPackage(javaPackage));
        this.javaPackage = javaPackage;
        this.packageFQN = packageFQN;
        this.includeCompiledKotlinClasses = includeCompiledKotlinClasses;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "getClassifier"));
        }
        return this.memberResolver.resolveClass(this.packageFQN.child(name), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        Collection<DeclarationDescriptor> result = super.computeAllDescriptors();
        result.addAll(this.computeAllPackageDeclarations());
        Collection<DeclarationDescriptor> collection = result;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "computeAllDescriptors"));
        }
        return collection;
    }

    @NotNull
    private Collection<DeclarationDescriptor> computeAllPackageDeclarations() {
        HashSet<DeclarationDescriptor> result = new HashSet<DeclarationDescriptor>();
        for (JavaClass javaClass : DescriptorResolverUtils.getClassesInPackage(this.javaPackage)) {
            ClassDescriptor classDescriptor;
            if (DescriptorResolverUtils.isCompiledKotlinPackageClass(javaClass) || !this.includeCompiledKotlinClasses && DescriptorResolverUtils.isCompiledKotlinClass(javaClass) || javaClass.getOriginKind() == JavaClass.OriginKind.KOTLIN_LIGHT_CLASS || javaClass.getVisibility() == Visibilities.PRIVATE) continue;
            ProgressChecker.getInstance().checkCanceled();
            FqName fqName = javaClass.getFqName();
            if (fqName == null || (classDescriptor = this.memberResolver.resolveClass(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES)) == null) continue;
            result.add(classDescriptor);
        }
        HashSet<DeclarationDescriptor> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "computeAllPackageDeclarations"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    protected Set<FunctionDescriptor> computeFunctionDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "computeFunctionDescriptor"));
        }
        NamedMembers members = this.membersProvider.get(name);
        if (members == null) {
            Set<FunctionDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "computeFunctionDescriptor"));
            }
            return set;
        }
        SamConstructorDescriptor samConstructor = JavaFunctionResolver.resolveSamConstructor((JavaPackageFragmentDescriptor)this.descriptor, members);
        if (samConstructor == null) {
            Set<FunctionDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "computeFunctionDescriptor"));
            }
            return set;
        }
        Set<FunctionDescriptor> set = Collections.singleton(samConstructor);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "computeFunctionDescriptor"));
        }
        return set;
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        List<ClassDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "computeInnerClasses"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackages() {
        ArrayList<FqName> result = Lists.newArrayList();
        for (JavaPackage subPackage : this.javaPackage.getSubPackages()) {
            result.add(subPackage.getFqName());
        }
        for (JavaClass javaClass : DescriptorResolverUtils.getClassesInPackage(this.javaPackage)) {
            if (!DescriptorResolverUtils.isJavaClassVisibleAsPackage(javaClass)) continue;
            result.add(javaClass.getFqName());
        }
        ArrayList<FqName> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaPurePackageScope", "getSubPackages"));
        }
        return arrayList;
    }
}

