/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaPackageFragmentScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class JavaClassStaticMembersScope
extends JavaClassMembersScope
implements JavaPackageFragmentScope {
    @NotNull
    private final JavaClass javaClass;

    public JavaClassStaticMembersScope(@NotNull PackageFragmentDescriptor descriptor, @NotNull JavaClass javaClass, @NotNull JavaMemberResolver memberResolver) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "<init>"));
        }
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "<init>"));
        }
        if (memberResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberResolver", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "<init>"));
        }
        super((ClassOrNamespaceDescriptor)descriptor, MembersProvider.forClass(javaClass, true), memberResolver);
        this.javaClass = javaClass;
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        List<ClassDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "computeInnerClasses"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackages() {
        ArrayList<FqName> result = Lists.newArrayList();
        for (JavaClass nested : this.javaClass.getInnerClasses()) {
            if (!DescriptorResolverUtils.isJavaClassVisibleAsPackage(nested)) continue;
            result.add(nested.getFqName());
        }
        ArrayList<FqName> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/JavaClassStaticMembersScope", "getSubPackages"));
        }
        return arrayList;
    }
}

