/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.AnnotationUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationArgumentResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaElement;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

public class TraceBasedJavaResolverCache
implements JavaResolverCache {
    private static final Logger LOG = Logger.getInstance(TraceBasedJavaResolverCache.class);
    private static final FqName ASSERT_INVISIBLE_IN_RESOLVER_ANNOTATION = DescriptorResolverUtils.fqNameByClass(AssertInvisibleInResolver.class);
    private BindingTrace trace;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    @Override
    @Nullable
    public ClassDescriptor getClassResolvedFromSource(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "getClassResolvedFromSource"));
        }
        return this.trace.get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, fqName.toUnsafe());
    }

    @Override
    @Nullable
    public SimpleFunctionDescriptor getMethod(@NotNull JavaMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "getMethod"));
        }
        return this.trace.get(BindingContext.FUNCTION, ((JavaMethodImpl)method).getPsi());
    }

    @Override
    @Nullable
    public ConstructorDescriptor getConstructor(@NotNull JavaElement constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "getConstructor"));
        }
        return this.trace.get(BindingContext.CONSTRUCTOR, ((JavaElementImpl)constructor).getPsi());
    }

    @Override
    @Nullable
    public ClassDescriptor getClass(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "getClass"));
        }
        FqName fqName = javaClass.getFqName();
        if (fqName != null && KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.equals(fqName.parent()) && javaClass.findAnnotation(ASSERT_INVISIBLE_IN_RESOLVER_ANNOTATION) != null) {
            if (ApplicationManager.getApplication().isInternal()) {
                LOG.error("Classpath is configured incorrectly: class " + fqName + " from runtime must not be loaded by compiler");
            }
            return null;
        }
        return this.trace.get(BindingContext.CLASS, ((JavaClassImpl)javaClass).getPsi());
    }

    @Override
    public void recordMethod(@NotNull JavaMethod method, @NotNull SimpleFunctionDescriptor descriptor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "recordMethod"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "recordMethod"));
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(this.trace, ((JavaMethodImpl)method).getPsi(), descriptor);
    }

    @Override
    public void recordConstructor(@NotNull JavaElement element, @NotNull ConstructorDescriptor descriptor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "recordConstructor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "recordConstructor"));
        }
        this.trace.record(BindingContext.CONSTRUCTOR, ((JavaElementImpl)element).getPsi(), descriptor);
    }

    @Override
    public void recordField(@NotNull JavaField field, @NotNull PropertyDescriptor descriptor) {
        CompileTimeConstant<?> constant;
        PsiExpression initializer;
        Object evaluatedExpression;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "recordField"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "recordField"));
        }
        PsiField psiField = (PsiField)((JavaFieldImpl)field).getPsi();
        this.trace.record(BindingContext.VARIABLE, psiField, descriptor);
        if (AnnotationUtils.isPropertyCompileTimeConstant(descriptor) && (evaluatedExpression = JavaConstantExpressionEvaluator.computeConstantExpression(initializer = psiField.getInitializer(), false)) != null && (constant = JavaAnnotationArgumentResolver.resolveCompileTimeConstantValue(evaluatedExpression, descriptor.getType())) != null) {
            this.trace.record(BindingContext.COMPILE_TIME_INITIALIZER, descriptor, constant);
        }
    }

    @Override
    public void recordClass(@NotNull JavaClass javaClass, @NotNull ClassDescriptor descriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "recordClass"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedJavaResolverCache", "recordClass"));
        }
        this.trace.record(BindingContext.CLASS, ((JavaClassImpl)javaClass).getPsi(), descriptor);
    }
}

