/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Maps;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinder;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaPackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaPackageFragmentDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaPackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaFullPackageScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaPackageFragmentScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaPurePackageScope;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public final class JavaPackageFragmentProviderImpl
implements JavaPackageFragmentProvider {
    @NotNull
    private final Map<FqName, JavaPackageFragmentDescriptorImpl> packageFragments = Maps.newHashMap();
    private JavaDescriptorResolver javaDescriptorResolver;
    private JavaClassFinder javaClassFinder;
    private JavaResolverCache cache;
    private JavaMemberResolver memberResolver;
    private DeserializedDescriptorResolver deserializedDescriptorResolver;
    private KotlinClassFinder kotlinClassFinder;
    private ModuleDescriptor module;

    public void setJavaDescriptorResolver(@NotNull JavaDescriptorResolver javaDescriptorResolver) {
        if (javaDescriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaDescriptorResolver", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "setJavaDescriptorResolver"));
        }
        this.javaDescriptorResolver = javaDescriptorResolver;
    }

    public void setKotlinClassFinder(KotlinClassFinder kotlinClassFinder) {
        this.kotlinClassFinder = kotlinClassFinder;
    }

    public void setJavaClassFinder(JavaClassFinder javaClassFinder) {
        this.javaClassFinder = javaClassFinder;
    }

    public void setCache(JavaResolverCache cache) {
        this.cache = cache;
    }

    public void setMemberResolver(@NotNull JavaMemberResolver memberResolver) {
        if (memberResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberResolver", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "setMemberResolver"));
        }
        this.memberResolver = memberResolver;
    }

    public void setDeserializedDescriptorResolver(DeserializedDescriptorResolver deserializedDescriptorResolver) {
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }

    public void setModule(ModuleDescriptor module) {
        this.module = module;
    }

    @Override
    @NotNull
    public JavaDescriptorResolver getJavaDescriptorResolver() {
        JavaDescriptorResolver javaDescriptorResolver = this.javaDescriptorResolver;
        if (javaDescriptorResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getJavaDescriptorResolver"));
        }
        return javaDescriptorResolver;
    }

    @Override
    @NotNull
    public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getPackageFragments"));
        }
        List<PackageFragmentDescriptor> list2 = ContainerUtil.createMaybeSingletonList(this.getPackageFragment(fqName));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getPackageFragments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getSubPackagesOf"));
        }
        JavaPackageFragmentDescriptorImpl packageFragment = this.getPackageFragment(fqName);
        if (packageFragment == null) {
            List<FqName> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getSubPackagesOf"));
            }
            return list2;
        }
        Collection<FqName> collection = packageFragment.getMemberScope().getSubPackages();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getSubPackagesOf"));
        }
        return collection;
    }

    @Override
    @Nullable
    public JavaPackageFragmentDescriptorImpl getPackageFragment(final @NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getPackageFragment"));
        }
        if (this.packageFragments.containsKey(fqName)) {
            return this.packageFragments.get(fqName);
        }
        JavaPackageFragmentDescriptorImpl packageFragment = JavaPackageFragmentDescriptorImpl.create(this, fqName, new NullableFunction<JavaPackageFragmentDescriptor, JavaPackageFragmentScope>(){

            @Override
            @Nullable
            public JavaPackageFragmentScope fun(JavaPackageFragmentDescriptor packageFragment) {
                return JavaPackageFragmentProviderImpl.this.createPackageScope(fqName, packageFragment);
            }
        });
        this.packageFragments.put(fqName, packageFragment);
        return packageFragment;
    }

    @Nullable
    private JavaPackageFragmentScope createPackageScope(@NotNull FqName fqName, @NotNull PackageFragmentDescriptor packageFragment) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "createPackageScope"));
        }
        if (packageFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragment", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "createPackageScope"));
        }
        JavaPackage javaPackage = this.javaClassFinder.findPackage(fqName);
        if (javaPackage != null) {
            JetScope kotlinPackageScope;
            FqName packageClassFqName = PackageClassUtils.getPackageClassFqName(fqName);
            KotlinJvmBinaryClass kotlinClass = this.kotlinClassFinder.find(packageClassFqName);
            if (kotlinClass != null && (kotlinPackageScope = this.deserializedDescriptorResolver.createKotlinPackageScope(packageFragment, kotlinClass)) != null) {
                return new JavaFullPackageScope(packageFragment, kotlinPackageScope, new JavaPurePackageScope(packageFragment, javaPackage, fqName, this.memberResolver, false));
            }
            return new JavaPurePackageScope(packageFragment, javaPackage, fqName, this.memberResolver, true);
        }
        JavaClass javaClass = this.javaClassFinder.findClass(fqName);
        if (javaClass != null && DescriptorResolverUtils.isJavaClassVisibleAsPackage(javaClass)) {
            return new JavaClassStaticMembersScope(packageFragment, javaClass, this.memberResolver);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<Name> getClassNamesInPackage(@NotNull FqName packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getClassNamesInPackage"));
        }
        JavaPackage javaPackage = this.javaClassFinder.findPackage(packageName);
        if (javaPackage == null) {
            List<Name> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getClassNamesInPackage"));
            }
            return list2;
        }
        Collection<JavaClass> classes = DescriptorResolverUtils.getClassesInPackage(javaPackage);
        ArrayList<Name> result = new ArrayList<Name>(classes.size());
        for (JavaClass javaClass : classes) {
            if (DescriptorResolverUtils.isCompiledKotlinPackageClass(javaClass)) continue;
            result.add(javaClass.getName());
        }
        ArrayList<Name> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getClassNamesInPackage"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ModuleDescriptor getModule() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaPackageFragmentProviderImpl", "getModule"));
        }
        return moduleDescriptor;
    }
}

