/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.descriptor;

import com.intellij.util.NullableFunction;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaPackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaPackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaPackageFragmentScope;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class JavaPackageFragmentDescriptorImpl
extends DeclarationDescriptorImpl
implements JavaPackageFragmentDescriptor {
    private final JavaPackageFragmentProvider provider;
    private final FqName fqName;
    private final JavaPackageFragmentScope memberScope;

    @Nullable
    public static JavaPackageFragmentDescriptorImpl create(@NotNull JavaPackageFragmentProvider provider, @NotNull FqName fqName, @NotNull NullableFunction<JavaPackageFragmentDescriptor, JavaPackageFragmentScope> scopeFactory) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "create"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "create"));
        }
        if (scopeFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFactory", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "create"));
        }
        JavaPackageFragmentDescriptorImpl descriptor = new JavaPackageFragmentDescriptorImpl(provider, fqName, scopeFactory);
        return descriptor.memberScope == null ? null : descriptor;
    }

    private JavaPackageFragmentDescriptorImpl(@NotNull JavaPackageFragmentProvider provider, @NotNull FqName fqName, @NotNull NullableFunction<JavaPackageFragmentDescriptor, JavaPackageFragmentScope> scopeFactory) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "<init>"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "<init>"));
        }
        if (scopeFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFactory", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "<init>"));
        }
        super(Collections.<AnnotationDescriptor>emptyList(), fqName.shortNameOrSpecial());
        this.provider = provider;
        this.fqName = fqName;
        this.memberScope = scopeFactory.fun(this);
    }

    @Override
    @NotNull
    public JavaPackageFragmentDescriptor.Kind getKind() {
        JavaPackageFragmentDescriptor.Kind kind = this.memberScope instanceof JavaClassStaticMembersScope ? JavaPackageFragmentDescriptor.Kind.CLASS_STATICS : JavaPackageFragmentDescriptor.Kind.PROPER;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "getKind"));
        }
        return kind;
    }

    @Override
    @NotNull
    public JavaDescriptorResolver getJavaDescriptorResolver() {
        JavaDescriptorResolver javaDescriptorResolver = this.provider.getJavaDescriptorResolver();
        if (javaDescriptorResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "getJavaDescriptorResolver"));
        }
        return javaDescriptorResolver;
    }

    @Override
    @NotNull
    public ModuleDescriptor getContainingDeclaration() {
        ModuleDescriptor moduleDescriptor = this.provider.getModule();
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "getContainingDeclaration"));
        }
        return moduleDescriptor;
    }

    @Override
    @Nullable
    public DeclarationDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "substitute"));
        }
        return this;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitPackageFragmentDescriptor(this, data2);
    }

    @Override
    @NotNull
    public JavaPackageFragmentScope getMemberScope() {
        JavaPackageFragmentScope javaPackageFragmentScope = this.memberScope;
        if (javaPackageFragmentScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "getMemberScope"));
        }
        return javaPackageFragmentScope;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName = this.fqName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "getFqName"));
        }
        return fqName;
    }

    @Override
    @NotNull
    public JavaPackageFragmentProvider getProvider() {
        JavaPackageFragmentProvider javaPackageFragmentProvider = this.provider;
        if (javaPackageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaPackageFragmentDescriptorImpl", "getProvider"));
        }
        return javaPackageFragmentProvider;
    }
}

