/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;

public class JavaResolverPsiUtils {
    private JavaResolverPsiUtils() {
    }

    public static boolean isCompiledKotlinClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/resolve/java/JavaResolverPsiUtils", "isCompiledKotlinClass"));
        }
        return DescriptorResolverUtils.isCompiledKotlinClass(new JavaClassImpl(psiClass));
    }

    public static boolean isCompiledKotlinPackageClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/resolve/java/JavaResolverPsiUtils", "isCompiledKotlinPackageClass"));
        }
        return DescriptorResolverUtils.isCompiledKotlinPackageClass(new JavaClassImpl(psiClass));
    }

    public static boolean isCompiledKotlinClassOrPackageClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/resolve/java/JavaResolverPsiUtils", "isCompiledKotlinClassOrPackageClass"));
        }
        return JavaResolverPsiUtils.isCompiledKotlinClass(psiClass) || JavaResolverPsiUtils.isCompiledKotlinPackageClass(psiClass);
    }
}

