/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;

public class AsmTypeConstants {
    private static final Map<Class<?>, Type> TYPES_MAP = new HashMap();
    public static final Type OBJECT_TYPE = AsmTypeConstants.getType(Object.class);
    public static final Type JAVA_STRING_TYPE = AsmTypeConstants.getType(String.class);
    public static final Type JAVA_THROWABLE_TYPE = AsmTypeConstants.getType(Throwable.class);
    public static final Type JAVA_ARRAY_GENERIC_TYPE = AsmTypeConstants.getType(Object[].class);
    public static final Type JET_UNIT_TYPE = Type.getObjectType("jet/Unit");
    public static final Type JET_FUNCTION0_TYPE = Type.getObjectType("jet/Function0");
    public static final Type JET_FUNCTION1_TYPE = Type.getObjectType("jet/Function1");
    public static final Type JET_INT_RANGE_TYPE = Type.getObjectType("jet/IntRange");
    public static final Type JET_SHARED_VAR_TYPE = Type.getObjectType("jet/runtime/SharedVar$Object");
    public static final Type JET_SHARED_INT_TYPE = Type.getObjectType("jet/runtime/SharedVar$Int");
    public static final Type JET_SHARED_DOUBLE_TYPE = Type.getObjectType("jet/runtime/SharedVar$Double");
    public static final Type JET_SHARED_FLOAT_TYPE = Type.getObjectType("jet/runtime/SharedVar$Float");
    public static final Type JET_SHARED_BYTE_TYPE = Type.getObjectType("jet/runtime/SharedVar$Byte");
    public static final Type JET_SHARED_SHORT_TYPE = Type.getObjectType("jet/runtime/SharedVar$Short");
    public static final Type JET_SHARED_CHAR_TYPE = Type.getObjectType("jet/runtime/SharedVar$Char");
    public static final Type JET_SHARED_LONG_TYPE = Type.getObjectType("jet/runtime/SharedVar$Long");
    public static final Type JET_SHARED_BOOLEAN_TYPE = Type.getObjectType("jet/runtime/SharedVar$Boolean");

    public static Type getType(@NotNull Class<?> javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/AsmTypeConstants", "getType"));
        }
        Type type = TYPES_MAP.get(javaClass);
        if (type == null) {
            type = Type.getType(javaClass);
            TYPES_MAP.put(javaClass, type);
        }
        return type;
    }

    private AsmTypeConstants() {
    }
}

