/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.analyzer.AnalyzerFacade;
import org.jetbrains.jet.analyzer.AnalyzerFacadeForEverything;
import org.jetbrains.jet.di.InjectorForJavaDescriptorResolver;
import org.jetbrains.jet.di.InjectorForJavaDescriptorResolverUtil;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.CachedBodiesResolveContext;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinderImpl;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.storage.LockBasedLazyResolveStorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public enum AnalyzerFacadeForJVM implements AnalyzerFacade
{
    INSTANCE;

    public static final List<ImportPath> DEFAULT_IMPORTS;

    @Override
    @NotNull
    public AnalyzeExhaust analyzeFiles(@NotNull Project project, @NotNull Collection<JetFile> files, @NotNull List<AnalyzerScriptParameter> scriptParameters, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameters", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, scriptParameters, filesToAnalyzeCompletely, true);
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        return analyzeExhaust;
    }

    @Override
    @NotNull
    public AnalyzeExhaust analyzeBodiesInFiles(@NotNull Project project, @NotNull List<AnalyzerScriptParameter> scriptParameters, @NotNull Predicate<PsiFile> filesForBodiesResolve, @NotNull BindingTrace headersTraceContext, @NotNull BodiesResolveContext bodiesResolveContext, @NotNull ModuleDescriptor module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameters", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (filesForBodiesResolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesForBodiesResolve", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (headersTraceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headersTraceContext", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForEverything.analyzeBodiesInFilesWithJavaIntegration(project, scriptParameters, filesForBodiesResolve, headersTraceContext, bodiesResolveContext, module);
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        return analyzeExhaust;
    }

    @Override
    @NotNull
    public ResolveSession getLazyResolveSession(@NotNull Project fileProject, @NotNull Collection<JetFile> files) {
        if (fileProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProject", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "getLazyResolveSession"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "getLazyResolveSession"));
        }
        BindingTraceContext javaResolverTrace = new BindingTraceContext();
        InjectorForJavaDescriptorResolver injector = InjectorForJavaDescriptorResolverUtil.create(fileProject, javaResolverTrace);
        ResolveSession resolveSession = AnalyzerFacadeForJVM.createLazyResolveSession(fileProject, files, javaResolverTrace, injector, true);
        if (resolveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "getLazyResolveSession"));
        }
        return resolveSession;
    }

    @NotNull
    public static ResolveSession createLazyResolveSession(@NotNull Project project, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull InjectorForJavaDescriptorResolver injector, boolean addBuiltIns) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        if (injector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injector", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        final JavaClassFinderImpl classFinder = injector.getJavaClassFinder();
        LockBasedLazyResolveStorageManager storageManager = new LockBasedLazyResolveStorageManager();
        FileBasedDeclarationProviderFactory declarationProviderFactory = new FileBasedDeclarationProviderFactory(storageManager, files, new Predicate<FqName>(){

            @Override
            public boolean apply(FqName fqName) {
                return classFinder.findPackage(fqName) != null || KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.equals(fqName);
            }
        });
        ModuleDescriptorImpl module = injector.getModule();
        if (addBuiltIns) {
            module.addFragmentProvider(KotlinBuiltIns.getInstance().getBuiltInsModule().getPackageFragmentProvider());
        }
        ResolveSession resolveSession = new ResolveSession(project, storageManager, module, declarationProviderFactory, trace);
        if (resolveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        return resolveSession;
    }

    public static AnalyzeExhaust analyzeOneFileWithJavaIntegrationAndCheckForErrors(JetFile file, List<AnalyzerScriptParameter> scriptParameters) {
        AnalyzingUtils.checkForSyntacticErrors(file);
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeOneFileWithJavaIntegration(file, scriptParameters);
        AnalyzingUtils.throwExceptionOnErrors(analyzeExhaust.getBindingContext());
        return analyzeExhaust;
    }

    public static AnalyzeExhaust analyzeOneFileWithJavaIntegration(JetFile file, List<AnalyzerScriptParameter> scriptParameters) {
        return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(file.getProject(), Collections.singleton(file), scriptParameters, Predicates.<PsiFile>alwaysTrue());
    }

    public static AnalyzeExhaust analyzeFilesWithJavaIntegrationAndCheckForErrors(Project project, Collection<JetFile> files, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely) {
        for (JetFile file : files) {
            AnalyzingUtils.checkForSyntacticErrors(file);
        }
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, scriptParameters, filesToAnalyzeCompletely, false);
        AnalyzingUtils.throwExceptionOnErrors(analyzeExhaust.getBindingContext());
        return analyzeExhaust;
    }

    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely) {
        return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, scriptParameters, filesToAnalyzeCompletely, false);
    }

    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, boolean storeContextForBodiesResolve) {
        BindingTraceContext bindingTraceContext = new BindingTraceContext();
        return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, bindingTraceContext, scriptParameters, filesToAnalyzeCompletely, storeContextForBodiesResolve);
    }

    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, BindingTrace trace, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, boolean storeContextForBodiesResolve) {
        return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, trace, scriptParameters, filesToAnalyzeCompletely, storeContextForBodiesResolve, AnalyzerFacadeForJVM.createJavaModule("<module>"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, BindingTrace trace, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, boolean storeContextForBodiesResolve, ModuleDescriptorImpl module) {
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(filesToAnalyzeCompletely, false, false, scriptParameters);
        InjectorForTopDownAnalyzerForJvm injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, trace, module);
        try {
            module.addFragmentProvider(injector.getJavaPackageFragmentProvider());
            injector.getTopDownAnalyzer().analyzeFiles(files, scriptParameters);
            CachedBodiesResolveContext bodiesResolveContext = storeContextForBodiesResolve ? new CachedBodiesResolveContext(injector.getTopDownAnalysisContext()) : null;
            AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(trace.getBindingContext(), bodiesResolveContext, module);
            return analyzeExhaust;
        }
        finally {
            injector.destroy();
        }
    }

    @NotNull
    public static ModuleDescriptorImpl createJavaModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createJavaModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, JavaToKotlinClassMap.getInstance());
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createJavaModule"));
        }
        return moduleDescriptorImpl;
    }

    static {
        DEFAULT_IMPORTS = ImmutableList.of(new ImportPath("java.lang.*"), new ImportPath("kotlin.*"), new ImportPath("kotlin.io.*"), new ImportPath("jet.*"));
    }
}

