/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import com.google.common.base.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class IntValue
extends CompileTimeConstant<Integer> {
    public static final Function<Long, IntValue> CREATE = new Function<Long, IntValue>(){

        @Override
        public IntValue apply(@Nullable Long input) {
            assert (input != null);
            return new IntValue(input.intValue());
        }
    };

    public IntValue(int value) {
        super(value);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/jet/lang/resolve/constants/IntValue", "getType"));
        }
        JetType jetType = kotlinBuiltIns.getIntType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitIntValue(this, data2);
    }

    public String toString() {
        return this.value + ".toInt()";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntValue intValue = (IntValue)o;
        return this.value == intValue.value;
    }

    public int hashCode() {
        return (Integer)this.value;
    }
}

