/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import com.google.common.collect.Sets;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CompileTimeConstantChecker {
    private static final Set<DiagnosticFactory> errorsThatDependOnExpectedType = Sets.newHashSet(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH, Errors.NULL_FOR_NONNULL_TYPE);
    private final KotlinBuiltIns builtIns;
    private final BindingTrace trace;
    private final boolean checkOnlyErrorsThatDependOnExpectedType;

    public CompileTimeConstantChecker(@NotNull BindingTrace trace, boolean checkOnlyErrorsThatDependOnExpectedType) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "<init>"));
        }
        this.checkOnlyErrorsThatDependOnExpectedType = checkOnlyErrorsThatDependOnExpectedType;
        this.builtIns = KotlinBuiltIns.getInstance();
        this.trace = trace;
    }

    public boolean checkConstantExpressionType(@Nullable CompileTimeConstant compileTimeConstant, @NotNull JetConstantExpression expression, @NotNull JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkConstantExpressionType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkConstantExpressionType"));
        }
        IElementType elementType = expression.getNode().getElementType();
        if (elementType == JetNodeTypes.INTEGER_CONSTANT) {
            return this.checkIntegerValue(compileTimeConstant, expectedType, expression);
        }
        if (elementType == JetNodeTypes.FLOAT_CONSTANT) {
            return this.checkFloatValue(compileTimeConstant, expectedType, expression);
        }
        if (elementType == JetNodeTypes.BOOLEAN_CONSTANT) {
            return this.checkBooleanValue(expectedType, expression);
        }
        if (elementType == JetNodeTypes.CHARACTER_CONSTANT) {
            return this.checkCharValue(compileTimeConstant, expectedType, expression);
        }
        if (elementType == JetNodeTypes.NULL) {
            return this.checkNullValue(expectedType, expression);
        }
        return false;
    }

    private boolean checkIntegerValue(@Nullable CompileTimeConstant value, @NotNull JetType expectedType, @NotNull JetConstantExpression expression) {
        JetType valueType;
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkIntegerValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkIntegerValue"));
        }
        if (value == null) {
            return this.reportError(Errors.INT_LITERAL_OUT_OF_RANGE.on(expression));
        }
        if (expression.getText().endsWith("l")) {
            return this.reportError(Errors.WRONG_LONG_SUFFIX.on(expression));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !JetTypeChecker.INSTANCE.isSubtypeOf(valueType = value.getType(KotlinBuiltIns.getInstance()), expectedType)) {
            return this.reportError(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression, "integer", expectedType));
        }
        return false;
    }

    private boolean checkFloatValue(@Nullable CompileTimeConstant value, @NotNull JetType expectedType, @NotNull JetConstantExpression expression) {
        JetType valueType;
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkFloatValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkFloatValue"));
        }
        if (value == null) {
            return this.reportError(Errors.FLOAT_LITERAL_OUT_OF_RANGE.on(expression));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !JetTypeChecker.INSTANCE.isSubtypeOf(valueType = value.getType(KotlinBuiltIns.getInstance()), expectedType)) {
            return this.reportError(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression, "floating-point", expectedType));
        }
        return false;
    }

    private boolean checkBooleanValue(@NotNull JetType expectedType, @NotNull JetConstantExpression expression) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkBooleanValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkBooleanValue"));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !JetTypeChecker.INSTANCE.isSubtypeOf(this.builtIns.getBooleanType(), expectedType)) {
            return this.reportError(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression, "boolean", expectedType));
        }
        return false;
    }

    private boolean checkCharValue(CompileTimeConstant<?> constant, JetType expectedType, JetConstantExpression expression) {
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !JetTypeChecker.INSTANCE.isSubtypeOf(this.builtIns.getCharType(), expectedType)) {
            return this.reportError(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression, "character", expectedType));
        }
        if (constant != null) {
            return false;
        }
        CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantChecker.parseCharValue(expression);
        if (compileTimeConstant instanceof ErrorCharValueWithDiagnostic) {
            return this.reportError(((ErrorCharValueWithDiagnostic)compileTimeConstant).getDiagnostic());
        }
        return false;
    }

    private boolean checkNullValue(@NotNull JetType expectedType, @NotNull JetConstantExpression expression) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkNullValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "checkNullValue"));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !expectedType.isNullable()) {
            return this.reportError(Errors.NULL_FOR_NONNULL_TYPE.on(expression, expectedType));
        }
        return false;
    }

    @NotNull
    private static CompileTimeConstant<?> parseCharValue(@NotNull JetConstantExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "parseCharValue"));
        }
        String text = expression.getText();
        if (text.length() < 2 || text.charAt(0) != '\'' || text.charAt(text.length() - 1) != '\'') {
            ErrorValue errorValue = CompileTimeConstantChecker.createErrorValue(Errors.INCORRECT_CHARACTER_LITERAL.on(expression));
            if (errorValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "parseCharValue"));
            }
            return errorValue;
        }
        if ((text = text.substring(1, text.length() - 1)).length() == 0) {
            ErrorValue errorValue = CompileTimeConstantChecker.createErrorValue(Errors.EMPTY_CHARACTER_LITERAL.on(expression));
            if (errorValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "parseCharValue"));
            }
            return errorValue;
        }
        if (text.charAt(0) != '\\') {
            if (text.length() == 1) {
                CharValue charValue = new CharValue(text.charAt(0));
                if (charValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "parseCharValue"));
                }
                return charValue;
            }
            ErrorValue errorValue = CompileTimeConstantChecker.createErrorValue(Errors.TOO_MANY_CHARACTERS_IN_CHARACTER_LITERAL.on(expression, expression));
            if (errorValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "parseCharValue"));
            }
            return errorValue;
        }
        CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantChecker.escapedStringToCharValue(text, expression);
        if (compileTimeConstant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "parseCharValue"));
        }
        return compileTimeConstant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static CompileTimeConstant<?> escapedStringToCharValue(@NotNull String text, @NotNull JetElement expression) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharValue"));
        }
        assert (text.length() > 0 && text.charAt(0) == '\\') : "Only escaped sequences must be passed to this routine: " + text;
        String escape = text.substring(1);
        switch (escape.length()) {
            case 0: {
                CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantChecker.illegalEscape(expression);
                if (compileTimeConstant != null) return compileTimeConstant;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharValue"));
            }
            case 1: {
                Character escaped = CompileTimeConstantChecker.translateEscape(escape.charAt(0));
                if (escaped == null) {
                    CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantChecker.illegalEscape(expression);
                    if (compileTimeConstant != null) return compileTimeConstant;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharValue"));
                }
                CharValue charValue = new CharValue(escaped.charValue());
                if (charValue != null) return charValue;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharValue"));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    Integer intValue = Integer.valueOf(escape.substring(1), 16);
                    CharValue charValue = new CharValue((char)intValue.intValue());
                    if (charValue != null) return charValue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharValue"));
            }
        }
        CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantChecker.illegalEscape(expression);
        if (compileTimeConstant != null) return compileTimeConstant;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharValue"));
    }

    @NotNull
    private static CompileTimeConstant<?> illegalEscape(@NotNull JetElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "illegalEscape"));
        }
        ErrorValue errorValue = CompileTimeConstantChecker.createErrorValue(Errors.ILLEGAL_ESCAPE.on(expression, expression));
        if (errorValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "illegalEscape"));
        }
        return errorValue;
    }

    @NotNull
    private static ErrorValue createErrorValue(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "createErrorValue"));
        }
        ErrorCharValueWithDiagnostic errorCharValueWithDiagnostic = new ErrorCharValueWithDiagnostic(diagnostic);
        if (errorCharValueWithDiagnostic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "createErrorValue"));
        }
        return errorCharValueWithDiagnostic;
    }

    @Nullable
    public static Character parseChar(@NotNull JetConstantExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "parseChar"));
        }
        CompileTimeConstant<?> compileTimeConstant = CompileTimeConstantChecker.parseCharValue(expression);
        if (compileTimeConstant instanceof CharValue) {
            return (Character)((CharValue)compileTimeConstant).getValue();
        }
        return null;
    }

    @Nullable
    private static Character translateEscape(char c) {
        switch (c) {
            case 't': {
                return Character.valueOf('\t');
            }
            case 'b': {
                return Character.valueOf('\b');
            }
            case 'n': {
                return Character.valueOf('\n');
            }
            case 'r': {
                return Character.valueOf('\r');
            }
            case '\'': {
                return Character.valueOf('\'');
            }
            case '\"': {
                return Character.valueOf('\"');
            }
            case '\\': {
                return Character.valueOf('\\');
            }
            case '$': {
                return Character.valueOf('$');
            }
        }
        return null;
    }

    public static boolean noExpectedTypeOrError(JetType expectedType) {
        return TypeUtils.noExpectedType(expectedType) || expectedType.isError();
    }

    private boolean reportError(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker", "reportError"));
        }
        if (!this.checkOnlyErrorsThatDependOnExpectedType || errorsThatDependOnExpectedType.contains(diagnostic.getFactory())) {
            this.trace.report(diagnostic);
            return true;
        }
        return false;
    }

    public static class ErrorCharValueWithDiagnostic
    extends ErrorValue {
        private final Diagnostic diagnostic;

        public ErrorCharValueWithDiagnostic(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker$ErrorCharValueWithDiagnostic", "<init>"));
            }
            this.diagnostic = diagnostic;
        }

        @NotNull
        public Diagnostic getDiagnostic() {
            Diagnostic diagnostic = this.diagnostic;
            if (diagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker$ErrorCharValueWithDiagnostic", "getDiagnostic"));
            }
            return diagnostic;
        }

        @Override
        @NotNull
        public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
            if (kotlinBuiltIns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/jet/lang/resolve/constants/CompileTimeConstantChecker$ErrorCharValueWithDiagnostic", "getType"));
            }
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return DefaultErrorMessages.RENDERER.render(this.diagnostic);
        }
    }
}

