/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastReceiver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public class AutoCastUtils {
    private AutoCastUtils() {
    }

    public static List<ReceiverValue> getAutoCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull ResolutionContext context) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        return AutoCastUtils.getAutoCastVariants(receiverToCast, context.trace.getBindingContext(), context.dataFlowInfo);
    }

    public static List<ReceiverValue> getAutoCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariants"));
        }
        ArrayList<ReceiverValue> variants = Lists.newArrayList();
        variants.add(receiverToCast);
        variants.addAll(AutoCastUtils.getAutoCastVariantsExcludingReceiver(bindingContext, dataFlowInfo, receiverToCast));
        return variants;
    }

    @NotNull
    public static List<ReceiverValue> getAutoCastVariantsExcludingReceiver(@NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiverToCast) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
        }
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
        }
        if (receiverToCast instanceof ThisReceiver) {
            ThisReceiver receiver = (ThisReceiver)receiverToCast;
            assert (receiver.exists());
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver);
            List<ReceiverValue> list2 = AutoCastUtils.collectAutoCastReceiverValues(dataFlowInfo, receiver, dataFlowValue);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
            }
            return list2;
        }
        if (receiverToCast instanceof ExpressionReceiver) {
            ExpressionReceiver receiver = (ExpressionReceiver)receiverToCast;
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver.getExpression(), receiver.getType(), bindingContext);
            List<ReceiverValue> list3 = AutoCastUtils.collectAutoCastReceiverValues(dataFlowInfo, receiver, dataFlowValue);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
            }
            return list3;
        }
        if (receiverToCast instanceof AutoCastReceiver) {
            List<ReceiverValue> list4 = AutoCastUtils.getAutoCastVariantsExcludingReceiver(bindingContext, dataFlowInfo, ((AutoCastReceiver)receiverToCast).getOriginal());
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
            }
            return list4;
        }
        List<ReceiverValue> list5 = Collections.emptyList();
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "getAutoCastVariantsExcludingReceiver"));
        }
        return list5;
    }

    @NotNull
    private static List<ReceiverValue> collectAutoCastReceiverValues(@NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiver, @NotNull DataFlowValue dataFlowValue) {
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        if (dataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowValue", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        Set<JetType> possibleTypes = dataFlowInfo.getPossibleTypes(dataFlowValue);
        ArrayList<ReceiverValue> result = new ArrayList<ReceiverValue>(possibleTypes.size());
        for (JetType possibleType : possibleTypes) {
            result.add(new AutoCastReceiver(receiver, possibleType, dataFlowValue.isStableIdentifier()));
        }
        ArrayList<ReceiverValue> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "collectAutoCastReceiverValues"));
        }
        return arrayList;
    }

    public static void recordAutoCastIfNecessary(ReceiverValue receiver, @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordAutoCastIfNecessary"));
        }
        if (receiver instanceof AutoCastReceiver) {
            AutoCastReceiver autoCastReceiver = (AutoCastReceiver)receiver;
            ReceiverValue original = autoCastReceiver.getOriginal();
            if (original instanceof ExpressionReceiver) {
                JetExpression expression = ((ExpressionReceiver)original).getExpression();
                AutoCastUtils.recordCastOrError(expression, autoCastReceiver.getType(), trace, autoCastReceiver.canCast(), true);
            } else assert (autoCastReceiver.canCast()) : "A non-expression receiver must always be autocastabe: " + original;
        }
    }

    public static void recordAutoCastToNotNullableType(@NotNull ReceiverValue receiver, @NotNull BindingTrace trace) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordAutoCastToNotNullableType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordAutoCastToNotNullableType"));
        }
        if (!(receiver instanceof ExpressionReceiver)) {
            return;
        }
        JetType receiverType = receiver.getType();
        if (!receiverType.isNullable()) {
            return;
        }
        JetType notNullableType = TypeUtils.makeNotNullable(receiverType);
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver, trace.getBindingContext());
        JetExpression expression = ((ExpressionReceiver)receiver).getExpression();
        AutoCastUtils.recordCastOrError(expression, notNullableType, trace, dataFlowValue.isStableIdentifier(), true);
    }

    public static void recordCastOrError(@NotNull JetExpression expression, @NotNull JetType type, @NotNull BindingTrace trace, boolean canBeCasted, boolean recordExpressionType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordCastOrError"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordCastOrError"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "recordCastOrError"));
        }
        if (canBeCasted) {
            trace.record(BindingContext.AUTOCAST, expression, type);
            if (recordExpressionType) {
                trace.record(BindingContext.EXPRESSION_TYPE, expression, type);
            }
        } else {
            trace.report(Errors.AUTOCAST_IMPOSSIBLE.on(expression, type, expression.getText()));
        }
    }

    public static boolean isNotNull(@NotNull ReceiverValue receiver, @NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "isNotNull"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "isNotNull"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastUtils", "isNotNull"));
        }
        if (!receiver.getType().isNullable()) {
            return true;
        }
        List<ReceiverValue> autoCastVariants = AutoCastUtils.getAutoCastVariants(receiver, bindingContext, dataFlowInfo);
        for (ReceiverValue autoCastVariant : autoCastVariants) {
            if (autoCastVariant.getType().isNullable()) continue;
            return true;
        }
        return false;
    }
}

